/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import com.kt.util.UtilString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KMouseEvent;
import jp.kitec.kwt.KPopupMenu;
import jp.kitec.richui.KTabItem;

public class KTabView
extends Panel
implements ActionListener,
FocusListener,
MouseListener {
    protected Vector<KTabItem> mItems;
    private int az = 0;
    protected KPopupMenu mPopup;
    protected KTabItem mCurrentHit;
    protected boolean mDispPop = false;
    protected boolean mTabDir;
    private Color aA;
    private Dimension aB;

    public KTabView(boolean bl, Color color) {
        this.aA = color;
        this.setBackground(color);
        this.mPopup = new KPopupMenu();
        this.add(this.mPopup);
        this.mItems = new Vector();
        this.mTabDir = bl;
        this.aA = color;
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    public void addTab(String string) {
        this.addTab(string, Color.white, Color.lightGray);
    }

    public void addTab(String object, Color color, Color color2) {
        object = new KTabItem((String)object, KFont.getFont((String)"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", (int)0, (float)12.0f), color, color2, this.mTabDir);
        this.setBackground(Color.lightGray);
        this.mItems.addElement((KTabItem)object);
    }

    public void left() {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        int n3 = -2147483647;
        int n4 = Integer.MAX_VALUE;
        KTabItem kTabItem = null;
        for (n2 = 0; n2 < this.mItems.size(); ++n2) {
            KTabItem kTabItem2 = this.mItems.elementAt(n2);
            if (kTabItem == null && kTabItem2.getBound().x >= 0) {
                kTabItem = kTabItem2;
            }
            int n5 = kTabItem2.getBound().x + kTabItem2.getBound().width + KTabItem.SPACE;
            n = kTabItem2.getBound().x - KTabItem.SPACE;
            n3 = n5 > n3 ? n5 : n3;
            n4 = n < n4 ? n : n4;
        }
        n2 = this.mItems.indexOf(kTabItem);
        if (this.mItems.size() > n2 + 1) {
            kTabItem = this.mItems.elementAt(n2 + 1);
        }
        this.az = (n = n3 - n4) < dimension.width ? 0 : (n3 - kTabItem.getBound().width > dimension.width ? -(kTabItem.getBound().x - n4 - KTabItem.SPACE) : dimension.width - n - 1);
        this.update();
        this.updatePos();
        this.repaint();
    }

    public void right() {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        int n3 = -2147483647;
        int n4 = Integer.MAX_VALUE;
        KTabItem kTabItem = null;
        for (n2 = 0; n2 < this.mItems.size(); ++n2) {
            KTabItem kTabItem2 = this.mItems.elementAt(n2);
            if (kTabItem == null && kTabItem2.getBound().x - KTabItem.SPACE >= 0) {
                kTabItem = kTabItem2;
            }
            int n5 = kTabItem2.getBound().x + kTabItem2.getBound().width + KTabItem.SPACE;
            n = kTabItem2.getBound().x - KTabItem.SPACE;
            n3 = n5 > n3 ? n5 : n3;
            n4 = n < n4 ? n : n4;
        }
        n2 = n3 - n4;
        if (n2 < dimension.width) {
            this.az = 0;
        }
        if ((n = this.mItems.indexOf(kTabItem)) > 0) {
            kTabItem = this.mItems.elementAt(n - 1);
        }
        this.az = n3 - kTabItem.getBound().width > 0 ? -(kTabItem.getBound().x - n4 - KTabItem.SPACE) : 0;
        this.update();
        this.updatePos();
        this.repaint();
    }

    public void updatePos() {
        int n;
        Dimension dimension = this.getSize();
        int n2 = -2147483647;
        int n3 = Integer.MAX_VALUE;
        for (n = 0; n < this.mItems.size(); ++n) {
            KTabItem kTabItem = this.mItems.elementAt(n);
            int n4 = kTabItem.getBound().x + kTabItem.getBound().width + KTabItem.SPACE;
            int n5 = kTabItem.getBound().x - KTabItem.SPACE;
            n2 = n4 > n2 ? n4 : n2;
            n3 = n5 < n3 ? n5 : n3;
        }
        n = n2 - n3;
        if (n < dimension.width) {
            this.az = 0;
        }
    }

    public void update() {
        if (this.isUpdate()) {
            this.create();
        }
        Dimension dimension = this.getSize();
        int n = KTabItem.SPACE;
        for (int i = 0; i < this.mItems.size(); ++i) {
            KTabItem kTabItem = this.mItems.elementAt(i);
            kTabItem.updateBound();
            kTabItem.getBound().x = this.az + n;
            kTabItem.getBound().height = dimension.height - KTabItem.SPACE / 2;
            n += kTabItem.getBound().width;
            kTabItem.getBound().y = this.mTabDir ? dimension.height - kTabItem.getBound().height : 0;
        }
    }

    public void update(Graphics graphics) {
        KTabItem kTabItem;
        int n;
        Dimension dimension = this.getSize();
        if (this.aB == null || this.aB.width != dimension.width || this.aB.height != dimension.height) {
            this.aB = dimension;
            this.update();
        }
        graphics.setColor(this.aA);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        for (n = 0; n < this.mItems.size(); ++n) {
            kTabItem = this.mItems.elementAt(n);
            if (kTabItem.isActive()) continue;
            kTabItem.paint(graphics);
        }
        this.drawBorder(graphics);
        for (n = 0; n < this.mItems.size(); ++n) {
            kTabItem = this.mItems.elementAt(n);
            if (!kTabItem.isActive()) continue;
            kTabItem.paint(graphics);
        }
    }

    protected void drawBorder(Graphics graphics) {
        graphics.setColor(Color.gray);
        Dimension dimension = this.getSize();
        if (this.mTabDir) {
            graphics.drawLine(0, dimension.height - 1, this.getSize().width, dimension.height - 1);
            return;
        }
        graphics.drawLine(0, 0, this.getSize().width, 0);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        super.getPreferredSize().width = 180;
        return dimension;
    }

    public KTabItem getActiveTabItem() {
        for (int i = 0; i < this.mItems.size(); ++i) {
            KTabItem kTabItem = this.mItems.elementAt(i);
            if (!kTabItem.isActive()) continue;
            return kTabItem;
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.updateHitTab(mouseEvent.getX(), mouseEvent.getY());
        if (!KMouseEvent.isRightButtonMask((int)mouseEvent.getModifiers())) {
            this.mDispPop = false;
        }
        if (KMouseEvent.isRightButtonMask((int)mouseEvent.getModifiers())) {
            if (!this.mDispPop) {
                this.createContext();
                if (this.mPopup.getItemCount() != 0) {
                    this.mDispPop = true;
                    this.goPop(mouseEvent);
                }
            }
            return;
        }
        if (this.mCurrentHit != null && !this.mCurrentHit.isActive()) {
            this.select(this.mCurrentHit.getName());
            this.update();
            this.select();
        }
        this.repaint();
    }

    protected void updateHitTab(int n, int n2) {
        KTabItem kTabItem;
        int n3;
        this.mCurrentHit = null;
        for (n3 = 0; n3 < this.mItems.size(); ++n3) {
            kTabItem = this.mItems.elementAt(n3);
            if (!kTabItem.isActive() || !kTabItem.isInner(n, n2)) continue;
            this.mCurrentHit = kTabItem;
            break;
        }
        if (this.mCurrentHit == null) {
            for (n3 = 0; n3 < this.mItems.size(); ++n3) {
                kTabItem = this.mItems.elementAt(n3);
                if (kTabItem.isActive() || !kTabItem.isInner(n, n2)) continue;
                this.mCurrentHit = kTabItem;
                return;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void select(String string) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            KTabItem kTabItem = this.mItems.elementAt(i);
            if (!UtilString.isDiff((String)string, (String)kTabItem.getName())) {
                kTabItem.setActive(true);
                continue;
            }
            kTabItem.setActive(false);
        }
    }

    protected void createContext() {
    }

    private synchronized void goPop(MouseEvent mouseEvent) {
        this.mPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    protected void select() {
    }

    protected boolean isUpdate() {
        return false;
    }

    protected void create() {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.mDispPop = false;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.mDispPop = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

