/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util.tree;

import com.kt.util.tree.ObjectFolder;

public class ObjectNode {
    private String mName;
    private Object ac;
    private ObjectFolder ad;

    public ObjectNode(String string, Object object) {
        this.mName = string;
        this.ac = object;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public Object getObject() {
        return this.ac;
    }

    public void setObject(Object object) {
        this.ac = object;
    }

    public ObjectFolder getParent() {
        return this.ad;
    }

    public void setParent(ObjectFolder objectFolder) {
        this.ad = objectFolder;
    }

    public static String getNodeString(ObjectNode objectNode) {
        String string = null;
        if (objectNode != null && objectNode.getObject() != null && objectNode.getObject() instanceof String) {
            string = (String)objectNode.getObject();
        }
        return string;
    }

    public static int getNodeInt(ObjectNode objectNode) {
        String string = ObjectNode.getNodeString(objectNode);
        if (string != null) {
            try {
                int n = Integer.valueOf(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return 0;
    }

    public static float getNodeFloat(ObjectNode objectNode) {
        String string = ObjectNode.getNodeString(objectNode);
        if (string != null) {
            try {
                float f = Float.valueOf(string).floatValue();
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public static double getNodeDouble(ObjectNode objectNode) {
        String string = ObjectNode.getNodeString(objectNode);
        if (string != null) {
            try {
                double d2 = Double.valueOf(string);
                return d2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public static boolean getNodeBool(ObjectNode objectNode) {
        String string = ObjectNode.getNodeString(objectNode);
        return string != null && (string = string.trim()).equalsIgnoreCase("1");
    }

    public static boolean isStringObject(ObjectNode objectNode) {
        return objectNode != null && objectNode.getObject() != null && objectNode.getObject() instanceof String;
    }

    public static boolean isIntObject(ObjectNode objectNode) {
        if (!ObjectNode.isStringObject(objectNode)) {
            return false;
        }
        String string = ObjectNode.getNodeString(objectNode);
        try {
            Integer.valueOf(string).intValue();
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return false;
        }
    }

    public static boolean isBoolObject(ObjectNode objectNode) {
        if (!ObjectNode.isStringObject(objectNode)) {
            return false;
        }
        String string = ObjectNode.getNodeString(objectNode);
        if (string != null) {
            return (string = string.trim()).equalsIgnoreCase("1") || string.equalsIgnoreCase("0");
        }
        return false;
    }

    public static boolean isFloatObject(ObjectNode objectNode) {
        if (!ObjectNode.isStringObject(objectNode)) {
            return false;
        }
        String string = ObjectNode.getNodeString(objectNode);
        try {
            Float.valueOf(string).floatValue();
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return false;
        }
    }
}

