/*
 * Decompiled with CFR 0.152.
 */
package geom;

import com.kt.geom.KLocalAxis;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import geom.AbstractTerraceGeometory;
import geom.GeomType;
import java.awt.Color;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KRichGraphics;
import kinoki3exchange.KxModuleUtil;
import nethome.NethomeResource;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GPoint2Df;
import proto.graphics2d.GeomNodeName;

public class GSunpo
extends AbstractTerraceGeometory
implements KLocalAxis {
    protected boolean horizontal = true;
    private boolean drawLine = false;
    private boolean drawArrow = true;
    protected float offset = 0.0f;
    protected String text;
    protected GPoint2Df p1 = new GPoint2Df(0.0f, 0.0f);
    protected GPoint2Df p2 = new GPoint2Df(1000.0f, 1000.0f);
    protected float fontSize = 200.0f;
    private float mRot;
    private float mX;
    private float mY;
    protected float ofsX = 0.0f;
    protected float ofsY = 0.0f;
    protected boolean drawExtensionLine = true;
    protected boolean ignoreOffsetIfSufficient = false;
    protected float arrowSize = 80.0f;

    public GSunpo() {
        this.type = GeomType.SUNPO;
    }

    public void drawGeom(IRichGraphics iRichGraphics) {
    }

    public void set(boolean bl, boolean bl2, float f) {
        this.horizontal = bl;
        this.drawLine = bl2;
        this.offset = f;
    }

    public void setP1(float f, float f2) {
        this.p1.setXY((double)f, (double)f2);
    }

    public void setP2(float f, float f2) {
        this.p2.setXY((double)f, (double)f2);
    }

    public void setPoint(float f, float f2, float f3, float f4) {
        this.setP1(f, f2);
        this.setP2(f3, f4);
    }

    public void setLabel(String string) {
        this.text = string;
    }

    public String getLabel() {
        return this.text;
    }

    public void setHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    public void setDrawLine(boolean bl) {
        this.drawLine = bl;
    }

    public void setDrawArrow(boolean bl) {
        this.drawArrow = bl;
    }

    public void setOffset(float f) {
        this.offset = f;
    }

    public void setFontSize(float f) {
        this.fontSize = f;
    }

    public void setDrawExtensionLine(boolean bl) {
        this.drawExtensionLine = bl;
    }

    public void setIgnoreOffsetIfSufficient(boolean bl) {
        this.ignoreOffsetIfSufficient = bl;
    }

    public void setOfsXY(float f, float f2) {
        this.ofsX = f;
        this.ofsY = f2;
    }

    public void setArrowSize(float f) {
        this.arrowSize = f;
    }

    public float getArrowSize() {
        return this.arrowSize;
    }

    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (color == null) {
            color = Color.BLACK;
        }
        this.draw(iRichGraphics, color, localAxis2Df);
    }

    public void draw(IRichGraphics iRichGraphics, Color color, LocalAxis2Df localAxis2Df) {
        iRichGraphics.setColor(color);
        if (this.drawLine) {
            this.drawLine(iRichGraphics, localAxis2Df);
        }
        if (this.drawArrow) {
            this.drawArrow(iRichGraphics, localAxis2Df);
        }
        this.drawLabel(iRichGraphics, localAxis2Df);
    }

    private void drawLine(IRichGraphics iRichGraphics, LocalAxis2Df localAxis2Df) {
        if (this.horizontal) {
            float f = this.offset >= 0.0f ? 1 : -1;
            float f2 = this.offset >= 0.0f ? (this.p1.y > this.p2.y ? this.p1.y : this.p2.y) : (this.p1.y > this.p2.y ? this.p2.y : this.p1.y);
            f2 += this.offset;
            if (localAxis2Df != null) {
                float f3 = localAxis2Df.getGlobalX(this.p1.x, this.p1.y + f * 20.0f);
                float f4 = localAxis2Df.getGlobalY(this.p1.x, this.p1.y + f * 20.0f);
                float f5 = localAxis2Df.getGlobalX(this.p1.x, f2 + f * 20.0f);
                float f6 = localAxis2Df.getGlobalY(this.p1.x, f2 + f * 20.0f);
                iRichGraphics.drawLine(f3, f4, f5, f6, IRichGraphics.LINE_1);
                f3 = localAxis2Df.getGlobalX(this.p2.x, this.p2.y + f * 20.0f);
                f4 = localAxis2Df.getGlobalY(this.p2.x, this.p2.y + f * 20.0f);
                f5 = localAxis2Df.getGlobalX(this.p2.x, f2 + f * 20.0f);
                f6 = localAxis2Df.getGlobalY(this.p2.x, f2 + f * 20.0f);
                iRichGraphics.drawLine(f3, f4, f5, f6, IRichGraphics.LINE_1);
            } else {
                iRichGraphics.drawLine(this.p1.x, this.p1.y + f * 20.0f, this.p1.x, f2 + f * 20.0f, IRichGraphics.LINE_1);
                iRichGraphics.drawLine(this.p2.x, this.p2.y + f * 20.0f, this.p2.x, f2 + f * 20.0f, IRichGraphics.LINE_1);
            }
        } else {
            float f = this.offset >= 0.0f ? 1 : -1;
            float f7 = this.offset >= 0.0f ? (this.p1.x > this.p2.x ? this.p1.x : this.p2.x) : (this.p1.x > this.p2.x ? this.p2.x : this.p1.x);
            f7 += this.offset;
            if (localAxis2Df != null) {
                float f8 = localAxis2Df.getGlobalX(this.p1.x + f * 20.0f, this.p1.y);
                float f9 = localAxis2Df.getGlobalY(this.p1.x + f * 20.0f, this.p1.y);
                float f10 = localAxis2Df.getGlobalX(f7 + f * 20.0f, this.p1.y);
                float f11 = localAxis2Df.getGlobalY(f7 + f * 20.0f, this.p1.y);
                iRichGraphics.drawLine(f8, f9, f10, f11, IRichGraphics.LINE_1);
                f8 = localAxis2Df.getGlobalX(this.p2.x + f * 20.0f, this.p2.y);
                f9 = localAxis2Df.getGlobalY(this.p2.x + f * 20.0f, this.p2.y);
                f10 = localAxis2Df.getGlobalX(f7 + f * 20.0f, this.p2.y);
                f11 = localAxis2Df.getGlobalY(f7 + f * 20.0f, this.p2.y);
                iRichGraphics.drawLine(f8, f9, f10, f11, IRichGraphics.LINE_1);
            } else {
                iRichGraphics.drawLine(this.p1.x + f * 20.0f, this.p1.y, f7 + f * 20.0f, this.p1.y, IRichGraphics.LINE_1);
                iRichGraphics.drawLine(this.p2.x + f * 20.0f, this.p2.y, f7 + f * 20.0f, this.p2.y, IRichGraphics.LINE_1);
            }
        }
    }

    private void drawArrow(IRichGraphics iRichGraphics, LocalAxis2Df localAxis2Df) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        if (this.horizontal) {
            f5 = this.p1.x;
            f4 = this.p2.x;
            if (this.offset >= 0.0f) {
                f3 = this.p1.y > this.p2.y ? this.p1.y : this.p2.y;
                f = f2 = f3 + this.offset;
            } else {
                f3 = this.p1.y > this.p2.y ? this.p2.y : this.p1.y;
                f = f2 = f3 + this.offset;
            }
        } else {
            f = this.p1.y;
            f2 = this.p2.y;
            if (this.offset >= 0.0f) {
                f3 = this.p1.x > this.p2.x ? this.p1.x : this.p2.x;
                f5 = f4 = f3 + this.offset;
            } else {
                f3 = this.p1.x > this.p2.x ? this.p2.x : this.p1.x;
                f5 = f4 = f3 + this.offset;
            }
        }
        if (localAxis2Df != null) {
            f3 = localAxis2Df.getGlobalX(f5, f);
            float f6 = localAxis2Df.getGlobalY(f5, f);
            f5 = f3;
            f = f6;
            f3 = localAxis2Df.getGlobalX(f4, f2);
            f6 = localAxis2Df.getGlobalY(f4, f2);
            f4 = f3;
            f2 = f6;
        }
        this.drawArrow(iRichGraphics, f5, f, f4, f2);
    }

    protected void drawLabel(IRichGraphics iRichGraphics, LocalAxis2Df localAxis2Df) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        boolean bl = KRichGraphics.getQuality();
        KRichGraphics.setQuality((boolean)true);
        if (this.text == null) {
            return;
        }
        float f7 = this.ofsX;
        float f8 = this.ofsY;
        KFont kFont = NethomeResource.getScaleFont((String)"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af");
        float f9 = this.fontSize / kFont.getSize();
        float f10 = (kFont.getDescentf() + kFont.getAscentf()) * f9;
        float f11 = (float)kFont.stringWidth(this.text) * f9;
        float f12 = kFont.getDescentf() * f9;
        if (this.horizontal) {
            f6 = this.p1.x;
            f5 = this.p2.x;
            if (this.offset >= 0.0f) {
                f4 = this.p1.y > this.p2.y ? this.p1.y : this.p2.y;
                f2 = f3 = f4 + this.offset;
            } else {
                f4 = this.p1.y > this.p2.y ? this.p2.y : this.p1.y;
                f2 = f3 = f4 + this.offset;
            }
        } else {
            f2 = this.p1.y;
            f3 = this.p2.y;
            if (this.offset >= 0.0f) {
                f4 = this.p1.x > this.p2.x ? this.p1.x : this.p2.x;
                f6 = f5 = f4 + this.offset;
            } else {
                f4 = this.p1.x > this.p2.x ? this.p2.x : this.p1.x;
                f6 = f5 = f4 + this.offset;
            }
        }
        float f13 = (f6 + f5) / 2.0f;
        float f14 = (f2 + f3) / 2.0f;
        if (this.ignoreOffsetIfSufficient && (this.ofsX != 0.0f || this.ofsY != 0.0f)) {
            float f15 = f4 = this.horizontal ? Math.abs(f5 - f6) : Math.abs(f3 - f2);
            if (f11 < f4) {
                f7 = 0.0f;
                f8 = 0.0f;
            }
        }
        f6 += f7;
        f5 += f7;
        f2 += f8;
        f3 += f8;
        if (localAxis2Df != null) {
            f4 = localAxis2Df.getGlobalX(f6, f2);
            f = localAxis2Df.getGlobalY(f6, f2);
            f6 = f4;
            f2 = f;
            f4 = localAxis2Df.getGlobalX(f5, f3);
            f = localAxis2Df.getGlobalY(f5, f3);
            f5 = f4;
            f3 = f;
            f4 = localAxis2Df.getGlobalX(f13, f14);
            f = localAxis2Df.getGlobalY(f13, f14);
            f13 = f4;
            f14 = f;
        }
        if (this.horizontal) {
            f4 = (f6 + f5 - f11) / 2.0f;
            f = f2 + this.fontSize / 2.0f - f10 / 2.0f + f12;
            iRichGraphics.drawText(this.text, f4, f, "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 0, this.fontSize, 0.0f);
            if (this.drawExtensionLine && f7 != 0.0f) {
                float f16 = (f6 + f5) / 2.0f;
                float f17 = f16 - f11 / 2.0f;
                float f18 = f16 + f11 / 2.0f;
                if (f8 == 0.0f) {
                    if (f7 > 0.0f) {
                        this.drawLine(iRichGraphics, f13, f14, f18, f3);
                    } else {
                        this.drawLine(iRichGraphics, f17, f2, f13, f14);
                    }
                } else {
                    this.drawLine(iRichGraphics, f17, f2, f18, f3);
                    if (f7 < 0.0f) {
                        this.drawLine(iRichGraphics, f13, f14, f18, f3);
                    } else {
                        this.drawLine(iRichGraphics, f13, f14, f17, f3);
                    }
                }
            }
        } else {
            f4 = (f2 + f3 - f11) / 2.0f;
            f = f6 - this.fontSize / 2.0f + f10 / 2.0f - f12;
            iRichGraphics.drawText(this.text, f, f4, "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 0, this.fontSize, 90.0f);
            if (this.drawExtensionLine && f8 != 0.0f) {
                float f19 = (f2 + f3) / 2.0f;
                float f20 = f19 - f11 / 2.0f;
                float f21 = f19 + f11 / 2.0f;
                if (f7 == 0.0f) {
                    if (f8 > 0.0f) {
                        this.drawLine(iRichGraphics, f13, f14, f5, f21);
                    } else {
                        this.drawLine(iRichGraphics, f6, f20, f13, f14);
                    }
                } else {
                    this.drawLine(iRichGraphics, f6, f20, f5, f21);
                    if (f8 < 0.0f) {
                        this.drawLine(iRichGraphics, f13, f14, f5, f21);
                    } else {
                        this.drawLine(iRichGraphics, f13, f14, f6, f20);
                    }
                }
            }
        }
        KRichGraphics.setQuality((boolean)bl);
    }

    private void drawArrow(IRichGraphics iRichGraphics, float f, float f2, float f3, float f4) {
        float f5 = this.arrowSize;
        float f6 = f5 * 2.0f + 20.0f;
        float f7 = f3 - f;
        float f8 = f4 - f2;
        float f9 = (float)Math.sqrt(f7 * f7 + f8 * f8);
        f7 /= f9;
        f8 /= f9;
        if (f9 < f6) {
            iRichGraphics.drawLine(f - f7 * f5 * 1.5f, f2 - f8 * f5 * 1.5f, f3 + f7 * f5 * 1.5f, f4 + f8 * f5 * 1.5f, IRichGraphics.LINE_1);
        } else {
            iRichGraphics.drawLine(f + f7 * f5 / 2.0f, f2 + f8 * f5 / 2.0f, f3 - f7 * f5 / 2.0f, f4 - f8 * f5 / 2.0f, IRichGraphics.LINE_1);
        }
        float f10 = (float)Math.atan2(f8, f7);
        this.mX = f;
        this.mY = f2;
        this.mRot = f10;
        if (f9 < f6) {
            iRichGraphics.pathInit(0);
            iRichGraphics.pathMoveTo(0.0, 0.0, (KLocalAxis)this);
            iRichGraphics.pathLineTo((double)(-f5), (double)(-f5 / 4.0f), (KLocalAxis)this);
            iRichGraphics.pathLineTo((double)(-f5), (double)(f5 / 4.0f), (KLocalAxis)this);
            iRichGraphics.pathClose();
            iRichGraphics.fillPath(IRichGraphics.LINE_1);
            iRichGraphics.pathClear();
            iRichGraphics.pathInit(0);
            iRichGraphics.pathMoveTo((double)f9, 0.0, (KLocalAxis)this);
            iRichGraphics.pathLineTo((double)(f9 + f5), (double)(f5 / 4.0f), (KLocalAxis)this);
            iRichGraphics.pathLineTo((double)(f9 + f5), (double)(-f5 / 4.0f), (KLocalAxis)this);
            iRichGraphics.pathClose();
            iRichGraphics.fillPath(IRichGraphics.LINE_1);
            iRichGraphics.pathClear();
        } else {
            iRichGraphics.pathInit(0);
            iRichGraphics.pathMoveTo(0.0, 0.0, (KLocalAxis)this);
            iRichGraphics.pathLineTo((double)f5, (double)(-f5 / 4.0f), (KLocalAxis)this);
            iRichGraphics.pathLineTo((double)f5, (double)(f5 / 4.0f), (KLocalAxis)this);
            iRichGraphics.pathClose();
            iRichGraphics.fillPath(IRichGraphics.LINE_1);
            iRichGraphics.pathClear();
            iRichGraphics.pathInit(0);
            iRichGraphics.pathMoveTo((double)f9, 0.0, (KLocalAxis)this);
            iRichGraphics.pathLineTo((double)(f9 - f5), (double)(f5 / 4.0f), (KLocalAxis)this);
            iRichGraphics.pathLineTo((double)(f9 - f5), (double)(-f5 / 4.0f), (KLocalAxis)this);
            iRichGraphics.pathClose();
            iRichGraphics.fillPath(IRichGraphics.LINE_1);
            iRichGraphics.pathClear();
        }
    }

    private void drawLine(IRichGraphics iRichGraphics, float f, float f2, float f3, float f4) {
        iRichGraphics.drawLine(f, f2, f3, f4, IRichGraphics.LINE_1);
    }

    public float getGlobalX(float f, float f2) {
        return (float)((double)f * Math.cos(this.mRot) - (double)f2 * Math.sin(this.mRot) + (double)this.mX);
    }

    public float getGlobalY(float f, float f2) {
        return (float)((double)f * Math.sin(this.mRot) + (double)f2 * Math.cos(this.mRot) + (double)this.mY);
    }

    public float getLocalX(float f, float f2) {
        return 0.0f;
    }

    public float getLocalY(float f, float f2) {
        return 0.0f;
    }

    public float getGlobalAngl(double d) {
        return (float)((double)this.mRot + d);
    }

    public void save(ObjectFolder objectFolder) {
        super.saveCommon(objectFolder);
        if (this.text != null) {
            KxModuleUtil.addString(objectFolder, GeomNodeName.text, this.text);
        }
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.x1, this.p1.x);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.y1, this.p1.y);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.x2, this.p2.x);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.y2, this.p2.y);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.horizontal, this.horizontal);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.line, this.drawLine);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.arrow, this.drawArrow);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.offset, this.offset);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.size, this.fontSize);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.ofsx, this.ofsX);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.ofsy, this.ofsY);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.extline, this.drawExtensionLine);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.ignoreOffset, this.ignoreOffsetIfSufficient);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.arrowSize, this.arrowSize);
    }

    public void load(ObjectFolder objectFolder) {
        this.setLabel(KxModuleUtil.getString(objectFolder, GeomNodeName.text));
        this.p1.setX((double)KxModuleUtil.getFloat(objectFolder, GeomNodeName.x1));
        this.p1.setY((double)KxModuleUtil.getFloat(objectFolder, GeomNodeName.y1));
        this.p2.setX((double)KxModuleUtil.getFloat(objectFolder, GeomNodeName.x2));
        this.p2.setY((double)KxModuleUtil.getFloat(objectFolder, GeomNodeName.y2));
        this.setHorizontal(KxModuleUtil.getBool(objectFolder, GeomNodeName.horizontal, this.horizontal));
        this.setDrawLine(KxModuleUtil.getBool(objectFolder, GeomNodeName.line, this.drawLine));
        this.setDrawArrow(KxModuleUtil.getBool(objectFolder, GeomNodeName.arrow, this.drawArrow));
        this.setOffset(KxModuleUtil.getFloat(objectFolder, GeomNodeName.offset));
        this.setFontSize(KxModuleUtil.getFloat(objectFolder, GeomNodeName.size));
        this.setOfsXY(KxModuleUtil.getFloat(objectFolder, GeomNodeName.ofsx), KxModuleUtil.getFloat(objectFolder, GeomNodeName.ofsy));
        this.setDrawExtensionLine(KxModuleUtil.getBool(objectFolder, GeomNodeName.extline, this.drawExtensionLine));
        this.setIgnoreOffsetIfSufficient(KxModuleUtil.getBool(objectFolder, GeomNodeName.ignoreOffset, this.ignoreOffsetIfSufficient));
        ObjectNode objectNode = objectFolder.getNode(GeomNodeName.arrowSize.name());
        if (objectNode != null) {
            this.setArrowSize(KxModuleUtil.getFloat(objectFolder, GeomNodeName.arrowSize));
        }
    }
}

