/*
 * Decompiled with CFR 0.152.
 */
package proto.graphics2d;

import java.awt.Color;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import model.primitive.LsEdge;
import model.primitive.LsShape;
import model.primitive.LsSurface;
import model.shape.primitive.SMatrix3d;
import model.shape.primitive.SVector3d;
import model2d.Primitive2D;
import model2d.SLine2D;
import model2d.SPolygon2D;
import proto.graphics2d.Node2d;
import proto.graphics2d.Scene2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneUtil {
    private static SVector3d cr = new SVector3d();
    private static SVector3d cs = new SVector3d();
    private static SVector3d ct = new SVector3d();

    public static void addShape(Scene2D scene2D, Vector<LsShape> vector) {
        if (scene2D.section) {
            SceneUtil.addShapeSection(scene2D, vector);
        } else {
            SceneUtil.addShapeProjective(scene2D, vector);
        }
    }

    public static void addShapeProjective(Scene2D scene2D, Vector<LsShape> vector) {
        SMatrix3d sMatrix3d = new SMatrix3d();
        sMatrix3d.e00 = scene2D.u.x;
        sMatrix3d.e01 = scene2D.v.x;
        sMatrix3d.e02 = scene2D.w.x;
        sMatrix3d.e10 = scene2D.u.y;
        sMatrix3d.e11 = scene2D.v.y;
        sMatrix3d.e12 = scene2D.w.y;
        sMatrix3d.e20 = scene2D.u.z;
        sMatrix3d.e21 = scene2D.v.z;
        sMatrix3d.e22 = scene2D.w.z;
        sMatrix3d.inverse(sMatrix3d);
        SVector3d sVector3d = new SVector3d();
        for (LsShape lsShape : vector) {
            if (!lsShape.projection2dVisible) continue;
            Hashtable<SVector3d, SVector3d> hashtable = new Hashtable<SVector3d, SVector3d>();
            List<SVector3d> list = lsShape.getVertices();
            for (SVector3d sVector3d2 : list) {
                sMatrix3d.translate(sVector3d, sVector3d2.x, sVector3d2.y, sVector3d2.z);
                hashtable.put(sVector3d2, new SVector3d(sVector3d.x, sVector3d.y, sVector3d.z));
            }
            List<LsSurface> object22 = lsShape.getSurfaces();
            for (Object object : object22) {
                SceneUtil.a((LsSurface)object, hashtable);
            }
            for (Object object : object22) {
                if (!((LsSurface)object).visible) continue;
                List<SVector3d> list2 = ((LsSurface)object).getVertices();
                double d = Double.POSITIVE_INFINITY;
                double d2 = Double.NEGATIVE_INFINITY;
                SVector3d[] sVector3dArray = new SVector3d[list2.size()];
                int n = 0;
                for (SVector3d sVector3d3 : list2) {
                    SVector3d sVector3d4;
                    sVector3dArray[n] = sVector3d4 = hashtable.get(sVector3d3);
                    ++n;
                    if (sVector3d4.z < d) {
                        d = sVector3d4.z;
                    }
                    if (!(d2 < sVector3d4.z)) continue;
                    d2 = sVector3d4.z;
                }
                SPolygon2D sPolygon2D = new SPolygon2D();
                sPolygon2D.fillColor = lsShape.fillColor;
                sPolygon2D.edgeColor = lsShape.edgeColor;
                sPolygon2D.hatchPattern2d = lsShape.hatchPattern2d;
                sPolygon2D.group_id_color = lsShape.group_id_color;
                sPolygon2D.group_id_object = lsShape.group_id_object;
                sPolygon2D.points = sVector3dArray;
                SceneUtil.a((LsSurface)object, sPolygon2D);
                SceneUtil.a(sPolygon2D);
                if (sPolygon2D.normal.z < 1.0E-5 || d2 < scene2D.viewport.minz || scene2D.viewport.maxz < d) continue;
                scene2D.parts.addElement(sPolygon2D);
            }
            hashtable.clear();
        }
        SceneUtil.sortPrimitives(scene2D);
    }

    public static void addShapeSection(Scene2D scene2D, Vector<LsShape> vector) {
        SMatrix3d sMatrix3d = new SMatrix3d();
        sMatrix3d.e00 = scene2D.u.x;
        sMatrix3d.e01 = scene2D.v.x;
        sMatrix3d.e02 = scene2D.w.x;
        sMatrix3d.e10 = scene2D.u.y;
        sMatrix3d.e11 = scene2D.v.y;
        sMatrix3d.e12 = scene2D.w.y;
        sMatrix3d.e20 = scene2D.u.z;
        sMatrix3d.e21 = scene2D.v.z;
        sMatrix3d.e22 = scene2D.w.z;
        sMatrix3d.inverse(sMatrix3d);
        SVector3d sVector3d = new SVector3d();
        SVector3d[] sVector3dArray = null;
        double[] dArray = null;
        if (scene2D.profiles != null) {
            dArray = scene2D.profiles;
        }
        if (dArray == null) {
            dArray = new double[]{scene2D.viewport.maxz};
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] < d) {
                d = dArray[n];
            }
            if (d2 < dArray[n]) {
                d2 = dArray[n];
            }
            ++n;
        }
        n = 0;
        int n2 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (LsShape lsShape : vector) {
            if (!lsShape.section2dVisible) continue;
            Hashtable<SVector3d, SVector3d> hashtable = new Hashtable<SVector3d, SVector3d>();
            List<SVector3d> list = lsShape.getVertices();
            for (SVector3d sVector3d2 : list) {
                sMatrix3d.translate(sVector3d, sVector3d2.x, sVector3d2.y, sVector3d2.z);
                hashtable.put(sVector3d2, new SVector3d(sVector3d.x, sVector3d.y, sVector3d.z));
            }
            List<LsSurface> object2 = lsShape.getSurfaces();
            for (Object object : object2) {
                List<SVector3d> list2 = ((LsSurface)object).getVertices();
                double d7 = Double.POSITIVE_INFINITY;
                double d8 = Double.NEGATIVE_INFINITY;
                sVector3dArray = new SVector3d[list2.size()];
                int n3 = 0;
                for (SVector3d sVector3d3 : list2) {
                    SVector3d sVector3d4;
                    sVector3dArray[n3] = sVector3d4 = (SVector3d)hashtable.get(sVector3d3);
                    if (sVector3d4.z < d7) {
                        d7 = sVector3d4.z;
                    }
                    if (d8 < sVector3d4.z) {
                        d8 = sVector3d4.z;
                    }
                    ++n3;
                }
                if (d2 < d7 || d8 < d) continue;
                int n4 = 0;
                while (n4 < dArray.length) {
                    double d9 = dArray[n4];
                    n2 = 0;
                    n = 0;
                    int n5 = 0;
                    while (n5 < sVector3dArray.length) {
                        SVector3d sVector3d4 = sVector3dArray[n5];
                        SVector3d sVector3d5 = sVector3dArray[n5 == sVector3dArray.length - 1 ? 0 : n5 + 1];
                        double d10 = sVector3d5.z - sVector3d4.z;
                        d7 = sVector3d4.z < sVector3d5.z ? sVector3d4.z : sVector3d5.z;
                        double d11 = d8 = sVector3d4.z < sVector3d5.z ? sVector3d5.z : sVector3d4.z;
                        if (!(d9 < d7) && !(d8 < d9) && d10 != 0.0) {
                            double d12 = sVector3d4.x + (d9 - sVector3d4.z) * (sVector3d5.x - sVector3d4.x) / d10;
                            double d13 = sVector3d4.y + (d9 - sVector3d4.z) * (sVector3d5.y - sVector3d4.y) / d10;
                            if (n == 0) {
                                d3 = d12;
                                d4 = d13;
                                n = 1;
                            } else {
                                d5 = d12;
                                d6 = d13;
                                n2 = 1;
                            }
                            if (n2 != 0) break;
                        }
                        ++n5;
                    }
                    if (n != 0 && n2 != 0) {
                        SLine2D sLine2D = new SLine2D();
                        sLine2D.u1 = d3;
                        sLine2D.v1 = d4;
                        sLine2D.u2 = d5;
                        sLine2D.v2 = d6;
                        sLine2D.edgeColor = Color.BLACK;
                        scene2D.parts.addElement(sLine2D);
                    }
                    ++n4;
                }
            }
            hashtable.clear();
        }
    }

    private static void a(SPolygon2D sPolygon2D) {
        int n = sPolygon2D.points.length;
        if (n < 3) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = (n2 + n - 1) % n;
            int n4 = (n2 + n + 1) % n;
            cr.set(sPolygon2D.points[n2].x - sPolygon2D.points[n3].x, sPolygon2D.points[n2].y - sPolygon2D.points[n3].y, sPolygon2D.points[n2].z - sPolygon2D.points[n3].z);
            cs.set(sPolygon2D.points[n4].x - sPolygon2D.points[n2].x, sPolygon2D.points[n4].y - sPolygon2D.points[n2].y, sPolygon2D.points[n4].z - sPolygon2D.points[n2].z);
            cr.normalize();
            cs.normalize();
            if (!SceneUtil.a(cr, cs, 1.0E-5)) {
                sPolygon2D.normal.cross(cr, cs);
                sPolygon2D.normal.normalize();
                break;
            }
            ++n2;
        }
    }

    private static void a(LsSurface lsSurface, SPolygon2D sPolygon2D) {
        List<LsEdge> list = lsSurface.getEdges();
        boolean bl = true;
        boolean[] blArray = new boolean[list.size()];
        int n = 0;
        for (LsEdge lsEdge : list) {
            blArray[n] = lsEdge.drawEdge;
            if (!lsEdge.drawEdge && lsEdge.drawEdgeBoundary) {
                boolean bl2 = false;
                boolean bl3 = false;
                if (lsEdge.surface1 != null && lsEdge.surface1.visible) {
                    bl2 = true;
                }
                if (lsEdge.surface2 != null && lsEdge.surface2.visible) {
                    bl3 = true;
                }
                if (lsEdge.surface1 != null && lsEdge.surface2 != null && bl2 != bl3) {
                    blArray[n] = true;
                }
            }
            if (!blArray[n]) {
                bl = false;
            }
            ++n;
        }
        if (bl) {
            sPolygon2D.drawAllEdge = true;
            return;
        }
        sPolygon2D.drawAllEdge = false;
        sPolygon2D.drawEdge = blArray;
    }

    private static void a(LsSurface lsSurface, Hashtable<SVector3d, SVector3d> hashtable) {
        lsSurface.setVisible(true);
        List<SVector3d> list = lsSurface.getVertices();
        int n = list.size();
        if (n < 3) {
            lsSurface.setVisible(false);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = (n2 + n - 1) % n;
            int n4 = (n2 + n + 1) % n;
            SVector3d sVector3d = hashtable.get(list.get(n3));
            SVector3d sVector3d2 = hashtable.get(list.get(n2));
            SVector3d sVector3d3 = hashtable.get(list.get(n4));
            cr.set(sVector3d2.x - sVector3d.x, sVector3d2.y - sVector3d.y, sVector3d2.z - sVector3d.z);
            cr.normalize();
            cs.set(sVector3d3.x - sVector3d2.x, sVector3d3.y - sVector3d2.y, sVector3d3.z - sVector3d2.z);
            cs.normalize();
            if (!SceneUtil.a(cr, cs, 1.0E-5)) {
                ct.cross(cr, cs);
                ct.normalize();
                lsSurface.setVisible(!(SceneUtil.ct.z < 1.0E-5));
                break;
            }
            ++n2;
        }
    }

    private static boolean a(SVector3d sVector3d, SVector3d sVector3d2, double d) {
        if (sVector3d == null || sVector3d2 == null) {
            return false;
        }
        if (sVector3d.equals(sVector3d2)) {
            return true;
        }
        if (Math.abs(sVector3d.x - sVector3d2.x) > d) {
            return false;
        }
        if (Math.abs(sVector3d.y - sVector3d2.y) > d) {
            return false;
        }
        return !(Math.abs(sVector3d.z - sVector3d2.z) > d);
    }

    public static void sortPrimitives(Scene2D scene2D) {
        Vector<Primitive2D> vector = scene2D.parts;
        SVector3d cfr_ignored_0 = scene2D.w;
        Node2d node2d = new Node2d();
        int n = 0;
        while (n < vector.size()) {
            SPolygon2D sPolygon2D = (SPolygon2D)vector.elementAt(n);
            SceneUtil.add(node2d, sPolygon2D, SceneUtil.getTest(sPolygon2D));
            ++n;
        }
        vector.removeAllElements();
        SceneUtil.addToVector(node2d, vector);
    }

    public static double getTest(SPolygon2D sPolygon2D) {
        double d = 0.0;
        int n = 0;
        while (n < sPolygon2D.points.length) {
            d += sPolygon2D.points[n].z;
            ++n;
        }
        return d / (double)sPolygon2D.points.length;
    }

    public static void add(Node2d node2d, SPolygon2D sPolygon2D, double d) {
        if (node2d.object == null) {
            node2d.value = d;
            node2d.object = sPolygon2D;
            return;
        }
        if (node2d.value == d) {
            if (node2d.object instanceof Vector) {
                Vector vector = (Vector)node2d.object;
                vector.addElement(sPolygon2D);
            } else {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(node2d.object);
                vector.addElement(sPolygon2D);
                node2d.object = vector;
            }
            return;
        }
        if (d < node2d.value) {
            if (node2d.lower == null) {
                node2d.lower = new Node2d();
            }
            SceneUtil.add(node2d.lower, sPolygon2D, d);
        } else {
            if (node2d.upper == null) {
                node2d.upper = new Node2d();
            }
            SceneUtil.add(node2d.upper, sPolygon2D, d);
        }
    }

    public static void addToVector(Node2d node2d, Vector vector) {
        if (node2d.lower != null) {
            SceneUtil.addToVector(node2d.lower, vector);
        }
        if (node2d.object != null) {
            if (node2d.object instanceof Vector) {
                Vector vector2 = (Vector)node2d.object;
                int n = 0;
                while (n < vector2.size()) {
                    vector.addElement(vector2.elementAt(n));
                    ++n;
                }
            } else {
                vector.addElement(node2d.object);
            }
        }
        if (node2d.upper != null) {
            SceneUtil.addToVector(node2d.upper, vector);
        }
    }
}

