/*
 * Decompiled with CFR 0.152.
 */
package proto.graphics2d;

import com.kt.geom.KLocalAxis;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import geom.AbstractTerraceGeometory;
import geom.GeomType;
import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KRichGraphics;
import kinoki3exchange.KxModule;
import kinoki3exchange.KxModuleUtil;
import kinoki3exchange.StringUtil;
import model.shape.primitive.SVector3d;
import model2d.AbstractGeom2D;
import model2d.Primitive2D;
import model2d.SLine2D;
import model2d.SPolygon2D;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.Geometory;
import proto.graphics2d.GeomNodeName;
import proto.graphics2d.ViewPort3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Scene2D
implements Serializable,
KxModule {
    public double x1;
    public double y1;
    public double x2;
    public double y2;
    public static final int FILL_NONE = -1;
    public static final int FILL_COLOR = 0;
    public static final int FILL_WHITE = 1;
    public int fill = 1;
    protected boolean drawEdge = true;
    public double width = 100.0;
    public double height = 100.0;
    public SVector3d o;
    public SVector3d u;
    public SVector3d v;
    public SVector3d w;
    public ViewPort3D viewport = new ViewPort3D();
    public boolean section = false;
    private boolean cn = true;
    public String desc;
    public double[] profiles = null;
    public Vector<Primitive2D> parts;
    private Vector<Geometory> co;
    private Vector<Geometory> cp;
    private LocalAxis2Df cq;

    public Scene2D(String string) {
        this.desc = string;
        this.parts = new Vector();
        this.cp = new Vector();
        this.co = new Vector();
        this.cq = new LocalAxis2Df();
    }

    public void set(double d, double d2, double d3, double d4) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
    }

    public void updateFillColor(int n, Color color) {
        for (Primitive2D primitive2D : this.parts) {
            if (primitive2D instanceof SLine2D) continue;
            SPolygon2D sPolygon2D = (SPolygon2D)primitive2D;
            if (sPolygon2D.group_id_color == -1 || sPolygon2D.group_id_color != n) continue;
            sPolygon2D.fillColor = color;
        }
    }

    public void draw(IRichGraphics iRichGraphics) {
        this.drawGeoms(iRichGraphics, this.co, null, null);
        this.drawPrimitives(iRichGraphics);
        this.drawGeoms(iRichGraphics, this.cp, null, null);
    }

    protected void drawPrimitives(IRichGraphics iRichGraphics) {
        for (Primitive2D primitive2D : this.parts) {
            if (primitive2D instanceof SPolygon2D) {
                this.a(iRichGraphics, (SPolygon2D)primitive2D);
                continue;
            }
            if (!(primitive2D instanceof SLine2D)) continue;
            this.a(iRichGraphics, (SLine2D)primitive2D);
        }
    }

    private void a(IRichGraphics iRichGraphics, SLine2D sLine2D) {
        double d = sLine2D.u1 + this.x1 + this.u.x - this.viewport.minu;
        double d2 = sLine2D.v1 + this.y1 + this.v.y - this.viewport.minv;
        double d3 = sLine2D.u2 + this.x1 + this.u.x - this.viewport.minu;
        double d4 = sLine2D.v2 + this.y1 + this.v.y - this.viewport.minv;
        iRichGraphics.setColor(sLine2D.edgeColor != null ? sLine2D.edgeColor : Color.BLACK);
        iRichGraphics.drawLine((float)d, (float)d2, (float)d3, (float)d4, IRichGraphics.LINE_1);
    }

    private void a(IRichGraphics iRichGraphics, SPolygon2D sPolygon2D) {
        Vector<AbstractGeom2D> vector;
        double d;
        double d2;
        Color color = sPolygon2D.fillColor;
        if (color != null) {
            if (this.fill == -1) {
                color = null;
            } else if (this.fill == 1) {
                color = color.getAlpha() != 255 ? null : Color.WHITE;
            }
        }
        SVector3d[] sVector3dArray = sPolygon2D.points;
        if (color != null || sPolygon2D.drawAllEdge) {
            iRichGraphics.pathInit(0);
            int n = 0;
            while (n < sVector3dArray.length) {
                d2 = sVector3dArray[n].x + this.x1 + this.u.x - this.viewport.minu;
                d = sVector3dArray[n].y + this.y1 + this.v.y - this.viewport.minv;
                if (n == 0) {
                    iRichGraphics.pathMoveTo(d2, d, null);
                } else {
                    try {
                        iRichGraphics.pathLineTo(d2, d, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n;
            }
            iRichGraphics.pathClose();
            if (color != null) {
                iRichGraphics.setColor(color);
                iRichGraphics.fillPath(null);
            }
            if (sPolygon2D.drawAllEdge) {
                iRichGraphics.setColor(sPolygon2D.edgeColor);
                iRichGraphics.drawPath(IRichGraphics.LINE_1);
            }
            iRichGraphics.pathClear();
        }
        if (!sPolygon2D.drawAllEdge && sPolygon2D.drawEdge != null) {
            boolean bl = false;
            boolean bl2 = false;
            while (bl2 < sVector3dArray.length) {
                if (sPolygon2D.drawEdge[bl2]) {
                    bl = true;
                    break;
                }
                bl2 += 1;
            }
            if (!bl) {
                return;
            }
            bl2 = KRichGraphics.getQuality();
            KRichGraphics.setQuality((boolean)true);
            int n = 0;
            while (n < sVector3dArray.length) {
                if ((sPolygon2D.drawEdge[n] || color != null) && sPolygon2D.drawEdge[n]) {
                    iRichGraphics.setColor(sPolygon2D.edgeColor);
                    d2 = sVector3dArray[n].x + this.x1 + this.u.x - this.viewport.minu;
                    d = sVector3dArray[n].y + this.y1 + this.v.y - this.viewport.minv;
                    double d3 = sVector3dArray[(n + 1) % sVector3dArray.length].x + this.x1 + this.u.x - this.viewport.minu;
                    double d4 = sVector3dArray[(n + 1) % sVector3dArray.length].y + this.y1 + this.v.y - this.viewport.minv;
                    iRichGraphics.pathInit(0);
                    iRichGraphics.pathMoveTo(d2, d, null);
                    iRichGraphics.pathLineTo(d3, d4, null);
                    iRichGraphics.drawPath(IRichGraphics.LINE_1);
                    iRichGraphics.pathClear();
                }
                ++n;
            }
            KRichGraphics.setQuality((boolean)bl2);
        }
        if (sPolygon2D.hatchPattern2d != 0 && (vector = sPolygon2D.getHatchObjects()) != null) {
            for (AbstractGeom2D abstractGeom2D : vector) {
                if (!(abstractGeom2D instanceof SLine2D)) continue;
                this.a(iRichGraphics, (SLine2D)abstractGeom2D);
            }
        }
    }

    public void drawGeoms(IRichGraphics iRichGraphics, Vector<Geometory> vector, Color color, Color color2) {
        this.cq.mX = (float)(this.x1 + this.u.x - this.viewport.minu);
        this.cq.mY = (float)(this.y1 + this.v.y - this.viewport.minv);
        for (Geometory geometory : vector) {
            geometory.drawAbstDevice(iRichGraphics, color2, color, this.cq);
        }
    }

    public void drawAreaLine(IRichGraphics iRichGraphics, Color color) {
        iRichGraphics.pathInit(0);
        iRichGraphics.pathMoveTo(this.x1, this.y1, null);
        iRichGraphics.pathLineTo(this.x2, this.y1, null);
        iRichGraphics.pathLineTo(this.x2, this.y2, null);
        iRichGraphics.pathLineTo(this.x1, this.y2, null);
        iRichGraphics.pathClose();
        iRichGraphics.setColor(color);
        iRichGraphics.drawPath(IRichGraphics.LINE_DASH_1);
        iRichGraphics.pathClear();
    }

    public Vector<Geometory> getGeoms() {
        return this.cp;
    }

    public Vector<Geometory> getBackGeoms() {
        return this.co;
    }

    public void setDrawGeoms(boolean bl) {
        this.cn = bl;
    }

    public boolean isDrawGeoms() {
        return this.cn;
    }

    public LocalAxis2Df getLocalAxis() {
        this.cq.mX = (float)(this.x1 + this.u.x - this.viewport.minu);
        this.cq.mY = (float)(this.y1 + this.v.y - this.viewport.minv);
        return this.cq;
    }

    public void clear() {
        this.co.removeAllElements();
        this.cp.removeAllElements();
        this.parts.removeAllElements();
        this.cq = null;
        this.profiles = null;
        this.w = null;
        this.v = null;
        this.u = null;
        this.o = null;
        this.co = null;
        this.cp = null;
        this.parts = null;
    }

    public void drawShape(IRichGraphics iRichGraphics, Color color, Color color2, double d, double d2, double d3, KLocalAxis kLocalAxis) {
        for (Primitive2D primitive2D : this.parts) {
            if (primitive2D instanceof SPolygon2D) {
                this.a(iRichGraphics, (SPolygon2D)primitive2D, color, color2, d, d2, d3, kLocalAxis);
                continue;
            }
            if (!(primitive2D instanceof SLine2D)) continue;
            this.a(iRichGraphics, (SLine2D)primitive2D, color, color2, d, d2, d3, kLocalAxis);
        }
    }

    private void a(IRichGraphics iRichGraphics, SLine2D sLine2D, Color color, Color color2, double d, double d2, double d3, KLocalAxis kLocalAxis) {
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = d + d4 * sLine2D.u1 - d5 * sLine2D.v1;
        double d7 = d2 + d5 * sLine2D.u1 + d4 * sLine2D.v1;
        double d8 = d + d4 * sLine2D.u2 - d5 * sLine2D.v2;
        double d9 = d2 + d5 * sLine2D.u2 + d4 * sLine2D.v2;
        iRichGraphics.setColor(color2);
        if (kLocalAxis == null) {
            iRichGraphics.drawLine((float)d6, (float)d7, (float)d8, (float)d9, IRichGraphics.LINE_1);
        } else {
            double d10 = kLocalAxis.getGlobalX((float)d6, (float)d7);
            double d11 = kLocalAxis.getGlobalY((float)d6, (float)d7);
            double d12 = kLocalAxis.getGlobalX((float)d8, (float)d9);
            double d13 = kLocalAxis.getGlobalY((float)d8, (float)d9);
            iRichGraphics.drawLine((float)d10, (float)d11, (float)d12, (float)d13, IRichGraphics.LINE_1);
        }
    }

    private void a(IRichGraphics iRichGraphics, SPolygon2D sPolygon2D, Color color, Color color2, double d, double d2, double d3, KLocalAxis kLocalAxis) {
        double d4;
        double d5;
        Color color3 = sPolygon2D.fillColor;
        if (color3 != null) {
            if (this.fill == -1) {
                color3 = null;
            } else if (this.fill == 1) {
                color3 = color3.getAlpha() != 255 ? null : Color.WHITE;
            }
        }
        double d6 = Math.cos(d3);
        double d7 = Math.sin(d3);
        SVector3d[] sVector3dArray = sPolygon2D.points;
        if (color3 != null || sPolygon2D.drawAllEdge) {
            iRichGraphics.pathInit(0);
            int n = 0;
            while (n < sVector3dArray.length) {
                d5 = d + d6 * sVector3dArray[n].x - d7 * sVector3dArray[n].y;
                d4 = d2 + d7 * sVector3dArray[n].x + d6 * sVector3dArray[n].y;
                if (n == 0) {
                    iRichGraphics.pathMoveTo(d5, d4, kLocalAxis);
                } else {
                    try {
                        iRichGraphics.pathLineTo(d5, d4, kLocalAxis);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n;
            }
            iRichGraphics.pathClose();
            if (color3 != null) {
                iRichGraphics.setColor(color3);
                iRichGraphics.fillPath(null);
            }
            if (sPolygon2D.drawAllEdge) {
                iRichGraphics.setColor(sPolygon2D.edgeColor);
                iRichGraphics.drawPath(IRichGraphics.LINE_1);
            }
            iRichGraphics.pathClear();
        }
        if (sPolygon2D.drawEdge != null) {
            int n = 0;
            while (n < sVector3dArray.length) {
                if (sPolygon2D.drawEdge[n] || color3 != null) {
                    if (!sPolygon2D.drawEdge[n]) {
                        iRichGraphics.setColor(color3);
                    } else {
                        iRichGraphics.setColor(color2);
                    }
                    d5 = d + d6 * sVector3dArray[n].x - d7 * sVector3dArray[n].y;
                    d4 = d2 + d7 * sVector3dArray[n].x + d6 * sVector3dArray[n].y;
                    double d8 = d + d6 * sVector3dArray[(n + 1) % sVector3dArray.length].x - d7 * sVector3dArray[(n + 1) % sVector3dArray.length].y;
                    double d9 = d2 + d7 * sVector3dArray[(n + 1) % sVector3dArray.length].x + d6 * sVector3dArray[(n + 1) % sVector3dArray.length].y;
                    if (kLocalAxis == null) {
                        iRichGraphics.drawLine((float)d5, (float)d4, (float)d8, (float)d9, IRichGraphics.LINE_1);
                    } else {
                        double d10 = kLocalAxis.getGlobalX((float)d5, (float)d4);
                        double d11 = kLocalAxis.getGlobalY((float)d5, (float)d4);
                        double d12 = kLocalAxis.getGlobalX((float)d8, (float)d9);
                        double d13 = kLocalAxis.getGlobalY((float)d8, (float)d9);
                        iRichGraphics.drawLine((float)d10, (float)d11, (float)d12, (float)d13, IRichGraphics.LINE_1);
                    }
                }
                ++n;
            }
        }
    }

    @Override
    public void save(ObjectFolder objectFolder) {
        objectFolder.setName(GeomNodeName.scene2d.name());
        KxModuleUtil.addString(objectFolder, GeomNodeName.points, StringUtil.toString(new double[]{this.x1, this.y1, this.x2, this.y2}, ","));
        KxModuleUtil.addInt(objectFolder, GeomNodeName.fill, this.fill);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.edge, this.drawEdge);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.width, (float)this.width);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.height, (float)this.height);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.section, this.section);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.geom, this.cn);
        KxModuleUtil.addString(objectFolder, GeomNodeName.desc, this.desc == null ? "-" : this.desc);
        ObjectFolder objectFolder2 = null;
        objectFolder.addChild((ObjectNode)this.a(this.o, GeomNodeName.o), true);
        objectFolder.addChild((ObjectNode)this.a(this.u, GeomNodeName.u), true);
        objectFolder.addChild((ObjectNode)this.a(this.v, GeomNodeName.v), true);
        objectFolder.addChild((ObjectNode)this.a(this.w, GeomNodeName.w), true);
        if (this.section && this.profiles != null) {
            KxModuleUtil.addString(objectFolder, GeomNodeName.profiles, StringUtil.toString(this.profiles, ","));
        }
        if (this.viewport != null) {
            objectFolder2 = KxModuleUtil.createNode(GeomNodeName.viewport3d);
            this.viewport.save(objectFolder2);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
        if (this.cq != null) {
            objectFolder2 = KxModuleUtil.createNode(GeomNodeName.axis);
            this.getLocalAxis();
            KxModuleUtil.addFloat(objectFolder2, GeomNodeName.rot, this.cq.mRot);
            KxModuleUtil.addFloat(objectFolder2, GeomNodeName.x, this.cq.mX);
            KxModuleUtil.addFloat(objectFolder2, GeomNodeName.y, this.cq.mY);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
        if (this.co.size() != 0) {
            objectFolder2 = KxModuleUtil.createNode(GeomNodeName.backgeoms);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
            this.b(objectFolder2, this.co);
        }
        if (this.cp.size() != 0) {
            objectFolder2 = KxModuleUtil.createNode(GeomNodeName.foregeoms);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
            this.b(objectFolder2, this.cp);
        }
    }

    @Override
    public void load(ObjectFolder objectFolder) {
        ObjectFolder objectFolder2;
        String string = KxModuleUtil.getString(objectFolder, GeomNodeName.points);
        float[] fArray = StringUtil.parseFloatArray(string, ",");
        if (fArray != null && fArray.length == 4) {
            this.x1 = fArray[0];
            this.y1 = fArray[1];
            this.x2 = fArray[2];
            this.y2 = fArray[3];
        }
        this.fill = KxModuleUtil.getInt(objectFolder, GeomNodeName.fill);
        this.drawEdge = KxModuleUtil.getBool(objectFolder, GeomNodeName.edge, this.drawEdge);
        this.width = KxModuleUtil.getFloat(objectFolder, GeomNodeName.width);
        this.height = KxModuleUtil.getFloat(objectFolder, GeomNodeName.height);
        this.section = KxModuleUtil.getBool(objectFolder, GeomNodeName.section, this.section);
        this.cn = KxModuleUtil.getBool(objectFolder, GeomNodeName.geom, this.cn);
        this.desc = KxModuleUtil.getString(objectFolder, GeomNodeName.desc);
        this.o = new SVector3d(0.0, 0.0, 0.0);
        this.u = new SVector3d(1.0, 0.0, 0.0);
        this.v = new SVector3d(0.0, 1.0, 0.0);
        this.w = new SVector3d(0.0, 0.0, 1.0);
        this.a(objectFolder, this.o, GeomNodeName.o);
        this.a(objectFolder, this.u, GeomNodeName.u);
        this.a(objectFolder, this.v, GeomNodeName.v);
        this.a(objectFolder, this.w, GeomNodeName.w);
        ObjectNode objectNode = KxModuleUtil.getNode(objectFolder, GeomNodeName.viewport3d);
        if (objectNode != null && objectNode instanceof ObjectFolder) {
            objectFolder2 = (ObjectFolder)objectNode;
            if (this.viewport == null) {
                this.viewport = new ViewPort3D();
            }
            this.viewport.load(objectFolder2);
        }
        if (this.section && (objectNode = KxModuleUtil.getNode(objectFolder, GeomNodeName.profiles)) != null && (fArray = StringUtil.parseFloatArray(string = KxModuleUtil.getString(objectFolder, GeomNodeName.profiles), ",")) != null) {
            this.profiles = new double[fArray.length];
            int n = 0;
            while (n < fArray.length) {
                this.profiles[n] = fArray[n];
                ++n;
            }
        }
        if ((objectNode = KxModuleUtil.getNode(objectFolder, GeomNodeName.axis)) != null && objectNode instanceof ObjectFolder) {
            objectFolder2 = (ObjectFolder)objectNode;
            if (this.cq == null) {
                this.cq = new LocalAxis2Df();
            }
            this.cq.mRot = KxModuleUtil.getFloat(objectFolder2, GeomNodeName.rot);
            this.cq.mX = KxModuleUtil.getFloat(objectFolder2, GeomNodeName.x);
            this.cq.mY = KxModuleUtil.getFloat(objectFolder2, GeomNodeName.y);
        }
        if ((objectNode = objectFolder.getNode(GeomNodeName.backgeoms.name())) != null && objectNode instanceof ObjectFolder) {
            objectFolder2 = (ObjectFolder)objectNode;
            this.c(objectFolder2, this.co);
        }
        if ((objectNode = objectFolder.getNode(GeomNodeName.foregeoms.name())) != null && objectNode instanceof ObjectFolder) {
            objectFolder2 = (ObjectFolder)objectNode;
            this.c(objectFolder2, this.cp);
        }
    }

    private ObjectFolder a(SVector3d sVector3d, Enum<?> enum_) {
        ObjectFolder objectFolder = KxModuleUtil.createNode(enum_);
        KxModuleUtil.addString(objectFolder, GeomNodeName.value, sVector3d.toString());
        return objectFolder;
    }

    private void a(ObjectFolder objectFolder, SVector3d sVector3d, Enum<?> enum_) {
        ObjectNode objectNode = KxModuleUtil.getNode(objectFolder, enum_);
        if (objectNode != null && objectNode instanceof ObjectFolder) {
            ObjectFolder objectFolder2 = (ObjectFolder)objectNode;
            String string = KxModuleUtil.getString(objectFolder2, GeomNodeName.value);
            sVector3d.parseVector(string);
        }
    }

    private void b(ObjectFolder objectFolder, Vector<Geometory> vector) {
        for (Geometory geometory : vector) {
            AbstractTerraceGeometory abstractTerraceGeometory;
            if (!(geometory instanceof AbstractTerraceGeometory) || !(abstractTerraceGeometory = (AbstractTerraceGeometory)geometory).isSaveGeom()) continue;
            if (abstractTerraceGeometory.isCustomGeom()) {
                abstractTerraceGeometory.save(objectFolder);
                continue;
            }
            ObjectFolder objectFolder2 = KxModuleUtil.createNode(GeomNodeName.terraceGeometory);
            abstractTerraceGeometory.save(objectFolder2);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
    }

    private void c(ObjectFolder objectFolder, Vector<Geometory> vector) {
        Vector vector2 = objectFolder.getNamedElement(GeomNodeName.terraceGeometory.name());
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                Object e = vector2.elementAt(n);
                if (e instanceof ObjectFolder) {
                    ObjectFolder objectFolder2 = (ObjectFolder)e;
                    String string = KxModuleUtil.getString(objectFolder2, GeomNodeName.type);
                    AbstractTerraceGeometory abstractTerraceGeometory = GeomType.valueOf(string).createInstance();
                    abstractTerraceGeometory.load(objectFolder2);
                    vector.add(abstractTerraceGeometory);
                }
                ++n;
            }
        }
    }
}

