/*
 * Decompiled with CFR 0.152.
 */
package option.threed.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JPanel;
import option.threed.IScreen3D;
import option.threed.ui.IPanel3D;

public class Panel3D
extends JPanel
implements IPanel3D {
    private BufferedImage cg;
    private int[] rgb;
    private IScreen3D ch = null;
    private Dimension minimumSize = null;
    private boolean ck = false;

    public Panel3D() {
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.addComponentListener(new ComponentListener(){

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                Panel3D.this.b();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public Panel3D(int n, int n2) {
        this();
        this.minimumSize = new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        return super.getPreferredSize();
    }

    public Component getComponent() {
        return this;
    }

    public void add3DUI(IScreen3D iScreen3D) {
        this.ck = false;
        this.ch = iScreen3D;
        if (this.ch != null) {
            this.initImage();
            this.ch.updateBuffer(this.rgb, this.cg.getWidth(), this.cg.getHeight());
        }
    }

    public int getScreenHeight() {
        if (this.cg != null) {
            return this.cg.getHeight();
        }
        return 100;
    }

    public int getScreenWidth() {
        if (this.cg != null) {
            return this.cg.getWidth();
        }
        return 100;
    }

    public void remove3DUI(IScreen3D iScreen3D) {
        this.ch = null;
    }

    private void b() {
        if (!this.isShowing()) {
            return;
        }
        this.repaintTemporary();
    }

    protected void paintComponent(Graphics graphics) {
        this.ck = true;
        super.paintComponent(graphics);
        if (!this.isEnabled()) {
            Dimension dimension = this.getSize();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            return;
        }
        if (this.ch == null) {
            return;
        }
        if (this.updateImage()) {
            this.ch.updateBuffer(this.rgb, this.cg.getWidth(), this.cg.getHeight());
        }
        graphics.drawImage(this.cg, 0, 0, null);
    }

    public boolean updateImage() {
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        boolean bl = false;
        if (this.cg == null) {
            bl = true;
        } else {
            int n = this.cg.getWidth();
            int n2 = this.cg.getHeight();
            if (n != dimension.width || n2 != dimension.height) {
                bl = true;
            }
        }
        if (bl) {
            this.cg = new BufferedImage(dimension.width, dimension.height, 1);
            this.rgb = ((DataBufferInt)this.cg.getRaster().getDataBuffer()).getData();
        }
        return bl;
    }

    public void repaintTemporary() {
        if (!this.ck) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.cg != null) {
            graphics.drawImage(this.cg, 0, 0, null);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.ch != null) {
            this.ch.mouseDragged(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.ch != null) {
            this.ch.mouseMoved(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.ch != null) {
            this.ch.mouseEntered(mouseEvent.getX(), mouseEvent.getY());
        }
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.ch != null) {
            this.ch.mouseExited(mouseEvent.getX(), mouseEvent.getY());
        }
        this.transferFocus();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.ch != null) {
            this.ch.mouseReleased(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.ch != null) {
            this.ch.keyPressed(keyEvent.getKeyCode(), keyEvent.getModifiers());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.ch != null) {
            this.ch.keyReleased(keyEvent.getKeyCode());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.ch != null) {
            int n = mouseWheelEvent.getWheelRotation();
            this.ch.mouseWheelMoved(n);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.requestFocus();
        } else {
            this.transferFocus();
        }
    }

    public void initImage() {
        if (this.rgb == null) {
            this.updateImage();
        }
    }
}

