/*
 * Decompiled with CFR 0.152.
 */
package model.primitive;

import java.awt.Color;
import java.util.Vector;
import model.entity.ModelCtrlInfo;
import model.primitive.LsShape;
import model.primitive.Primitive3D;
import model.shape.primitive.SMatrix4d;
import model.util.Primitive2DGenerator;
import model.util.PrimitiveGenerator;
import model.util.SurfaceModelTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STorus
extends Primitive3D {
    public double[] center;
    public double[] normal;
    public double radiusMajor;
    public double radiusMinor;
    public double radStart = 0.0;
    private double bV = Math.PI;
    public double[] u;
    public double[] v;
    public boolean dispEdge = true;
    public boolean drawStart = false;
    public boolean drawEnd = false;
    public Color fillColor = null;
    public Color edgeColor = null;
    private int bW = 12;
    private int bX = 12;

    @Override
    public void to2DPrim(Vector<LsShape> vector, SMatrix4d sMatrix4d, ModelCtrlInfo modelCtrlInfo) {
        Primitive2DGenerator.getInstance().addTorus(vector, this, sMatrix4d);
    }

    @Override
    public void translate3D(PrimitiveGenerator primitiveGenerator, SMatrix4d sMatrix4d) {
        LsShape lsShape = SurfaceModelTranslator.getInstance().create(this, sMatrix4d);
        primitiveGenerator.addShape(lsShape);
        lsShape.clearLink();
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void setDivideCount(int n) {
        if (n <= 2) {
            n = 3;
        }
        this.bW = n;
    }

    public void setDivideCountMinor(int n) {
        if (n <= 2) {
            n = 3;
        }
        this.bX = n;
    }

    public int getDivideCount() {
        return this.bW;
    }

    public int getDivideMinorCircle() {
        return this.bX;
    }

    public double getRadExtent() {
        return this.bV;
    }

    public void setRadExtent(double d) {
        if (d <= 0.0) {
            d = Math.PI;
        } else if (Math.PI * 2 < d) {
            d = Math.PI * 2;
        }
        this.bV = d;
    }
}

