/*
 * Decompiled with CFR 0.152.
 */
package model.primitive;

import java.awt.Color;
import java.util.Vector;
import model.entity.ModelCtrlInfo;
import model.primitive.LsShape;
import model.primitive.Primitive3D;
import model.shape.primitive.SMatrix4d;
import model.util.Primitive2DGenerator;
import model.util.PrimitiveGenerator;
import model.util.SurfaceModelTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCylinder
extends Primitive3D {
    public double[] center;
    public double radius;
    public double[] dir;
    public boolean dispTop = true;
    public boolean dispBot = true;
    public boolean dispEdge = true;
    public Color fillColor = null;
    public Color edgeColor = null;
    private int bU = 12;

    @Override
    public void translate3D(PrimitiveGenerator primitiveGenerator, SMatrix4d sMatrix4d) {
        LsShape lsShape = SurfaceModelTranslator.getInstance().create(this, sMatrix4d);
        primitiveGenerator.addShape(lsShape);
        lsShape.clearLink();
    }

    @Override
    public void to2DPrim(Vector<LsShape> vector, SMatrix4d sMatrix4d, ModelCtrlInfo modelCtrlInfo) {
        Primitive2DGenerator.getInstance().addCylinder(vector, this, sMatrix4d);
    }

    @Override
    public void clear() {
        this.center = null;
        this.dir = null;
        this.edgeColor = null;
        this.fillColor = null;
    }

    public void setDivideCount(int n) {
        if (n <= 2) {
            n = 3;
        }
        this.bU = n;
    }

    public int getDivideCount() {
        return this.bU;
    }
}

