/*
 * Decompiled with CFR 0.152.
 */
package model.primitive;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import model.entity.ModelCtrlInfo;
import model.primitive.LsObject;
import model.primitive.LsSurface;
import model.primitive.Primitive3D;
import model.shape.primitive.SMatrix4d;
import model.shape.primitive.SVector3d;
import model.util.PrimitiveGenerator;
import option.gad.core.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LsShape
extends Primitive3D
implements LsObject {
    private List<LsSurface> bR;
    private List<SVector3d> bS;
    public Color fillColor = Color.WHITE;
    public Color edgeColor = Color.BLACK;
    public boolean drawBothSide = false;
    public boolean projection2dVisible = true;
    public boolean section2dVisible = true;
    public SMatrix4d tempMatrix = null;

    protected LsShape() {
        this(false);
    }

    protected LsShape(boolean bl) {
        this.bR = new ArrayList<LsSurface>();
        this.bS = new ArrayList<SVector3d>();
        this.drawBothSide = bl;
    }

    public List<LsSurface> getSurfaces() {
        return this.bR;
    }

    public List<SVector3d> getVertices() {
        return this.bS;
    }

    @Override
    public void build() {
        for (LsSurface lsSurface : this.bR) {
            lsSurface.build();
        }
        this.bS.clear();
        for (LsSurface lsSurface : this.bR) {
            List<SVector3d> list = lsSurface.getVertices();
            for (SVector3d sVector3d : list) {
                if (this.bS.contains(sVector3d)) continue;
                this.bS.add(sVector3d);
            }
        }
    }

    @Override
    public void clearLink() {
        if (this.bR != null) {
            for (LsSurface lsSurface : this.bR) {
                lsSurface.clearLink();
            }
            this.bR = null;
        }
        if (this.bS != null) {
            this.bS.clear();
            this.bS = null;
        }
    }

    @Override
    public void translate3D(PrimitiveGenerator primitiveGenerator, SMatrix4d sMatrix4d) {
        this.tempMatrix = sMatrix4d;
        primitiveGenerator.addShape(this);
        this.tempMatrix = null;
    }

    @Override
    public void to2DPrim(Vector<LsShape> vector, SMatrix4d sMatrix4d, ModelCtrlInfo modelCtrlInfo) {
        if (sMatrix4d != null) {
            SVector3d sVector3d = new SVector3d();
            LsShape lsShape = (LsShape)ObjectUtil.deepCopy((Serializable)this);
            for (SVector3d sVector3d2 : lsShape.getVertices()) {
                sMatrix4d.translate(sVector3d, sVector3d2.x, sVector3d2.y, sVector3d2.z);
                sVector3d2.set(sVector3d);
            }
            vector.add(lsShape);
        } else {
            vector.add(this);
        }
    }
}

