/*
 * Decompiled with CFR 0.152.
 */
package model.shape.primitive;

import java.io.Serializable;
import kinoki3exchange.StringUtil;

public class SVector3d
implements Serializable {
    private static final String delim = ",";
    public double x;
    public double y;
    public double z;

    public SVector3d() {
    }

    public SVector3d(double d, double d2, double d3) {
        this();
        this.set(d, d2, d3);
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void set(SVector3d sVector3d) {
        this.x = sVector3d.x;
        this.y = sVector3d.y;
        this.z = sVector3d.z;
    }

    public double length() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d == 0.0) {
            return 0.0;
        }
        if (d != 0.0) {
            return Math.sqrt(d);
        }
        return 1.0;
    }

    public void normalize() {
        double d = this.length();
        this.x /= d;
        this.y /= d;
        this.z /= d;
    }

    public void add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
    }

    public void add(SVector3d sVector3d) {
        if (sVector3d != null) {
            this.add(sVector3d.x, sVector3d.y, sVector3d.z);
        }
    }

    public void scale(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public double dot(SVector3d sVector3d) {
        return this.x * sVector3d.x + this.y * sVector3d.y + this.z * sVector3d.z;
    }

    public void cross(SVector3d sVector3d, SVector3d sVector3d2) {
        this.x = sVector3d.y * sVector3d2.z - sVector3d.z * sVector3d2.y;
        this.y = sVector3d.z * sVector3d2.x - sVector3d.x * sVector3d2.z;
        this.z = sVector3d.x * sVector3d2.y - sVector3d.y * sVector3d2.x;
    }

    public String toString() {
        return StringUtil.toString(new double[]{this.x, this.y, this.z}, delim);
    }

    public void parseVector(String string) {
        float[] fArray = StringUtil.parseFloatArray(string, delim);
        if (fArray != null && fArray.length == 3) {
            this.x = fArray[0];
            this.y = fArray[1];
            this.z = fArray[2];
        }
    }
}

