/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import com.kt.annotation.Reflectable;
import com.kt.util.StringUtil;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import option.gad.core.annotation.GdTransient;
import option.gad.core.dxo.GdTypeConvertable;
import option.gad.core.dxo.TypeConvertUtil;
import option.gad.core.util.ClassInfo;
import option.gad.core.util.ClassInfoManager;
import option.gad.core.util.NameUtil;
import option.gad.core.util.ObjectUtil;
import option.gad.core.util.ReflectUtil;
import option.gad.core.util.StructUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFolderUtil
extends com.kt.util.ObjectFolderUtil {
    protected ObjectFolderUtil() {
    }

    public static <A extends Annotation> ObjectFolder createFolder(Object object) {
        return ObjectFolderUtil.createFolder(object, null);
    }

    public static <A extends Annotation> ObjectFolder createFolder(Object object, Class<A> clazz) {
        String string = NameUtil.correctCamelCase(object.getClass().getSimpleName());
        return ObjectFolderUtil.createFolder(object, string, clazz);
    }

    public static <A extends Annotation> ObjectFolder createFolder(Object object, String string) {
        return ObjectFolderUtil.createFolder(object, string, null);
    }

    public static <A extends Annotation> ObjectFolder createFolder(Object object, String string, Class<A> clazz) {
        ObjectFolder objectFolder = new ObjectFolder(string);
        ObjectFolderUtil.addObject(objectFolder, string, object, clazz);
        return objectFolder;
    }

    public static <A extends Annotation> void addObject(ObjectFolder objectFolder, Object object, Class<A> clazz) {
        ObjectFolderUtil.addObject(objectFolder, null, object, clazz);
    }

    public static <A extends Annotation> void addObject(ObjectFolder objectFolder, String string, Object object, Class<A> clazz) {
        if (object == null) {
            return;
        }
        ClassInfo classInfo = ClassInfoManager.getInstance().getClassInfo(object.getClass());
        if (ObjectUtil.isLangType(object)) {
            ObjectFolderUtil.addPrimitive(objectFolder, object);
            return;
        }
        if (classInfo.getType().isArray()) {
            ObjectFolderUtil.addArray(objectFolder, string, (Object[])object, clazz);
            return;
        }
        ObjectFolderUtil.addStruct(objectFolder, object, clazz);
    }

    public static <A extends Annotation> void addStruct(ObjectFolder objectFolder, Object object, Class<A> clazz) {
        if (object == null) {
            return;
        }
        String object22 = ObjectFolderUtil.createTypeName(object);
        objectFolder.addChild(new ObjectNode("type", (Object)object22));
        for (Field field : ReflectUtil.getFields(object)) {
            Object object2;
            if (field.getAnnotation(GdTransient.class) != null || clazz != null && field.getAnnotation(clazz) == null || (object2 = ReflectUtil.getFieldValue(object, field)) == null) continue;
            String string = NameUtil.removePrefix(field.getName());
            if (ObjectUtil.isLangType(object2)) {
                ObjectFolderUtil.addValue(objectFolder, string, object2);
                continue;
            }
            if (object2 instanceof GdTypeConvertable) {
                ObjectFolderUtil.addValue(objectFolder, string, object2);
                continue;
            }
            ObjectFolder objectFolder2 = ObjectFolderUtil.createFolder(object2, string, clazz);
            objectFolder.addChild((ObjectNode)objectFolder2);
        }
    }

    protected static <A extends Annotation> void addArray(ObjectFolder objectFolder, String string, Object[] object, Class<A> clazz) {
        if (object == null) {
            return;
        }
        string = NameUtil.removePrefix(string);
        string = NameUtil.correctCamelCase(string);
        Object[] objectArray = object;
        int n = ((Object[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            ObjectFolder objectFolder2 = new ObjectFolder(string);
            ObjectFolderUtil.addObject(objectFolder2, string, object, clazz);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
            ++n2;
        }
    }

    protected static void addPrimitive(ObjectFolder objectFolder, Object object) {
        String string = ObjectFolderUtil.createTypeName(object);
        ObjectFolderUtil.addValue(objectFolder, "type", string);
        ObjectFolderUtil.addValue(objectFolder, "value", object);
    }

    protected static void addValue(ObjectFolder objectFolder, Object object) {
        ObjectFolderUtil.addValue(objectFolder, "value", object);
    }

    protected static void addValue(ObjectFolder objectFolder, String string, Object object) {
        if (string == null) {
            return;
        }
        if (object == null) {
            return;
        }
        string = NameUtil.removePrefix(string);
        string = NameUtil.correctCamelCase(string);
        if (StringUtil.isEmpty((String)(object = TypeConvertUtil.convertString(object)))) {
            return;
        }
        objectFolder.addChild(new ObjectNode(string, object));
    }

    public static <T, A extends Annotation> T createObject(Class<T> clazz, ObjectFolder objectFolder, Class<A> clazz2) {
        if (ObjectUtil.isLangType(clazz)) {
            return ObjectFolderUtil.createPrimitive(clazz, objectFolder);
        }
        return ObjectFolderUtil.createStruct(clazz, objectFolder, clazz2);
    }

    protected static <T, A extends Annotation> T createStruct(Class<T> clazz, ObjectFolder object, Class<A> clazz2) {
        object = object.getChildlen();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (ObjectNode)iterator.next();
            linkedHashMap.put(object.getName(), object.getObject());
        }
        return StructUtil.createStruct(clazz, linkedHashMap, clazz2);
    }

    protected static Object[] createArray(ObjectFolder object) {
        object = object.getChildlen();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (ObjectNode)iterator.next();
            arrayList.add(((ObjectFolder)object).getNode("value").getObject());
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public static <T> T createPrimitive(Class<T> clazz, ObjectFolder object) {
        object = object.getNode("value");
        object = ObjectFolder.getNodeString((ObjectNode)object);
        return TypeConvertUtil.convertObject(clazz, (String)object);
    }

    protected static String createTypeName(Object clazz) {
        if (clazz == null) {
            return null;
        }
        String string = null;
        Reflectable reflectable = (clazz = clazz.getClass()).getAnnotation(Reflectable.class);
        if (reflectable != null) {
            string = reflectable.name();
        }
        if (StringUtil.isEmpty(string)) {
            string = clazz.getName();
        }
        return string;
    }
}

