/*
 * Decompiled with CFR 0.152.
 */
package geom;

import com.kt.geom.KLocalAxis;
import com.kt.util.tree.ObjectFolder;
import geom.GeomType;
import geom.TerraceGeometory;
import geom.util.HatchUtil;
import java.awt.Color;
import java.util.Vector;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KLineType;
import kinoki3exchange.KxModuleUtil;
import nethome.geom.LocalAxis2Df;
import proto.graphics2d.GeomNodeName;

public class GRect2d
extends TerraceGeometory {
    public float x1;
    public float y1;
    public float x2;
    public float y2;

    public GRect2d() {
        this.drawLine = true;
        this.type = GeomType.RECT;
    }

    public void setPoint(double d, double d2, double d3, double d4) {
        double d5 = d < d3 ? d : d3;
        double d6 = d < d3 ? d3 : d;
        double d7 = d2 < d4 ? d2 : d4;
        double d8 = d2 < d4 ? d4 : d2;
        this.x1 = (float)d5;
        this.x2 = (float)d6;
        this.y1 = (float)d7;
        this.y2 = (float)d8;
    }

    public boolean isInner(double d, double d2) {
        if (d < (double)this.x1 || (double)this.x2 < d) {
            return false;
        }
        return !(d2 < (double)this.y1) && !((double)this.y2 < d2);
    }

    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        iRichGraphics.pathInit(0);
        iRichGraphics.pathMoveTo((double)this.x1, (double)this.y1, (KLocalAxis)localAxis2Df);
        iRichGraphics.pathLineTo((double)this.x2, (double)this.y1, (KLocalAxis)localAxis2Df);
        iRichGraphics.pathLineTo((double)this.x2, (double)this.y2, (KLocalAxis)localAxis2Df);
        iRichGraphics.pathLineTo((double)this.x1, (double)this.y2, (KLocalAxis)localAxis2Df);
        iRichGraphics.pathClose();
        Color color3 = color2;
        if (color3 == null) {
            color3 = this.getGeomColor();
        }
        if (color3 == null) {
            color3 = Color.WHITE;
        }
        if (this.fillArea) {
            iRichGraphics.setColor(color3);
            iRichGraphics.fillPath(null);
        }
        if (this.drawLine) {
            KLineType kLineType = this.lineType;
            if (kLineType == null) {
                kLineType = IRichGraphics.LINE_1;
            }
            if ((color3 = color) == null) {
                color3 = this.lineColor;
            }
            if (color3 == null) {
                color3 = Color.BLACK;
            }
            iRichGraphics.setColor(color3);
            iRichGraphics.drawPath(kLineType);
        }
        iRichGraphics.pathClear();
        if (this.hatchmode != 0) {
            this.drawHatch(iRichGraphics, color, color2, localAxis2Df);
        }
    }

    public void drawHighLight(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df, float f) {
        iRichGraphics.pathInit(0);
        iRichGraphics.pathMoveTo((double)(this.x1 + f), (double)(this.y1 + f), (KLocalAxis)localAxis2Df);
        iRichGraphics.pathLineTo((double)(this.x2 - f), (double)(this.y1 + f), (KLocalAxis)localAxis2Df);
        iRichGraphics.pathLineTo((double)(this.x2 - f), (double)(this.y2 - f), (KLocalAxis)localAxis2Df);
        iRichGraphics.pathLineTo((double)(this.x1 + f), (double)(this.y2 - f), (KLocalAxis)localAxis2Df);
        iRichGraphics.pathClose();
        Color color3 = color2;
        if (color3 == null) {
            color3 = this.getGeomColor();
        }
        if (color3 == null) {
            color3 = Color.WHITE;
        }
        if (color != null) {
            KLineType kLineType = this.lineType;
            if (kLineType == null) {
                kLineType = IRichGraphics.LINE_DASH_1;
            }
            if ((color3 = color) == null) {
                color3 = this.lineColor;
            }
            if (color3 == null) {
                color3 = Color.BLACK;
            }
            iRichGraphics.setColor(color3);
            iRichGraphics.drawPath(kLineType);
        }
        iRichGraphics.pathClear();
        if (this.hatchmode != 0) {
            this.drawHatch(iRichGraphics, color, color2, localAxis2Df);
        }
    }

    public void updateHatch() {
        Vector<double[]> vector = new Vector<double[]>();
        vector.addElement(new double[]{this.x1, this.y2});
        vector.addElement(new double[]{this.x1, this.y1});
        vector.addElement(new double[]{this.x2, this.y1});
        vector.addElement(new double[]{this.x2, this.y2});
        this.hatchObjects = HatchUtil.createHatch(vector, this.hatchmode);
    }

    public void save(ObjectFolder objectFolder) {
        super.save(objectFolder);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.x1, this.x1);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.y1, this.y1);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.x2, this.x2);
        KxModuleUtil.addFloat(objectFolder, GeomNodeName.y2, this.y2);
        Color color = this.getGeomColor();
        if (color != null) {
            KxModuleUtil.addInt(objectFolder, GeomNodeName.fillColor, color.getRGB());
        }
    }

    public void load(ObjectFolder objectFolder) {
        super.load(objectFolder);
        this.x1 = KxModuleUtil.getFloat(objectFolder, GeomNodeName.x1);
        this.y1 = KxModuleUtil.getFloat(objectFolder, GeomNodeName.y1);
        this.x2 = KxModuleUtil.getFloat(objectFolder, GeomNodeName.x2);
        this.y2 = KxModuleUtil.getFloat(objectFolder, GeomNodeName.y2);
        if (KxModuleUtil.getNode(objectFolder, GeomNodeName.fillColor) != null) {
            int n = KxModuleUtil.getInt(objectFolder, GeomNodeName.fillColor);
            this.setGeomColor(new Color(n));
        }
    }
}

