/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import option.io.pdfcommon.io.PdfOutFile;

public class PdfRect {
    private float dC;
    private float dD;
    private float dE;
    private float dF;

    public PdfRect() {
    }

    public PdfRect(float f, float f2, float f3, float f4) {
        this.setPoints(f, f2, f3, f4);
    }

    public float getWidth() {
        return this.dE - this.dC;
    }

    public float getHeight() {
        return this.dF - this.dD;
    }

    public float getLux() {
        return this.dC;
    }

    public float getLuy() {
        return this.dD;
    }

    public float getRdx() {
        return this.dE;
    }

    public float getRdy() {
        return this.dF;
    }

    public void setPoints(float f, float f2, float f3, float f4) {
        this.setLux(f);
        this.setLuy(f2);
        this.setRdx(f3);
        this.setRdy(f4);
    }

    public void setLux(float f) {
        this.dC = f;
    }

    public void setLuy(float f) {
        this.dD = f;
    }

    public void setRdx(float f) {
        this.dE = f;
    }

    public void setRdy(float f) {
        this.dF = f;
    }

    public void changeDirection() {
        float f = this.dE;
        this.dE = this.dF;
        this.dF = f;
    }

    public void rotate(float f) {
        f = (float)Math.PI * f / 180.0f;
        float f2 = (float)Math.cos(f);
        f = (float)Math.sin(f);
        this.dC = f2 * this.dC - f * this.dD;
        this.dD = f * this.dC + f2 * this.dD;
        this.dE = f2 * this.dE - f * this.dF;
        this.dF = f * this.dE + f2 * this.dF;
    }

    public void scale(float f, float f2) {
        this.dE = this.dC + (this.dE - this.dC) * f;
        this.dF = this.dD + (this.dF - this.dD) * f2;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("[ ");
        printWriter.print(this.dC);
        printWriter.print(" ");
        printWriter.print(this.dD);
        printWriter.print(" ");
        printWriter.print(this.dE);
        printWriter.print(" ");
        printWriter.print(this.dF);
        printWriter.print(" ]");
        printWriter.close();
        return stringWriter.toString();
    }

    public void write(PdfOutFile object) {
        object = ((PdfOutFile)object).getPrintStream();
        ((PrintStream)object).println(this.toString());
    }
}

