/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import option.io.pdfcommon.util.PdfUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PdfMetrices {
    public static final int TRANSLATE = 1;
    public static final int ROTATE = 2;
    public static final int SCALE = 3;
    public static final int SKEW = 4;
    public static final int TEXT_TYPE = 1;
    public static final int IMAGE_TYPE = 2;
    public static final int FORM_TYPE = 3;
    private int[] do = new int[4];
    private float[][] dp = new float[3][3];
    private boolean dq = false;
    private boolean dr = false;
    private boolean ds = false;
    private boolean dt = false;
    private float du;
    private float dv;
    private float dw;
    private float dx;
    private float dy;
    private float dz;
    private float dA;
    private int dB = 0;
    private PdfUtil ab = new PdfUtil();

    public PdfMetrices(int n) {
        this.dB = n;
        PdfMetrices pdfMetrices = this;
        pdfMetrices.do[0] = 1;
        pdfMetrices.do[1] = 2;
        pdfMetrices.do[2] = 3;
        pdfMetrices.do[3] = 4;
    }

    public void setTranslation(float f, float f2) {
        this.du = f;
        this.dv = f2;
        this.dq = true;
    }

    public float getTranslationX() {
        return this.du;
    }

    public float getTranslationY() {
        return this.dv;
    }

    public void setScale(float f, float f2) {
        this.dw = f;
        this.dx = f2;
        this.dr = true;
    }

    public float getScaleX() {
        return this.dw;
    }

    public float getScaleY() {
        return this.dx;
    }

    public void setRotation(float f) {
        this.dy = (float)Math.PI * f / 180.0f;
        this.ds = true;
    }

    public float getRotateTheta() {
        return this.dy;
    }

    public void setSkew(float f, float f2) {
        this.dz = (float)Math.PI * f / 180.0f;
        this.dA = (float)Math.PI * f2 / 180.0f;
        this.dt = true;
    }

    public float getSkewX() {
        return this.dz;
    }

    public float getSkewY() {
        return this.dA;
    }

    public final String toString() {
        PdfMetrices.a(this.dp);
        float[][] fArray = new float[3][3];
        int n = 0;
        while (n < this.do.length) {
            switch (this.do[n]) {
                case 1: {
                    if (!this.dq) break;
                    PdfMetrices.a(fArray);
                    fArray[2][0] = this.du;
                    fArray[2][1] = this.dv;
                    this.dp = this.multiply(fArray, this.dp);
                    break;
                }
                case 3: {
                    if (!this.dr) break;
                    PdfMetrices.a(fArray);
                    fArray[0][0] = this.dw;
                    fArray[1][1] = this.dx;
                    this.dp = this.multiply(fArray, this.dp);
                    break;
                }
                case 2: {
                    if (!this.ds) break;
                    PdfMetrices.a(fArray);
                    float f = (float)Math.cos(this.dy);
                    float f2 = (float)Math.sin(this.dy);
                    fArray[0][0] = f;
                    fArray[0][1] = -f2;
                    fArray[1][0] = f2;
                    fArray[1][1] = f;
                    this.dp = this.multiply(fArray, this.dp);
                    break;
                }
                case 4: {
                    if (!this.dt) break;
                    PdfMetrices.a(fArray);
                    float f = (float)Math.tan(this.dz);
                    float f2 = (float)Math.tan(this.dA);
                    fArray[0][0] = 1.0f;
                    fArray[0][1] = f;
                    fArray[1][0] = f2;
                    fArray[1][1] = 1.0f;
                    this.dp = this.multiply(fArray, this.dp);
                }
            }
            ++n;
        }
        return this.toString(this.dp[0][0], this.dp[0][1], this.dp[1][0], this.dp[1][1], this.dp[2][0], this.dp[2][1]);
    }

    private static void a(float[][] fArray) {
        if (fArray == null) {
            return;
        }
        int n = fArray.length;
        int n2 = fArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                fArray[n3][n4] = n3 == n4 ? 1 : 0;
                ++n4;
            }
            ++n3;
        }
    }

    public String toString(float f, float f2, float f3, float f4, float f5, float f6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.ab.formatPrint(f)) + " ");
        stringBuffer.append(String.valueOf(this.ab.formatPrint(f2)) + " ");
        stringBuffer.append(String.valueOf(this.ab.formatPrint(f3)) + " ");
        stringBuffer.append(String.valueOf(this.ab.formatPrint(f4)) + " ");
        stringBuffer.append(String.valueOf(this.ab.formatPrint(f5)) + " ");
        stringBuffer.append(String.valueOf(this.ab.formatPrint(f6)) + " ");
        if (this.dB == 1) {
            stringBuffer.append("Tm\n");
        } else {
            stringBuffer.append("cm\n");
        }
        return stringBuffer.toString();
    }

    public int getType() {
        return this.dB;
    }

    public void setType(int n) {
        this.dB = n;
    }

    public int[] getTransformOrder() {
        return this.do;
    }

    public void setTransformOrder(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        this.do = nArray;
    }

    public float[][] multiply(float[][] fArray, float[][] fArray2) {
        if (fArray == null || fArray2 == null || fArray.length != fArray2.length) {
            throw new IllegalArgumentException();
        }
        int n = fArray.length;
        int n2 = fArray[0].length;
        float[][] fArray3 = new float[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n2) {
                    float[] fArray4 = fArray3[n3];
                    int n6 = n4;
                    fArray4[n6] = fArray4[n6] + fArray[n3][n5] * fArray2[n5][n4];
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return fArray3;
    }
}

