/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import gui.basic.ImageIcon;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class GraphicsButton
extends Component {
    public static final int STATE_NORMAL = 1;
    public static final int STATE_PRESSED = 0;
    private int m = 1;
    protected ImageIcon mForeImage;
    protected ImageIcon mFocusImage;
    private ActionListener n;
    private boolean o;
    private boolean p;

    public GraphicsButton(String string, Image image, Image image2) {
        this.setName(string);
        if (image != null) {
            this.mForeImage = new ImageIcon(image);
        }
        if (image2 != null) {
            this.mFocusImage = new ImageIcon(image2);
        }
        this.addMouseListener(new ButtonMouseAdapter(this));
        this.addMouseMotionListener(new ButtonMouseMotionAdapter(this));
    }

    public int getState() {
        return this.m;
    }

    public Dimension getPreferredSize() {
        if (this.mForeImage != null) {
            return this.mForeImage.getPreferredSize();
        }
        if (this.mFocusImage != null) {
            return this.mFocusImage.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    protected void setState(int n) {
        if (this.m == n || n != 1 && n != 0) {
            return;
        }
        this.m = n;
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        if (this.mForeImage != null) {
            this.mForeImage.setEnabled(bl);
        }
        super.setEnabled(bl);
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.mForeImage != null) {
            this.mForeImage.paint(graphics);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.o && this.mFocusImage != null) {
            this.mFocusImage.paint(graphics);
        }
    }

    protected void paintButtonNormal() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getState() == 0) {
            Point point = this.getLocation();
            this.setLocation(point.x - 1, point.y - 1);
        }
        this.setState(1);
    }

    protected void paintButtonPressed() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getState() == 1) {
            Point point = this.getLocation();
            this.setLocation(point.x + 1, point.y + 1);
        }
        this.setState(0);
    }

    public void addActionListener(ActionListener actionListener) {
        this.n = AWTEventMulticaster.add(this.n, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.n = AWTEventMulticaster.remove(this.n, actionListener);
    }

    protected void dispatchEvent() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.n != null) {
            this.n.actionPerformed(new ActionEvent(this, 1001, "GraphicButton Action"));
        }
    }

    class ButtonMouseAdapter
    extends MouseAdapter {
        private /* synthetic */ GraphicsButton q;

        ButtonMouseAdapter(GraphicsButton graphicsButton) {
            this.q = graphicsButton;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.q.paintButtonPressed();
            this.q.p = true;
        }

        public void mouseReleased(MouseEvent object) {
            this.q.paintButtonNormal();
            if (this.q.contains(((MouseEvent)object).getX(), ((MouseEvent)object).getY())) {
                object = this;
                if (((ButtonMouseAdapter)object).q.o && ((ButtonMouseAdapter)object).q.p) {
                    ((ButtonMouseAdapter)object).q.dispatchEvent();
                    ((ButtonMouseAdapter)object).q.p = false;
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.q.o = true;
            if (this.q.mFocusImage != null) {
                this.q.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.q.o = false;
            if (this.q.mFocusImage != null) {
                this.q.repaint();
            }
        }
    }

    class ButtonMouseMotionAdapter
    extends MouseMotionAdapter {
        private /* synthetic */ GraphicsButton q;

        ButtonMouseMotionAdapter(GraphicsButton graphicsButton) {
            this.q = graphicsButton;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.q.contains(mouseEvent.getX(), mouseEvent.getY())) {
                if (this.q.m == 1) {
                    this.q.paintButtonPressed();
                    return;
                }
            } else if (this.q.m == 0) {
                this.q.paintButtonNormal();
            }
        }
    }
}

