/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class PdfOutFile {
    public static final char SEPARATOR = File.separatorChar;
    public static final String LN = "\r\n";
    private String cu;
    private String mFileName;
    private ByteArrayOutputStream cv = new ByteArrayOutputStream();
    private PrintStream ps = new PrintStream(this.cv);
    private FileOutputStream cw;

    protected void finalize() throws Throwable {
        IOException iOException;
        try {
            if (this.cv != null) {
                this.cv.close();
            }
            this.cv = null;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException2.printStackTrace();
        }
        try {
            if (this.cw != null) {
                this.cw.close();
            }
            this.cw = null;
        }
        catch (IOException iOException3) {
            iOException = iOException3;
            iOException3.printStackTrace();
        }
        super.finalize();
    }

    public byte[] getData() {
        return this.cv.toByteArray();
    }

    public void setData(byte[] object) {
        try {
            this.cv.write((byte[])object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public ByteArrayOutputStream getByteStream() {
        return this.cv;
    }

    public PrintStream getPrintStream() {
        return this.ps;
    }

    public FileOutputStream getFileOutputStream() {
        return this.cw;
    }

    public void setFileOutputStream(FileOutputStream fileOutputStream) {
        this.cw = fileOutputStream;
    }

    public int size() {
        return this.cv.size();
    }

    public void setFile(String string) {
        this.cu = PdfOutFile.getParent(string);
        this.mFileName = PdfOutFile.getFile(string);
    }

    public String getParent() {
        return this.cu;
    }

    public String getPath() {
        String string = "";
        if (this.cu != null) {
            string = String.valueOf(string) + this.cu + SEPARATOR;
        }
        if (this.mFileName != null) {
            string = String.valueOf(string) + this.mFileName;
        }
        return string;
    }

    public String getName() {
        return this.mFileName;
    }

    public static String getParent(String string) {
        int n = (string = PdfOutFile.changeSeparator(string)).lastIndexOf(SEPARATOR);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String getFile(String string) {
        int n = (string = PdfOutFile.changeSeparator(string)).lastIndexOf(SEPARATOR);
        if (n >= 0 && n + 1 < string.length() - 1) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public static String getFileNonExt(String string) {
        if ((string = PdfOutFile.getFile(string)) == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String getCreatePath(String string, String string2) {
        string = PdfOutFile.changeSeparator(string);
        while (string.lastIndexOf(SEPARATOR) == string.length() - 1) {
            string = string.substring(0, string.length() - 1);
        }
        string2 = PdfOutFile.changeSeparator(string2);
        while (string2.charAt(0) == SEPARATOR) {
            string2 = string2.substring(1);
        }
        return String.valueOf(string) + SEPARATOR + string2;
    }

    public static String changeSeparator(String string) {
        if (SEPARATOR != '/') {
            string = string.replace('/', SEPARATOR);
        } else if (SEPARATOR != '\\') {
            string = string.replace('\\', SEPARATOR);
        }
        return string;
    }

    public void writeToFile() throws IOException {
        this.cw = null;
        try {
            System.out.println(this.getClass().getResource(""));
            this.cw = new FileOutputStream(this.getPath());
            this.cv.writeTo(this.cw);
            System.out.println(this.cw);
        }
        finally {
            if (this.cw != null) {
                this.cw.close();
            }
        }
    }

    public void writeToFile(String object) {
        try {
            this.cw = new FileOutputStream((String)object);
            try {
                this.cv.writeTo(this.cw);
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
            try {
                this.cw.close();
                return;
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    public void writeToStream(OutputStream object) {
        try {
            this.cv.writeTo((OutputStream)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void close() {
        try {
            this.ps.close();
            this.cv.close();
            if (this.cw != null) {
                this.cw.close();
                return;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.ps.flush();
            this.cv.flush();
            if (this.cw != null) {
                this.cw.flush();
                return;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
    }
}

