/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import option.io.pdfcommon.font.CmapTable;
import option.io.pdfcommon.font.DefaultTable;
import option.io.pdfcommon.font.FontDirectory;
import option.io.pdfcommon.font.HeadTable;
import option.io.pdfcommon.font.HheaTable;
import option.io.pdfcommon.font.HtmxTable;
import option.io.pdfcommon.font.LocaTable;
import option.io.pdfcommon.font.MaxpTable;
import option.io.pdfcommon.font.NameTable;
import option.io.pdfcommon.font.OS2Table;
import option.io.pdfcommon.font.PostTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class TrueTypeFile {
    private static String[] bD = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    private static int[] bE;
    private FontDirectory bF;
    private HeadTable bG;
    private MaxpTable bH;
    private HheaTable bI;
    private NameTable bJ;
    private LocaTable bK;
    private CmapTable bL;
    private OS2Table bM;
    private PostTable bN;
    private HtmxTable bO;
    private String copyRightNotice;
    private String familyName;
    private String subFamilyName;
    private String fullName;
    private String fontName;
    private int flags;
    private int bP;
    private int ascent;
    private int bQ;
    private float ItalicAngle;
    private int[] bR = new int[4];
    private byte[] panose = new byte[10];
    private Hashtable be;
    private Hashtable bS;
    private int[] bT;
    private long[] offsets;
    private Vector bU;
    private int firstChar;
    private int lastChar;
    private Hashtable tableCollection;
    public TrueTypeFontFileReader fr;
    private int[] bV;
    private byte[] bW;
    private byte[] bX;
    private int bY;
    private int bZ;
    private int[] ca;
    private int[] cb;
    private Hashtable cc;

    static {
        int[] nArray = new int[21];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        bE = nArray;
    }

    public TrueTypeFile() {
        this.bF = new FontDirectory();
        this.bU = new Vector();
    }

    public void loadFontDirectory() {
        this.bF.loadFontData(this.fr);
        this.tableCollection = this.bF.tableCollection;
        DefaultTable defaultTable = (DefaultTable)this.tableCollection.get("name");
        if (defaultTable != null) {
            this.bJ = new NameTable();
            this.bJ.tableName = defaultTable.tableName;
            this.bJ.checkSum = defaultTable.checkSum;
            this.bJ.offset = defaultTable.offset;
            this.bJ.length = defaultTable.length;
            this.bJ.loadFontData(this.fr);
        }
        this.copyRightNotice = this.bJ.copyRightNotice;
        this.familyName = this.bJ.familyName;
        this.subFamilyName = this.bJ.subFamilyName;
        this.fullName = this.bJ.fullName;
        this.fontName = this.bJ.fontName;
    }

    public void checkTTC(String string) {
        block9: {
            Object object = this.fr.readByteString(4);
            if (((String)object).equals("ttcf")) {
                try {
                    this.fr.skipBytes(4);
                    int n = (int)this.fr.readUInt32();
                    long[] lArray = new long[n];
                    int n2 = 0;
                    while (n2 < n) {
                        lArray[n2] = this.fr.readUInt32();
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < n) {
                        this.bF.offset = lArray[n2];
                        this.bF.loadFontData(this.fr);
                        this.tableCollection = this.bF.tableCollection;
                        DefaultTable defaultTable = (DefaultTable)this.tableCollection.get("name");
                        if (defaultTable != null) {
                            this.bJ = new NameTable();
                            this.bJ.tableName = defaultTable.tableName;
                            this.bJ.checkSum = defaultTable.checkSum;
                            this.bJ.offset = defaultTable.offset;
                            this.bJ.length = defaultTable.length;
                            this.bJ.loadFontData(this.fr);
                        }
                        if (!string.equals(this.bJ.familyName)) {
                            ++n2;
                            continue;
                        }
                        break block9;
                    }
                    return;
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                    System.out.println("IOException on checking ttc");
                    return;
                }
            }
            try {
                this.fr.seek(0L);
                return;
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
        }
    }

    public void LoadFontData() {
        this.loadFontDirectory();
        Object object = (DefaultTable)this.tableCollection.get("head");
        if (object != null) {
            this.bG = new HeadTable();
            this.bG.tableName = ((DefaultTable)object).tableName;
            this.bG.checkSum = ((DefaultTable)object).checkSum;
            this.bG.offset = ((DefaultTable)object).offset;
            this.bG.length = ((DefaultTable)object).length;
            this.bG.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("hhea")) != null) {
            this.bI = new HheaTable();
            this.bI.tableName = ((DefaultTable)object).tableName;
            this.bI.checkSum = ((DefaultTable)object).checkSum;
            this.bI.offset = ((DefaultTable)object).offset;
            this.bI.length = ((DefaultTable)object).length;
            this.bI.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("hmtx")) != null) {
            this.bO = new HtmxTable();
            this.bO.tableName = ((DefaultTable)object).tableName;
            this.bO.checkSum = ((DefaultTable)object).checkSum;
            this.bO.offset = ((DefaultTable)object).offset;
            this.bO.length = ((DefaultTable)object).length;
            this.bO.numOfLongHorMetrics = this.bI.numOfLongHorMetrics;
            this.bO.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("maxp")) != null) {
            this.bH = new MaxpTable();
            this.bH.tableName = ((DefaultTable)object).tableName;
            this.bH.checkSum = ((DefaultTable)object).checkSum;
            this.bH.offset = ((DefaultTable)object).offset;
            this.bH.length = ((DefaultTable)object).length;
            this.bH.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("loca")) != null) {
            this.bK = new LocaTable();
            this.bK.tableName = ((DefaultTable)object).tableName;
            this.bK.checkSum = ((DefaultTable)object).checkSum;
            this.bK.offset = ((DefaultTable)object).offset;
            this.bK.length = ((DefaultTable)object).length;
            this.bK.indexToLocFormat = this.bG.indexToLocFormat;
            this.bK.numGlyphs = this.bH.numGlyphs;
            this.bK.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("glyf")) != null && this.bK != null) {
            this.bS = new Hashtable();
            int n = 0;
            while (n < this.bK.numGlyphs) {
                int n2 = (int)(this.bK.offsets[n + 1] - this.bK.offsets[n]);
                if (n2 > 0) {
                    Object object2 = new byte[n2];
                    try {
                        this.fr.seek(((DefaultTable)object).offset + this.bK.offsets[n]);
                        this.fr.read((byte[])object2);
                        this.bS.put(new Integer(n), object2);
                    }
                    catch (IOException iOException) {
                        object2 = iOException;
                        iOException.printStackTrace();
                    }
                }
                ++n;
            }
        }
        if ((object = (DefaultTable)this.tableCollection.get("cmap")) != null) {
            this.bL = new CmapTable();
            this.bL.tableName = ((DefaultTable)object).tableName;
            this.bL.checkSum = ((DefaultTable)object).checkSum;
            this.bL.offset = ((DefaultTable)object).offset;
            this.bL.length = ((DefaultTable)object).length;
            this.bL.loadFontData(this.fr);
            this.be = this.bL.getCmaps();
        }
        if ((object = (DefaultTable)this.tableCollection.get("OS/2")) != null) {
            this.bM = new OS2Table();
            this.bM.tableName = ((DefaultTable)object).tableName;
            this.bM.checkSum = ((DefaultTable)object).checkSum;
            this.bM.offset = ((DefaultTable)object).offset;
            this.bM.length = ((DefaultTable)object).length;
            this.bM.unitsPerEm = this.bG.unitsPerEm;
            this.bM.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("post")) != null) {
            this.bN = new PostTable();
            this.bN.tableName = ((DefaultTable)object).tableName;
            this.bN.checkSum = ((DefaultTable)object).checkSum;
            this.bN.offset = ((DefaultTable)object).offset;
            this.bN.length = ((DefaultTable)object).length;
            this.bN.loadFontData(this.fr);
        }
        object = this;
        if (((TrueTypeFile)object).bG != null) {
            ((TrueTypeFile)object).bG.flags = 0;
            if (((TrueTypeFile)object).bN != null && ((TrueTypeFile)object).bN.ItalicAngle != 0.0f) {
                ((TrueTypeFile)object).bG.flags |= 0x40;
            }
            if (((TrueTypeFile)object).bM != null) {
                if (((TrueTypeFile)object).bM.panose[0] == 3) {
                    ((TrueTypeFile)object).bG.flags |= 8;
                }
                if (((TrueTypeFile)object).bM.panose[1] != 0) {
                    ((TrueTypeFile)object).bG.flags |= 2;
                }
                if (((TrueTypeFile)object).bM.panose[2] >= 8) {
                    ((TrueTypeFile)object).bG.flags |= 0x40000;
                }
                if (((TrueTypeFile)object).bM.panose[3] != 9) {
                    ((TrueTypeFile)object).bG.flags |= 1;
                }
            }
            ((TrueTypeFile)object).bG.flags |= 4;
            ((TrueTypeFile)object).bG.flags |= 0x20000;
        }
        this.flags = this.bG.flags;
        if (this.flags <= 0) {
            this.flags = 32;
        }
        this.bR[0] = this.bG.changeTTF2PdfUnit(this.bG.xMin, this.bG.unitsPerEm);
        this.bR[1] = this.bG.changeTTF2PdfUnit(this.bG.yMin, this.bG.unitsPerEm);
        this.bR[2] = this.bG.changeTTF2PdfUnit(this.bG.xMax, this.bG.unitsPerEm);
        this.bR[3] = this.bG.changeTTF2PdfUnit(this.bG.yMax, this.bG.unitsPerEm);
        this.ascent = this.bI.changeTTF2PdfUnit(this.bI.ascent, this.bG.unitsPerEm);
        this.bQ = this.bI.changeTTF2PdfUnit(this.bI.descent, this.bG.unitsPerEm);
        this.ItalicAngle = this.bN.ItalicAngle;
        this.panose = this.bM.panose;
        this.bP = this.bM.changeTTF2PdfUnit(this.bM.sCapHeight, this.bG.unitsPerEm);
        this.bT = this.bO.advanceWidths;
        this.offsets = this.bK.offsets;
    }

    public void resetUsedChars(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = this.bU.size();
            if (n2 == 0) {
                this.bU.add(new Integer(c));
                this.firstChar = c;
                this.lastChar = c;
            } else if (this.bU.indexOf(new Integer(c)) < 0) {
                this.bU.add(new Integer(c));
            }
            if (c > this.lastChar) {
                this.lastChar = c;
            }
            if (c < this.firstChar) {
                this.firstChar = c;
            }
            ++n;
        }
    }

    private static String toHex(int n) {
        String string = Integer.toHexString(n);
        return String.valueOf("<0000".substring(0, 5 - string.length())) + string + ">";
    }

    private static void a(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n] = (byte)n2;
    }

    private static void a(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n] = (byte)(l & 0xFFL);
    }

    public byte[] getFontData() {
        int n;
        int n2;
        Object object = this;
        int[] nArray = ((TrueTypeFile)object).ca;
        ((TrueTypeFile)object).bW = null;
        ((TrueTypeFile)object).bV = new int[((TrueTypeFile)object).bK.numGlyphs + 1];
        int n3 = 0;
        if (((TrueTypeFile)object).fr != null && ((TrueTypeFile)object).tableCollection != null && ((TrueTypeFile)object).bU != null) {
            int n4;
            int n5 = 0;
            while (n5 < nArray.length) {
                n4 = nArray[n5];
                int n6 = (int)(((TrueTypeFile)object).offsets[n4 + 1] - ((TrueTypeFile)object).offsets[n4]);
                n3 += n6;
                ++n5;
            }
            ((TrueTypeFile)object).bY = n3;
            ((TrueTypeFile)object).bW = new byte[n3 + 3 & 0xFFFFFFFC];
            n5 = 0;
            n4 = 0;
            DefaultTable defaultTable = (DefaultTable)((TrueTypeFile)object).tableCollection.get("glyf");
            n2 = 0;
            while (n2 < ((TrueTypeFile)object).bV.length) {
                ((TrueTypeFile)object).bV[n2] = n5;
                if (n4 < nArray.length && nArray[n4] == n2) {
                    ++n4;
                    ((TrueTypeFile)object).bV[n2] = n5;
                    long l = ((TrueTypeFile)object).offsets[n2];
                    n = (int)(((TrueTypeFile)object).offsets[n2 + 1] - l);
                    if (n > 0) {
                        try {
                            ((TrueTypeFile)object).fr.seek(defaultTable.offset + l);
                            ((TrueTypeFile)object).fr.readFully(((TrueTypeFile)object).bW, n5, n);
                            n5 += n;
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = iOException;
                            iOException.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
            n2 = ((TrueTypeFile)object).bK.indexToLocFormat == 0 ? ((TrueTypeFile)object).bV.length << 1 : ((TrueTypeFile)object).bV.length << 2;
            ((TrueTypeFile)object).bX = new byte[n2 + 3 & 0xFFFFFFFC];
            ((TrueTypeFile)object).bZ = n2;
            int n7 = 0;
            int n8 = 0;
            while (n8 < ((TrueTypeFile)object).bV.length) {
                if (((TrueTypeFile)object).bK.indexToLocFormat == 0) {
                    TrueTypeFile.a(((TrueTypeFile)object).bX, n7, ((TrueTypeFile)object).bV[n8] / 2);
                    n7 += 2;
                } else {
                    TrueTypeFile.a(((TrueTypeFile)object).bX, n7, (long)((TrueTypeFile)object).bV[n8]);
                    n7 += 4;
                }
                ++n8;
            }
        }
        int n9 = 0;
        n = 0;
        while (n < bD.length) {
            if (bD[n] != "glyf" && bD[n] != "loca") {
                DefaultTable defaultTable = (DefaultTable)this.tableCollection.get(bD[n]);
                n9 += defaultTable.length + 3 & 0xFFFFFFFC;
            }
            ++n;
        }
        n9 += this.bX.length;
        n9 += this.bW.length;
        byte[] byArray = new byte[n9 += 12 + 16 * bD.length];
        n2 = 0;
        TrueTypeFile.a(byArray, 0, 65536L);
        n2 += 4;
        TrueTypeFile.a(byArray, 4, bD.length);
        n2 += 2;
        n = bE[bD.length];
        TrueTypeFile.a(byArray, 6, 1 << n << 4);
        n2 += 2;
        TrueTypeFile.a(byArray, 8, n);
        n2 += 2;
        TrueTypeFile.a(byArray, 10, bD.length - (1 << n) << 4);
        n2 += 2;
        int n10 = 12 + 16 * bD.length;
        n = 0;
        while (n < bD.length) {
            Object object2 = object = bD[n];
            int n11 = n2;
            object = byArray;
            try {
                byte[] byArray2 = ((String)object2).getBytes("ISO-8859-1");
                System.arraycopy(byArray2, 0, object, n11, byArray2.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
            }
            n2 += 4;
            object = (DefaultTable)this.tableCollection.get(bD[n]);
            if (bD[n] == "glyf") {
                TrueTypeFile.a(byArray, n2, (long)this.calculateChecksum(this.bW));
                ((DefaultTable)object).length = this.bY;
            } else if (bD[n] == "loca") {
                TrueTypeFile.a(byArray, n2, (long)this.calculateChecksum(this.bX));
                ((DefaultTable)object).length = this.bZ;
            } else {
                TrueTypeFile.a(byArray, n2, ((DefaultTable)object).checkSum);
            }
            TrueTypeFile.a(byArray, n2 += 4, (long)n10);
            n11 = ((DefaultTable)object).length + 3 & 0xFFFFFFFC;
            TrueTypeFile.a(byArray, n2 += 4, (long)((DefaultTable)object).length);
            n2 += 4;
            n10 += n11;
            ++n;
        }
        n = 0;
        while (n < bD.length) {
            object = (DefaultTable)this.tableCollection.get(bD[n]);
            if (bD[n] == "glyf") {
                System.arraycopy(this.bW, 0, byArray, n2, this.bW.length);
                n2 += this.bW.length;
            } else if (bD[n] == "loca") {
                System.arraycopy(this.bX, 0, byArray, n2, this.bX.length);
                n2 += this.bX.length;
            } else {
                try {
                    this.fr.seek(((DefaultTable)object).offset);
                    this.fr.readFully(byArray, n2, ((DefaultTable)object).length);
                    n2 += ((DefaultTable)object).length + 3 & 0xFFFFFFFC;
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                }
            }
            ++n;
        }
        return byArray;
    }

    public void getUsedGlyphIndexs() {
        if (this.bU != null) {
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < this.bU.size()) {
                Integer n2 = (Integer)this.bU.elementAt(n);
                vector.add(this.be.get(n2));
                ++n;
            }
            if (vector.size() > 0 && !vector.contains(new Integer(0))) {
                vector.add(new Integer(0));
            }
            this.ca = new int[vector.size()];
            n = 0;
            while (n < vector.size()) {
                this.ca[n] = (Integer)vector.elementAt(n);
                ++n;
            }
            Arrays.sort(this.ca);
            this.cb = new int[this.ca.length];
            this.cc = new Hashtable();
            n = 0;
            while (n < this.ca.length) {
                this.cb[n] = this.bO.changeTTF2PdfUnit(this.bO.advanceWidths[this.ca[n]], this.bG.unitsPerEm);
                this.cc.put(new Integer(this.ca[n]), new Integer(this.cb[n]));
                ++n;
            }
        }
    }

    public String getUsedCmaps() {
        if (this.bU.size() == 0) {
            return null;
        }
        int n = (Integer)this.be.get(new Integer(this.firstChar));
        int n2 = (Integer)this.be.get(new Integer(this.lastChar));
        StringBuffer stringBuffer = new StringBuffer("/CIDInit /ProcSet findresource begin\n");
        stringBuffer.append("12 dict begin\n");
        stringBuffer.append("begincmap\n");
        stringBuffer.append("/CIDSystemInfo\n");
        stringBuffer.append("<< /Registry (Adobe)\n");
        stringBuffer.append("/Ordering (UCS)\n");
        stringBuffer.append("/Supplement 0\n");
        stringBuffer.append(">> def\n");
        stringBuffer.append("/CMapName /Adobe-Identity-UCS def\n");
        stringBuffer.append("/CMapType 2 def\n");
        stringBuffer.append("1 begincodespacerange\n");
        stringBuffer.append(TrueTypeFile.toHex(n));
        stringBuffer.append(TrueTypeFile.toHex(n2));
        stringBuffer.append("\nendcodespacerange\n");
        stringBuffer.append(this.bU.size());
        stringBuffer.append(" beginbfrange\n");
        int n3 = 0;
        while (n3 < this.bU.size()) {
            Integer n4 = (Integer)this.bU.elementAt(n3);
            n = n4;
            n2 = (Integer)this.be.get(n4);
            stringBuffer.append(TrueTypeFile.toHex(n));
            stringBuffer.append(" ");
            stringBuffer.append(TrueTypeFile.toHex(n));
            stringBuffer.append(" ");
            stringBuffer.append(n2);
            stringBuffer.append("\n");
            ++n3;
        }
        stringBuffer.append("endbfrange\n");
        stringBuffer.append("endcmap\n");
        stringBuffer.append("CMapName currentdict /CMap defineresource pop\n");
        stringBuffer.append("end end\n");
        return stringBuffer.toString();
    }

    public CmapTable getMCmapTable() {
        return this.bL;
    }

    public FontDirectory getMFontDirectory() {
        return this.bF;
    }

    public HeadTable getMHeadTable() {
        return this.bG;
    }

    public HheaTable getMHheaTable() {
        return this.bI;
    }

    public LocaTable getMLocaTable() {
        return this.bK;
    }

    public MaxpTable getMMaxpTable() {
        return this.bH;
    }

    public NameTable getMNameTable() {
        return this.bJ;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getCapHeight() {
        return this.bP;
    }

    public Hashtable getCmaps() {
        return this.be;
    }

    public String getCopyRightNotice() {
        return this.copyRightNotice;
    }

    public int getDscent() {
        return this.bQ;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getFontBox() {
        return this.bR;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Hashtable getGlyphData() {
        return this.bS;
    }

    public int[] getGlyphWidths() {
        return this.bT;
    }

    public float getItalicAngle() {
        return this.ItalicAngle;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public HtmxTable getMHtmxTable() {
        return this.bO;
    }

    public OS2Table getMOS2Table() {
        return this.bM;
    }

    public PostTable getMPostTable() {
        return this.bN;
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public int getStemV() {
        return 0;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public Vector getUsedChars() {
        return this.bU;
    }

    public void setMCmapTable(CmapTable cmapTable) {
        this.bL = cmapTable;
    }

    public void setMFontDirectory(FontDirectory fontDirectory) {
        this.bF = fontDirectory;
    }

    public void setMHeadTable(HeadTable headTable) {
        this.bG = headTable;
    }

    public void setMHheaTable(HheaTable hheaTable) {
        this.bI = hheaTable;
    }

    public void setMLocaTable(LocaTable locaTable) {
        this.bK = locaTable;
    }

    public void setMMaxpTable(MaxpTable maxpTable) {
        this.bH = maxpTable;
    }

    public void setMNameTable(NameTable nameTable) {
        this.bJ = nameTable;
    }

    protected int calculateChecksum(byte[] byArray) {
        int n = byArray.length / 4;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            n5 += byArray[n6++] & 0xFF;
            n4 += byArray[n6++] & 0xFF;
            n3 += byArray[n6++] & 0xFF;
            n2 += byArray[n6++] & 0xFF;
            ++n7;
        }
        return n2 + (n3 << 8) + (n4 << 16) + (n5 << 24);
    }

    public static void main(String[] object) {
        try {
            object = new TrueTypeFontFileReader("d:\\HGRPP1.TTC", "r");
            TrueTypeFile trueTypeFile = new TrueTypeFile();
            new TrueTypeFile().fr = object;
            trueTypeFile.LoadFontData();
            trueTypeFile.resetUsedChars("\u65e5");
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    public Hashtable getUsedGI_GW() {
        return this.cc;
    }

    public int[] getUsedGIInt() {
        return this.ca;
    }

    public int[] getUsedGWidths() {
        return this.cb;
    }
}

