/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.util.ArrayList;
import java.util.Collection;
import option.gad.core.util.EnumWithId;
import option.gad.core.util.EnumWithName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumUtil {
    protected EnumUtil() {
    }

    public static final boolean matchOR(Enum<?> enum_, Enum<?> ... object) {
        if (enum_ == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (((Enum<?>[])object).length == 0) {
            return false;
        }
        Enum<?>[] enumArray = object;
        int n = ((Enum<?>[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = enumArray[n2];
            if (object == enum_) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean matchAND(Enum<?> enum_, Enum<?> ... object) {
        if (enum_ == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (((Enum<?>[])object).length == 0) {
            return false;
        }
        boolean bl = true;
        Enum<?>[] enumArray = object;
        int n = ((Enum<?>[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = enumArray[n2];
            bl &= object == enum_;
            ++n2;
        }
        return bl;
    }

    public static <T extends Enum<?>> T prev(T t) {
        int n = ((Enum[])t.getClass().getEnumConstants()).length;
        int n2 = t.ordinal();
        n = n2 == 0 ? n - 1 : n2 - 1;
        return (T)((Enum[])t.getClass().getEnumConstants())[n];
    }

    public static <T extends Enum<?>> T next(T t) {
        int n = ((Enum[])t.getClass().getEnumConstants()).length;
        int n2 = t.ordinal();
        n = n2 == n - 1 ? 0 : n2 + 1;
        return (T)((Enum[])t.getClass().getEnumConstants())[n];
    }

    public static <T extends Enum<?>> T getById(Class<T> object, Integer n) {
        Object object2 = null;
        Enum[] enumArray = (Enum[])((Class)object).getEnumConstants();
        int n2 = enumArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = enumArray[n3];
            if (((EnumWithId)object).getId().equals(n)) {
                object2 = object;
                break;
            }
            ++n3;
        }
        return (T)object2;
    }

    public static <T extends Enum<?>> T getByName(Class<T> object, String string) {
        Object object2 = null;
        Enum[] enumArray = (Enum[])((Class)object).getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = enumArray[n2];
            if (((EnumWithName)object).getName().equals(string)) {
                object2 = object;
                break;
            }
            ++n2;
        }
        return (T)object2;
    }

    public static <T extends Enum<?>> Integer getId(T t) {
        return EnumUtil.getId(t, null);
    }

    public static <T extends Enum<?>> Integer getId(T t, Integer n) {
        if (t == null) {
            return n;
        }
        return ((EnumWithId)((Object)t)).getId();
    }

    public static <T extends Enum<?>> Collection<Integer> getIds(Class<T> object) {
        object = (Enum[])object.getEnumConstants();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Enum[] enumArray = object;
        int n = ((Enum[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = enumArray[n2];
            arrayList.add(((EnumWithId)object).getId());
            ++n2;
        }
        return arrayList;
    }

    public static <T extends Enum<?>> String getName(T t) {
        return EnumUtil.getName(t, null);
    }

    public static <T extends Enum<?>> String getName(T t, String string) {
        if (t == null) {
            return string;
        }
        return ((EnumWithName)((Object)t)).getName();
    }

    public static <T extends Enum<?>> Collection<String> getNames(Class<T> object) {
        object = (Enum[])object.getEnumConstants();
        ArrayList<String> arrayList = new ArrayList<String>();
        Enum[] enumArray = object;
        int n = ((Enum[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = enumArray[n2];
            arrayList.add(((EnumWithName)object).getName());
            ++n2;
        }
        return arrayList;
    }

    public static <T extends Enum<?>> Integer[] getIdArray(Class<T> enumArray) {
        enumArray = (Enum[])enumArray.getEnumConstants();
        Integer[] integerArray = new Integer[enumArray.length];
        int n = 0;
        while (n < enumArray.length) {
            integerArray[n] = ((EnumWithId)((Object)enumArray[n])).getId();
            ++n;
        }
        return integerArray;
    }

    public static <T extends Enum<?>> String[] getNameArray(Class<T> enumArray) {
        enumArray = (Enum[])enumArray.getEnumConstants();
        String[] stringArray = new String[enumArray.length];
        int n = 0;
        while (n < enumArray.length) {
            stringArray[n] = ((EnumWithName)((Object)enumArray[n])).getName();
            ++n;
        }
        return stringArray;
    }
}

