/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Vector;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.CmapStream;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Encoding;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class PdfFont
extends PdfIndirectObject
implements DefinedName {
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    public static final int DEFAULT_CID_WIDTH = 600;
    protected PdfDictionary dict = new PdfDictionary();
    private FontDescriptor bv = null;
    private Encoding bw = new Encoding("MS932");
    private Vector bx = new Vector();
    private float by = 12.0f;
    CmapStream bz = null;
    EmbedFontFile bA = null;
    private Font bB;
    private FontMetrics bC;

    public PdfFont() {
        this.dict.put(TYPE, FONT);
    }

    public void setSubtype(PdfName pdfName) {
        this.dict.put(SUBTYPE, pdfName);
    }

    public void setName(PdfName pdfName) {
        this.dict.put(FONTNAME, pdfName);
    }

    public void setBaseFont(PdfName pdfName) {
        this.dict.put(BASEFONT, pdfName);
    }

    public void setFontBBox(PdfRect pdfRect) {
        this.dict.put(FONTBBOX, pdfRect);
    }

    public void setFontMatrix(PdfArray pdfArray) {
        this.dict.put(FONTMATRIX, pdfArray);
    }

    public void setEncoding(Encoding encoding) {
        this.bw = encoding;
        if (this.bw == null) {
            this.bw = new Encoding("MS932");
        }
        switch (encoding.getEncoingDataType()) {
            case 1: {
                this.dict.put(ENCODING, encoding.getEncodingPdfName());
                return;
            }
            case 2: {
                this.dict.put(ENCODING, encoding.getEncodingDict());
                this.dict.put(CHARPROCS, encoding.getCharProcs());
                this.setWidths(encoding.getWidths());
                return;
            }
        }
        this.dict.put(ENCODING, encoding.getEncodingPdfName());
    }

    public void setFirstChar(int n) {
        this.dict.put(FIRSTCHAR, new Integer(n));
    }

    public void setLastChar(int n) {
        this.dict.put(LASTCHAR, new Integer(n));
    }

    public void setWidths(PdfArray pdfArray) {
        this.dict.put(WIDTHS, pdfArray);
    }

    public void setFontDescriptor(FontDescriptor fontDescriptor) {
        this.bv = fontDescriptor;
    }

    public void setSize(float f) {
        this.by = f;
    }

    public void setDescendantFont(CIDFont cIDFont) {
        this.bx.addElement(cIDFont);
    }

    public PdfName getSubtype() {
        return (PdfName)this.dict.get(SUBTYPE);
    }

    public PdfName getName() {
        return (PdfName)this.dict.get(FONTNAME);
    }

    public PdfName getBaseFont() {
        return (PdfName)this.dict.get(BASEFONT);
    }

    public int getFirstChar() {
        return (Integer)this.dict.get(FIRSTCHAR);
    }

    public int getLastChar() {
        return (Integer)this.dict.get(LASTCHAR);
    }

    public PdfArray getWidths() {
        return (PdfArray)this.dict.get(WIDTHS);
    }

    public FontDescriptor getFontDescriptor() {
        return this.bv;
    }

    public PdfName getEncodingName() {
        return (PdfName)this.dict.get(ENCODING);
    }

    public Encoding getEncoding() {
        return this.bw;
    }

    public float getSize() {
        return this.by;
    }

    public Vector getDescendantFonts() {
        return this.bx;
    }

    public void setCmapStream(CmapStream cmapStream) {
        this.bz = cmapStream;
    }

    public CmapStream getCmapStream() {
        return this.bz;
    }

    public void setEmbedFontFile(EmbedFontFile embedFontFile) {
        this.bA = embedFontFile;
    }

    public EmbedFontFile getEmbedFontFile() {
        return this.bA;
    }

    public final String toString() {
        if (this.bv != null) {
            this.dict.put(FONTDESCRIPTOR, this.bv.getReference());
        }
        if (this.c()) {
            this.dict.put(DESCENDANTFONTS, this.d());
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (PdfFont)object;
        return this.getName().equals(((PdfFont)object).getName());
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public int stringWidth(String object) {
        object = ((String)object).toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            n += this.charWidth((char)object[n2]);
            ++n2;
        }
        return n;
    }

    public int charWidth(char c) {
        PdfFont pdfFont = this;
        String string = pdfFont.getBaseFont().getName();
        if (pdfFont.bB == null || !pdfFont.bB.getName().equals(string)) {
            pdfFont.bB = new Font(string, 0, 1000);
            pdfFont.bC = Toolkit.getDefaultToolkit().getFontMetrics(pdfFont.bB);
        }
        if (pdfFont.bC.charWidth(c) > 800) {
            return 1000;
        }
        return 600;
    }

    public int getAscent() {
        return 0;
    }

    public int getDescent() {
        return 0;
    }

    private boolean c() {
        return this.bx.size() > 0;
    }

    private PdfArray d() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfArray pdfArray = new PdfArray();
        int n = this.bx.size();
        int n2 = 0;
        while (n2 < n) {
            String string = ((CIDFont)this.bx.elementAt(n2)).getReference();
            if (hashMap.get(string) == null) {
                hashMap.put(string, "");
                pdfArray.addElement(string);
            }
            ++n2;
        }
        return pdfArray;
    }

    public void write(PdfOutFile pdfOutFile) {
        if (this.bv != null) {
            this.dict.put(FONTDESCRIPTOR, this.bv.getReference());
            if (this.bA != null) {
                this.bv.setFontfile2(this.bA.getReference());
            }
        }
        if (this.c()) {
            this.dict.put(DESCENDANTFONTS, this.d());
        }
        if (this.bz != null) {
            this.dict.put(TOUNICODE, this.bz.getReference());
        }
        this.startObject(pdfOutFile);
        this.dict.write(pdfOutFile);
        this.endObject(pdfOutFile);
    }
}

