/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import com.kt.util.RefList;
import d.d;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import option.io.pdfcommon.PdfDataConst;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.EmbedU3DFile;
import option.io.pdfcommon.document.PdfAnnotation;
import option.io.pdfcommon.document.Resources;
import option.io.pdfcommon.font.BaseJapanNoEmbedFont;
import option.io.pdfcommon.font.FontFactory;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.font.TrueTypeFont;
import option.io.pdfcommon.object.FormXObject;
import option.io.pdfcommon.object.ImageXObject;
import option.io.pdfcommon.object.ImageXObjectJpeg;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.StreamObj;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.pattern.Shading;
import option.io.pdfcommon.pattern.ShadingType2;
import option.io.pdfcommon.pattern.TilingPattern;
import option.io.pdfcommon.util.PdfMetrices;
import option.io.pdfcommon.util.PdfRect;
import option.io.pdfcommon.util.PdfUtil;

public class Contents
extends StreamObj
implements PdfDataConst {
    public static final int STATE_NONE = 0;
    public static final int STATE_TEXT = 1;
    public static final int STATE_IMAGE = 2;
    public static final int STATE_FORM = 3;
    public static final int STATE_GRAPH = 4;
    public static final int STATE_DEFAULT = 0;
    public static final float DEFAULT_CHAR_SPACING = 0.0f;
    public static final float DEFAULT_CHAR_SCALING = 100.0f;
    private int q;
    private PdfMetrices r = new PdfMetrices(1);
    private Color s;
    private Color t;
    protected Body mBody;
    protected PdfRect mediabox;
    protected PrintStream mPrintStream;
    protected boolean isFontChanged = false;
    protected Resources resources;
    private LineStyle mLineStyle = null;
    private BaseJapanNoEmbedFont u = new BaseJapanNoEmbedFont();
    private PdfFont v;
    private float w;
    private float x;
    private float y;
    private float z;
    private float G;
    private float J;
    private int Y;
    private float Z;
    private float aa;
    private PdfUtil ab;
    private PdfRect ac;
    private Hashtable ad;

    public Contents() {
        this.v = this.u.DEFAULT_FONT;
        this.w = 1.0f;
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 1.0f;
        this.G = 0.0f;
        this.J = 0.0f;
        this.Y = 0;
        this.Z = 0.0f;
        this.aa = 100.0f;
        this.ab = new PdfUtil();
        this.ad = new Hashtable();
        this.flagStreamCompress = false;
        this.mPrintStream = this.stream.getPrintStream();
        this.v.setSize(4.233402f);
    }

    public Contents(Body body, PdfRect pdfRect) {
        this();
        this.mBody = body;
        this.resources = new Resources(body);
        this.mediabox = pdfRect;
        body.getCurrentPage();
        this.pageCoor();
    }

    protected void finalize() throws Throwable {
        if (d.d) {
            System.out.println(String.valueOf(this.getClass().toString()) + " finalized!");
        }
        super.finalize();
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("stream");
        printWriter.println(this.stream);
        printWriter.println("endstream");
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public void setFillColor(Color color) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (color != null) {
            f = (float)color.getRed() / 255.0f;
            f2 = (float)color.getGreen() / 255.0f;
            f3 = (float)color.getBlue() / 255.0f;
        }
        this.setFillColor(f, f2, f3);
    }

    public Color getFillColor() {
        return this.s;
    }

    public void setFillColor(float f, float f2, float f3) {
        Color color = new Color(f, f2, f3);
        if (this.s != null && this.s.equals(color)) {
            return;
        }
        this.s = color;
        if (f == f2 && f2 == f3) {
            this.mPrintStream.println(String.valueOf(this.ab.formatPrint(f)) + " g");
            return;
        }
        this.mPrintStream.println(String.valueOf(this.ab.formatPrint(f)) + " " + this.ab.formatPrint(f2) + " " + this.ab.formatPrint(f3) + " rg");
    }

    public void setStrokeColor(Color color) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (color != null) {
            f = (float)color.getRed() / 255.0f;
            f2 = (float)color.getGreen() / 255.0f;
            f3 = (float)color.getBlue() / 255.0f;
        }
        this.setStrokeColor(f, f2, f3);
    }

    public Color getStrokeColor() {
        return this.t;
    }

    public void setStrokeColor(float f, float f2, float f3) {
        Color color = new Color(f, f2, f3);
        if (this.t != null && this.t.equals(color)) {
            return;
        }
        this.t = color;
        if (f == f2 && f2 == f3) {
            this.mPrintStream.println(String.valueOf(this.ab.formatPrint(f)) + " G");
            return;
        }
        this.mPrintStream.println(String.valueOf(this.ab.formatPrint(f)) + " " + this.ab.formatPrint(f2) + " " + this.ab.formatPrint(f3) + " RG");
    }

    public void setFillGray(float f) {
        if ((double)f >= 0.0 && (double)f <= 1.0) {
            this.setFillColor(f, f, f);
        }
    }

    public void setStrokeGray(float f) {
        if ((double)f >= 0.0 && (double)f <= 1.0) {
            this.setStrokeColor(f, f, f);
        }
    }

    public void setLStyle(LineStyle lineStyle) {
        this.mLineStyle = lineStyle != null ? lineStyle : new LineStyle();
        this.mPrintStream.println(this.mLineStyle.toString());
    }

    public void setLineWidth(float f) {
        this.mPrintStream.println(String.valueOf(f) + " w");
    }

    private void a(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.w != f || this.x != f2 || this.y != f3 || this.z != f4 || this.G != f5 || this.J != f6) {
            float f7 = 1.0f / (this.w * this.z - this.x * this.y);
            float f8 = this.z * f7;
            float f9 = -this.x * f7;
            float f10 = -this.y * f7;
            float f11 = this.w * f7;
            float f12 = (this.y * this.J - this.z * this.G) * f7;
            f7 = (this.x * this.G - this.w * this.J) * f7;
            this.b(f8, f9, f10, f11, f12, f7);
            this.w = f;
            this.x = f2;
            this.y = f3;
            this.z = f4;
            this.G = f5;
            this.J = f6;
            this.b(f, f2, f3, f4, f5, f6);
        }
    }

    private void b(float f, float f2, float f3, float f4, float f5, float f6) {
        if (f == 1.0f && Math.abs(f2) == 0.0f && Math.abs(f3) == 0.0f && f4 == 1.0f && Math.abs(f5) == 0.0f && Math.abs(f6) == 0.0f) {
            return;
        }
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f2, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f3, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f4, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f5, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f6, 4)) + " ");
        this.mPrintStream.println("cm");
    }

    public void translate(float f, float f2) {
        this.a(1.0f, 0.0f, 0.0f, 1.0f, f, f2);
    }

    public void scale(float f, float f2) {
        this.a(0.0f, 0.0f, 0.0f, 0.0f, f, f2);
    }

    public void rotate(float f) {
        double d2 = (double)f * Math.PI / 180.0;
        this.a((float)Math.cos(d2), (float)Math.sin(d2), -((float)Math.sin(d2)), (float)Math.cos(d2), 0.0f, 0.0f);
    }

    public void pageCoor() {
        this.b(2.8346f, 0.0f, 0.0f, 2.8346f, 0.0f, 0.0f);
    }

    public void setDefaultCoor() {
        this.a(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public void setFont(PdfFont pdfFont) {
        if (this.v != (pdfFont = this.mBody.addFont(pdfFont))) {
            this.isFontChanged = true;
            this.v = pdfFont;
        }
        this.resources.addFont(pdfFont);
    }

    public PdfFont getFont() {
        return this.v;
    }

    public void setFontSize(float f) {
        if (this.v != null && this.v.getSize() != f) {
            this.isFontChanged = true;
            this.v.setSize(f);
        }
    }

    public int getState() {
        return this.q;
    }

    public void saveState(int n) {
        Contents contents;
        if (n == this.q) {
            return;
        }
        this.a();
        if (this.ac != null) {
            this.b();
            contents = this;
            if (contents.ac != null) {
                contents.beginPath(contents.ac.getLux(), contents.ac.getLuy());
                contents.linePath(contents.ac.getRdx(), contents.ac.getLuy());
                contents.linePath(contents.ac.getRdx(), contents.ac.getRdy());
                contents.linePath(contents.ac.getLux(), contents.ac.getRdy());
                contents.clipPath();
            }
        }
        switch (n) {
            case 1: {
                contents = this;
                contents.resources.useText();
                contents.mPrintStream.println("BT");
                contents.isFontChanged = true;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.ac != null) break;
                this.b();
            }
        }
        this.q = n;
    }

    private void a() {
        switch (this.q) {
            case 1: {
                Contents contents = this;
                contents.mPrintStream.println("ET");
                contents.mPrintStream.println();
                contents.Y = 0;
                contents.aa = 100.0f;
                contents.Z = 0.0f;
                if (this.ac == null) break;
            }
            case 2: 
            case 3: 
            case 4: {
                Contents contents = this;
                contents.mPrintStream.println("Q");
                contents.mPrintStream.println();
                contents.s = null;
                contents.t = null;
                contents.mLineStyle = null;
                v0.w = 1.0f;
                contents.x = 0.0f;
                contents.y = 0.0f;
                contents.z = 1.0f;
                contents.G = 0.0f;
                contents.J = 0.0f;
            }
        }
        this.t = null;
        this.s = null;
        this.q = 0;
    }

    public void endContents() {
        this.a();
        Contents contents = this;
        if (d.d) {
            System.out.println("close called!");
        }
        Enumeration enumeration = contents.ad.elements();
        TrueTypeFont trueTypeFont = null;
        try {
            while (enumeration.hasMoreElements()) {
                trueTypeFont = (TrueTypeFont)enumeration.nextElement();
                trueTypeFont.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("**** FontFile=" + trueTypeFont.fontFileName);
            iOException.printStackTrace();
        }
        contents.ad.clear();
    }

    private void b() {
        this.mPrintStream.println("q");
    }

    public void closePath() {
        this.mPrintStream.println("h");
    }

    public void strokePath() {
        this.mPrintStream.println("S");
    }

    public void closeAndStrokePath() {
        this.mPrintStream.println("s");
    }

    public void fillAndStorokePath(boolean bl) {
        this.mPrintStream.println("b" + (bl ? "" : "*"));
    }

    public void fillPath() {
        this.fillPath(true);
    }

    public void fillPath(boolean bl) {
        this.mPrintStream.println("f" + (bl ? "" : "*"));
    }

    public Resources getResources() {
        return this.resources;
    }

    private void a(FormXObject formXObject, float f, float f2, float f3, float f4) {
        this.mBody.add(formXObject);
        this.resources.addXObject(formXObject);
        this.saveState(3);
        f3 = f3 < f4 ? (f3 /= formXObject.getWidth()) : (f4 /= formXObject.getHeight());
        formXObject.getMTransMatrices().setTranslation(f, f2);
        formXObject.getMTransMatrices().setScale(f3, f3);
        this.mPrintStream.println(formXObject.getMTransMatrices().toString());
        this.mPrintStream.println(formXObject.getName() + " Do");
        this.a();
    }

    public void beginPath(float f, float f2) {
        this.mPrintStream.print(this.ab.formatPrint(f));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.ab.formatPrint(f2));
        this.mPrintStream.println(" m");
    }

    public void linePath(float f, float f2) {
        this.mPrintStream.print(this.ab.formatPrint(f));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.ab.formatPrint(f2));
        this.mPrintStream.println(" l");
    }

    private void a(float f, float f2, float f3, float f4) {
        this.mPrintStream.print(this.ab.formatPrint(f));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.ab.formatPrint(f2));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.ab.formatPrint(f3));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.ab.formatPrint(f4));
        this.mPrintStream.println(" re");
    }

    private void b(float f, float f2, float f3, float f4) {
        this.translate(f, f2);
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        double d2 = Math.cos(1.0471975511965976);
        double d3 = Math.sin(1.0471975511965976);
        dArray[2] = 1.0;
        dArray[1] = 1.0;
        dArray2[1] = 0.0;
        dArray[4] = d2;
        dArray2[4] = d3;
        dArray[3] = (8.0 * Math.cos(0.5235987755982988) - (dArray[1] + 3.0 * dArray[2] + dArray[4])) / 3.0;
        dArray2[3] = dArray2[4] - (-dArray[3] + dArray[4]) / -Math.tan(1.0471975511965976);
        dArray2[2] = (8.0 * Math.sin(0.5235987755982988) - (dArray2[1] + 3.0 * dArray2[3] + dArray2[4])) / 3.0;
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        this.beginPath((float)((double)f3 * dArray[1]), (float)(dArray2[1] * (double)f4));
        int n = 0;
        while (n < 6) {
            this.cubicBezierPath((float)((double)f3 * dArray[2]), (float)(dArray2[2] * (double)f4), (float)((double)f3 * dArray[3]), (float)(dArray2[3] * (double)f4), (float)((double)f3 * dArray[4]), (float)(dArray2[4] * (double)f4));
            int n2 = 2;
            while (n2 <= 4) {
                dArray3[n2] = dArray[n2] * d2 - dArray2[n2] * d3;
                dArray4[n2] = dArray[n2] * d3 + dArray2[n2] * d2;
                dArray[n2] = dArray3[n2];
                dArray2[n2] = dArray4[n2];
                ++n2;
            }
            ++n;
        }
        this.closePath();
    }

    private void a(float f, float f2, float f3) {
        this.translate(f, f2);
        double d2 = Math.cos(1.0471975511965976);
        double d3 = Math.sin(1.0471975511965976);
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        dArray[2] = 1.0;
        dArray[1] = 1.0;
        dArray2[1] = 0.0;
        dArray[4] = d2;
        dArray2[4] = d3;
        dArray[3] = (8.0 * Math.cos(0.5235987755982988) - (dArray[1] + 3.0 * dArray[2] + dArray[4])) / 3.0;
        dArray2[3] = dArray2[4] - (-dArray[3] + dArray[4]) / -Math.tan(1.0471975511965976);
        dArray2[2] = (8.0 * Math.sin(0.5235987755982988) - (dArray2[1] + 3.0 * dArray2[3] + dArray2[4])) / 3.0;
        this.beginPath((float)((double)f3 * dArray[1]), (float)(dArray2[1] * (double)f3));
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        int n = 0;
        while (n < 6) {
            this.cubicBezierPath((float)((double)f3 * dArray[2]), (float)(dArray2[2] * (double)f3), (float)((double)f3 * dArray[3]), (float)(dArray2[3] * (double)f3), (float)((double)f3 * dArray[4]), (float)(dArray2[4] * (double)f3));
            int n2 = 2;
            while (n2 <= 4) {
                dArray3[n2] = dArray[n2] * d2 - dArray2[n2] * d3;
                dArray4[n2] = dArray[n2] * d3 + dArray2[n2] * d2;
                dArray[n2] = dArray3[n2];
                dArray2[n2] = dArray4[n2];
                ++n2;
            }
            ++n;
        }
        this.closePath();
    }

    private void a(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        if (f6 <= 0.0f) {
            return;
        }
        this.translate(f, f2);
        f = f3 * 2.0f;
        f2 = f4 * 2.0f;
        double d2 = (double)f6 * Math.PI / 180.0;
        double d3 = d2 / 6.0;
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        dArray[2] = 1.0;
        dArray[1] = 1.0;
        dArray2[1] = 0.0;
        dArray[4] = d4;
        dArray2[4] = d5;
        dArray[3] = (8.0 * Math.cos(d3 / 2.0) - (dArray[1] + 3.0 * dArray[2] + dArray[4])) / 3.0;
        dArray2[3] = dArray2[4] - (-dArray[3] + dArray[4]) / -Math.tan(d3);
        dArray2[2] = (8.0 * Math.sin(d3 / 2.0) - (dArray2[1] + 3.0 * dArray2[3] + dArray2[4])) / 3.0;
        double d6 = (double)f5 * Math.PI / 180.0;
        double d7 = Math.cos(d6);
        double d8 = Math.sin(d6);
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        int n = 1;
        while (n <= 4) {
            dArray3[n] = dArray[n] * d7 - dArray2[n] * d8;
            dArray4[n] = dArray[n] * d8 + dArray2[n] * d7;
            dArray[n] = dArray3[n];
            dArray2[n] = dArray4[n];
            ++n;
        }
        float f7 = f2 / f;
        if (Float.isNaN(f7)) {
            f7 = 1.0f;
        }
        if (bl) {
            this.beginPath(0.0f, 0.0f);
            this.linePath((float)((double)f3 * dArray[1]), (float)((double)f3 * dArray2[1]) * f7);
        } else {
            this.beginPath((float)((double)f3 * dArray[1]), (float)((double)f3 * dArray2[1]) * f7);
        }
        int n2 = 0;
        while (n2 < 6) {
            this.cubicBezierPath((float)((double)f3 * dArray[2]), (float)((double)f3 * dArray2[2]) * f7, (float)((double)f3 * dArray[3]), (float)((double)f3 * dArray2[3]) * f7, (float)((double)f3 * dArray[4]), (float)((double)f3 * dArray2[4]) * f7);
            int n3 = 2;
            while (n3 <= 4) {
                dArray3[n3] = dArray[n3] * d4 - dArray2[n3] * d5;
                dArray4[n3] = dArray[n3] * d5 + dArray2[n3] * d4;
                dArray[n3] = dArray3[n3];
                dArray2[n3] = dArray4[n3];
                ++n3;
            }
            ++n2;
        }
        if (bl) {
            this.closePath();
        }
    }

    private void a(float[] fArray) {
        if (fArray.length < 2 || fArray.length % 2 != 0) {
            return;
        }
        this.beginPath(fArray[0], fArray[1]);
        int n = 2;
        while (n < fArray.length) {
            this.linePath(fArray[n], fArray[n + 1]);
            n += 2;
        }
    }

    private void a(RefList refList) {
        if (refList.size() < 2) {
            return;
        }
        Object object = refList.elementAt(0);
        if (object instanceof Point) {
            Point point = (Point)object;
            this.beginPath(point.x, point.y);
        }
        int n = 1;
        while (n < refList.size()) {
            object = refList.elementAt(n);
            if (object instanceof Point) {
                object = (Point)object;
                this.linePath(((Point)object).x, ((Point)object).y);
            }
            ++n;
        }
    }

    private void a(Polygon polygon) {
        this.beginPath(polygon.xpoints[0], polygon.ypoints[0]);
        int n = 1;
        while (n < polygon.npoints) {
            this.linePath(polygon.xpoints[n], polygon.ypoints[n]);
            ++n;
        }
    }

    public void cubicBezierPath(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f2)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f3)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f4)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f5)) + " ");
        this.mPrintStream.print(String.valueOf(this.ab.formatPrint(f6)) + " ");
        this.mPrintStream.println("c");
    }

    public int[] color2RGB(Color color) {
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = color.getRed();
        nArray2[1] = color.getGreen();
        nArray2[2] = color.getBlue();
        return nArray2;
    }

    public LineStyle getLStyle() {
        return this.mLineStyle;
    }

    public boolean isFlagCompress() {
        return this.flagStreamCompress;
    }

    public void setFlagCompress(boolean bl) {
        this.flagStreamCompress = bl;
    }

    public PdfRect getMediabox() {
        return this.mediabox;
    }

    public void writeLine(float f, float f2, float f3, float f4, Object object, Color color) {
        this.setDefaultCoor();
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.beginPath(f, f2);
        this.linePath(f3, f4);
        this.strokePath();
    }

    public void writeRectangle(float f, float f2, float f3, float f4, Object object, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.q == 4) {
                if (this.s == null || !this.s.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.a(f, f2, f3, f4);
            this.fillPath();
            return;
        }
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.a(f, f2, f3, f4);
        this.strokePath();
    }

    public void writeArc(float f, float f2, float f3, float f4, float f5, float f6, Object object, Color color, boolean bl) {
        if (bl) {
            if (this.q == 4) {
                if (this.s == null || !this.s.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.a(f, f2, f3, f4, f5, f6, bl);
            this.closePath();
            this.fillPath();
            return;
        }
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.a(f, f2, f3, f4, f5, f6, bl);
        this.strokePath();
    }

    public void writeEllipse(float f, float f2, float f3, float f4, Object object, Color color, boolean bl) {
        if (bl) {
            if (this.q == 4) {
                if (this.s == null || !this.s.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.b(f, f2, f3, f4);
            this.closePath();
            this.fillPath();
            return;
        }
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.b(f, f2, f3, f4);
        this.strokePath();
    }

    public void writeCircle(float f, float f2, float f3, Object object, Color color, boolean bl) {
        if (bl) {
            if (this.q == 4) {
                if (this.s == null || !this.s.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.a(f, f2, f3);
            this.closePath();
            this.fillPath();
            return;
        }
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.a(f, f2, f3);
        this.strokePath();
    }

    public void writePolygon(Polygon polygon, Object object, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.q == 4) {
                if (this.s == null || !this.s.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.a(polygon);
            this.closePath();
            this.fillPath();
            return;
        }
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.a(polygon);
        this.closeAndStrokePath();
    }

    public void writePolygon(RefList refList, Object object, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.q == 4) {
                if (this.s == null || !this.s.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.a(refList);
            this.closePath();
            this.fillPath();
            return;
        }
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.a(refList);
        this.closeAndStrokePath();
    }

    public void writePolygon(float[] fArray, Object object, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.q == 4) {
                if (this.s == null || !this.s.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.a(fArray);
            this.closePath();
            this.fillPath();
            return;
        }
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.a(fArray);
        this.closeAndStrokePath();
    }

    public void writePolyLine(RefList refList, Object object, Color color) {
        this.setDefaultCoor();
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.a(refList);
        this.strokePath();
    }

    public void writePolyLine(float[] fArray, Object object, Color color) {
        this.setDefaultCoor();
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.a(fArray);
        this.strokePath();
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl) {
        this.writeText(string, f, f2, string2, f3, color, bl, 0, 0.0f, 0.0f);
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n) {
        this.writeText(string, f, f2, string2, f3, color, bl, n, 0.0f);
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n, float f4) {
        this.writeText(string, f, f2, string2, f3, color, bl, n, f4, 0.0f);
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n, float f4, float f5) {
        this.writeText(string, f, f2, string2, f3, color, bl, n, f4, f5, 0.0f, null);
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n, float f4, float f5, float f6, String string3) {
        this.writeText(string, f, f2, string2, f3, color, bl, n, f4, f5, f6, string3, false);
    }

    public void writeText(String string, float f, float f2, String object, float f3, Color color, boolean bl, int n, float f4, float f5, float f6, String string2, boolean bl2) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (!bl2 || !this.a(string, (String)object)) {
            String string3 = object;
            object = this;
            PdfFont pdfFont = ((Contents)object).u.getDefinedFont(string3);
            if (pdfFont == null) {
                pdfFont = ((Contents)object).u.getBaseFont(string3);
            }
            ((Contents)object).setFont(pdfFont);
        }
        this.setFontSize(f3);
        this.saveState(1);
        object = this;
        if (((Contents)object).getFont() == null) {
            ((Contents)object).setFont(((Contents)object).u.DEFAULT_FONT);
        }
        if (((Contents)object).isFontChanged) {
            ((Contents)object).mPrintStream.println(String.valueOf(((Contents)object).v.getName().toString()) + " " + ((Contents)object).v.getSize() + " Tf");
            ((Contents)object).isFontChanged = false;
        }
        if (n == 1 || n == 2) {
            this.setStrokeColor(color);
        }
        this.setFillColor(color);
        this.r = new PdfMetrices(1);
        if (this.aa != 100.0f) {
            this.b(100.0f);
        }
        if (this.Z != 0.0f) {
            this.a(0.0f);
        }
        float f7 = f;
        float f8 = f2;
        float f9 = this.v.getSize() * (float)this.v.stringWidth(string) / 1000.0f;
        float f10 = this.v.getSize() / 3.0f;
        if (string2 != null && f6 > 0.0f) {
            if (string2.equals("scaleX")) {
                this.b(f6 * 100.0f / f9);
            } else if (string2.equals("spaceX")) {
                int n2 = string.length();
                if (n2 > 1) {
                    --n2;
                }
                this.a((f6 - f9) / (float)n2);
            }
            if (bl) {
                f7 = f - f9;
                f8 = f2 - f10;
            }
            f9 = f6 / 2.0f;
        } else {
            f9 /= 2.0f;
            if (bl) {
                f7 = f - f9;
                f8 = f2 - f10;
            }
        }
        if (f4 != 0.0f) {
            this.r.setSkew(0.0f, f4);
        }
        if (f5 != 0.0f) {
            if (bl) {
                double d2 = (double)(-f5) * Math.PI / 180.0;
                double d3 = Math.cos(d2);
                double d4 = Math.sin(d2);
                f7 = (float)((double)f - (double)f9 * d3 + d4 * (double)f10);
                f8 = (float)((double)f2 - (double)f9 * d4 - d3 * (double)f10);
            }
            this.r.setRotation(f5);
        }
        if (n != this.Y) {
            int n3 = 0;
            if (n == 2 || n == 1) {
                this.setLineWidth(f3 * 0.03f);
                n3 = n;
            }
            this.mPrintStream.println(n3 + " Tr");
            this.Y = n;
        }
        this.a(string, f7, f8);
    }

    private void a(float f) {
        this.mPrintStream.println(this.ab.formatPrint(f) + " Tc");
        this.Z = f;
    }

    private void b(float f) {
        this.mPrintStream.println(this.ab.formatPrint(f) + " Tz");
        this.aa = f;
    }

    private void a(String string, float f, float f2) {
        Object object;
        Object object2 = null;
        try {
            if (this.v instanceof TrueTypeFont) {
                object = (TrueTypeFont)this.v;
                object2 = ((TrueTypeFont)object).getMTrueTypeFile().getCmaps();
                object = new char[string.length()];
                int n = 0;
                while (n < string.length()) {
                    object[n] = (char)((Integer)object2.get(new Integer(string.charAt(n)))).intValue();
                    ++n;
                }
                String string2 = new String((char[])object, 0, string.length());
                object2 = string2.getBytes(this.v.getEncoding().getEncodingStr());
            } else {
                object2 = string.getBytes(this.v.getEncoding().getEncodingStr());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            object2 = string.getBytes();
        }
        if (object2 == null) {
            return;
        }
        this.r.setTranslation(f, f2);
        this.mPrintStream.print(this.r.toString());
        if (this.v instanceof TrueTypeFont) {
            this.mPrintStream.print("(");
            int n = 0;
            while (n < ((Object)object2).length) {
                if (object2[n] > 0) {
                    byte by = object2[n];
                    string = Integer.toOctalString(by);
                    this.mPrintStream.print(String.valueOf("\\000".substring(0, 4 - string.length())) + string);
                } else {
                    this.mPrintStream.write(object2[n]);
                }
                ++n;
            }
            this.mPrintStream.println(") Tj");
            return;
        }
        this.mPrintStream.print("<");
        int n = 0;
        while (n < ((Object)object2).length) {
            this.mPrintStream.print(Integer.toHexString(0xFF & object2[n]));
            ++n;
        }
        this.mPrintStream.println("> Tj");
    }

    private boolean a(String string, String object) {
        Object object2 = this.ad.get(object);
        if (object2 == null) {
            object2 = FontFactory.getFontFile((String)object);
            if (object2 == null) {
                return false;
            }
            object2 = ((File)object2).getAbsolutePath();
            object2 = new TrueTypeFont((String)object2);
            ((TrueTypeFont)object2).setListFontName("TTF" + this.mBody.size());
            if (((TrueTypeFont)object2).isTrueTypeCollection()) {
                ((TrueTypeFont)object2).getMTrueTypeFile().checkTTC((String)object);
            }
            ((TrueTypeFont)object2).loadFontDirectory();
            Object v = this.mBody.getFontCollection().get(((PdfFont)object2).getBaseFont());
            if (v == null) {
                this.ad.put(object, object2);
            } else {
                try {
                    ((TrueTypeFont)object2).close();
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                }
                object2 = (TrueTypeFont)v;
            }
        } else {
            object2 = (TrueTypeFont)object2;
        }
        ((TrueTypeFont)object2).resetUesedChars(string);
        ((TrueTypeFont)object2).createFont();
        this.setFont((PdfFont)object2);
        return true;
    }

    public void writeImage(ImageXObject pdfIndirectObject, float f, float f2, float f3, float f4, float f5) {
        ((ImageXObject)pdfIndirectObject).getMTransMatrices().setRotation(f5);
        f5 = f4;
        f4 = f3;
        f3 = f2;
        f2 = f;
        ImageXObject imageXObject = pdfIndirectObject;
        pdfIndirectObject = this;
        PdfName pdfName = imageXObject.getName();
        if (pdfName == null) {
            pdfName = new PdfName("Im" + String.valueOf(((Contents)pdfIndirectObject).mBody.size() + 1));
            imageXObject.setName(pdfName);
        } else {
            ((Contents)pdfIndirectObject).resources.getXObjectDictionary().containsKey(pdfName);
        }
        ((Contents)pdfIndirectObject).saveState(2);
        ((Contents)pdfIndirectObject).mBody.add(imageXObject);
        ((Contents)pdfIndirectObject).resources.addXObject(imageXObject);
        ((Contents)pdfIndirectObject).resources.useImageC();
        imageXObject.getMTransMatrices().setTranslation(f2, f3);
        imageXObject.getMTransMatrices().setScale(f4, f5);
        ((Contents)pdfIndirectObject).mPrintStream.print(imageXObject.getMTransMatrices().toString());
        ((Contents)pdfIndirectObject).mPrintStream.println(imageXObject.getName() + " Do");
        super.a();
    }

    public void writeImage(Image object, float f, float f2, float f3, float f4, float f5) {
        object = new ImageXObject((Image)object);
        this.writeImage((ImageXObject)object, f, f2, f3, f4, f5);
    }

    public void writeImage(int[] object, int n, int n2, float f, float f2, float f3, float f4, float f5) {
        object = new ImageXObject((int[])object, n, n2);
        this.writeImage((ImageXObject)object, f, f2, f3, f4, f5);
    }

    public void writeJpegImage(byte[] object, int n, int n2, float f, float f2, float f3, float f4, float f5) {
        object = new ImageXObjectJpeg((byte[])object, n, n2);
        this.writeImage((ImageXObject)object, f, f2, f3, f4, f5);
    }

    public void writeForm(FormXObject formXObject, float f, float f2, float f3, float f4) {
        this.a(formXObject, f, f2, f3, f4);
    }

    public void writeForm(FormXObject formXObject, float f, float f2, float f3, float f4, float f5) {
        formXObject.getMTransMatrices().setRotation(f5);
        this.a(formXObject, f, f2, f3, f4);
    }

    public void writeForm(FormXObject formXObject, float f, float f2, float f3, float f4, float f5, float f6, Object object, Color color) {
        formXObject.writeBorder(f6, (LineStyle)object, color);
        formXObject.getMTransMatrices().setRotation(f5);
        this.a(formXObject, f, f2, f3, f4);
    }

    public void writeLink(String object, PdfRect pdfRect) {
        pdfRect.setLux(pdfRect.getLux() * 2.8346f);
        pdfRect.setLuy(pdfRect.getLuy() * 2.8346f);
        pdfRect.setRdx(pdfRect.getRdx() * 2.8346f);
        pdfRect.setRdy(pdfRect.getRdy() * 2.8346f);
        object = new PdfAnnotation(this.mBody).createURILink(this.mBody, (String)object, pdfRect);
        this.mBody.add(object);
        this.mBody.getCurrentPage().getAnnotArray().addElement(((PdfIndirectObject)object).getReference());
    }

    public void writeLink(String object, PdfRect pdfRect, float f) {
        pdfRect.setLux(pdfRect.getLux() * 2.8346f);
        pdfRect.setLuy(pdfRect.getLuy() * 2.8346f);
        pdfRect.setRdx(pdfRect.getRdx() * 2.8346f);
        pdfRect.setRdy(pdfRect.getRdy() * 2.8346f);
        object = new PdfAnnotation(this.mBody).createLink(this.mBody, (String)object, pdfRect, f);
        this.mBody.add(object);
        this.mBody.getCurrentPage().getAnnotArray().addElement(((PdfIndirectObject)object).getReference());
    }

    public void write3D(byte[] object, PdfRect pdfRect, float f, Color color, float f2, float f3) {
        pdfRect.setLux(pdfRect.getLux() * 2.8346f);
        pdfRect.setLuy(pdfRect.getLuy() * 2.8346f);
        pdfRect.setRdx(pdfRect.getRdx() * 2.8346f);
        pdfRect.setRdy(pdfRect.getRdy() * 2.8346f);
        FormXObject formXObject = new FormXObject(this.mBody, new PdfRect(0.0f, 0.0f, pdfRect.getWidth(), pdfRect.getHeight()));
        formXObject.setFlagCompress(true);
        this.mBody.add(formXObject);
        EmbedU3DFile embedU3DFile = new EmbedU3DFile();
        embedU3DFile.setU3DData((byte[])object);
        this.mBody.add(embedU3DFile);
        object = new PdfAnnotation(this.mBody).create3D(this.mBody, embedU3DFile, pdfRect, formXObject, f, color, f2, f3);
        this.mBody.add(object);
        this.mBody.getCurrentPage().getAnnotArray().addElement(((PdfIndirectObject)object).getReference());
    }

    public void flush() {
        try {
            this.stream.flush();
            this.mPrintStream.flush();
            this.streamOut.flush();
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void close() {
        try {
            this.stream.close();
            this.mPrintStream.close();
            this.streamOut.close();
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public Pattern getPattern(String string) {
        if (TilingPattern.PATTERN_STAR.equals(string)) {
            return this.getStarPattern();
        }
        return null;
    }

    public Pattern getStarPattern() {
        return TilingPattern.getStarPattern(this.mBody);
    }

    public void addPattern(Pattern pattern) {
        this.resources.addPattern(pattern);
    }

    public void registerShading(String string) {
        Shading shading = this.getShading(string);
        if (shading == null) {
            throw new IllegalArgumentException("unknown shading [" + string + "]");
        }
        this.addShading(shading);
    }

    public Shading getShading(String string) {
        if (ShadingType2.isType2(string)) {
            return ShadingType2.getDefaultShadingType2(this.mBody, string);
        }
        return null;
    }

    public void addShading(Shading shading) {
        this.resources.addShading(shading);
    }

    public void clipPath() {
        this.mPrintStream.println("W* n");
    }

    public void shading(String string) {
        this.mPrintStream.println("/" + string + " sh");
    }

    public void writeGroupPolygon(float[][] object, Object object2, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.q == 4) {
                if (this.s == null || !this.s.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            int n = 0;
            while (n < ((float[][])object).length) {
                this.a(object[n]);
                this.closePath();
                ++n;
            }
            Contents contents = this;
            object = contents;
            contents.fillPath(false);
            return;
        }
        if (this.q == 4) {
            if (this.t == null || !this.t.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object2)) {
                this.setLStyle((LineStyle)object2);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object2);
        }
        int n = 0;
        while (n < ((float[][])object).length) {
            this.a(object[n]);
            this.closePath();
            ++n;
        }
        this.strokePath();
    }

    public void writePatternedPolygon(float[] fArray, String string) {
        this.writePatternedGroupPolygon(new float[][]{fArray}, string);
    }

    public void writePatternedGroupPolygon(float[][] fArray, String string) {
        Object object = new LineStyle();
        ((LineStyle)object).setLineWidth(0.1f);
        this.writeGroupPolygon(fArray, object, Color.white, true);
        String string2 = string;
        object = this;
        Object object2 = ((Contents)object).getPattern(string2);
        if (object2 == null) {
            throw new IllegalArgumentException("unknown pattern [" + string2 + "]");
        }
        ((Contents)object).addPattern((Pattern)object2);
        this.setDefaultCoor();
        this.a();
        this.saveState(4);
        object2 = Color.black;
        string2 = string;
        object = this;
        ((Contents)object).mPrintStream.println("/Pattern cs");
        ((Contents)object).mPrintStream.println("/" + string2 + " scn");
        ((Contents)object).setStrokeColor((Color)object2);
        ((Contents)object).mPrintStream.println(new LineStyle(0.5f));
        int n = 0;
        while (n < fArray.length) {
            this.a(fArray[n]);
            this.closePath();
            ++n;
        }
        object = this;
        ((Contents)object).mPrintStream.println("B*");
        this.a();
    }

    public void writeShadingPolygon(float[] fArray, String string) {
        this.writeShadingGroupPolygon(new float[][]{fArray}, string);
    }

    public void writeShadingGroupPolygon(float[][] fArray, String string) {
        this.setDefaultCoor();
        this.registerShading(string);
        this.saveState(4);
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.NEGATIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        int n = 0;
        while (n < fArray.length) {
            this.a(fArray[n]);
            this.closePath();
            int n2 = 0;
            while (n2 < fArray[n].length) {
                float f5 = fArray[n][n2];
                float f6 = fArray[n][n2 + 1];
                if (f5 < f) {
                    f = f5;
                }
                if (f5 > f3) {
                    f3 = f5;
                }
                if (f6 < f2) {
                    f2 = f6;
                }
                if (f6 > f4) {
                    f4 = f6;
                }
                n2 += 2;
            }
            ++n;
        }
        this.clipPath();
        this.b(f3 - f, 0.0f, 0.0f, f4 - f2, f, f2);
        this.shading(string);
        this.a();
    }

    public void setClip(float f, float f2, float f3, float f4) {
        this.releaseClip();
        this.ac = new PdfRect(f, f2, f + f3, f2 + f4);
    }

    public void releaseClip() {
        this.a();
        this.ac = null;
    }
}

