/*
 * Decompiled with CFR 0.152.
 */
package option.threed;

import java.io.Serializable;
import model.shape.primitive.SVector3d;

public class View3D
implements Serializable {
    public SVector3d o = new SVector3d();
    public SVector3d t = new SVector3d();
    public SVector3d up = new SVector3d();
    public double anglePers = 0.5235987755982988;
    public double angleTheta = -2.356194490192345;
    public double anglePhi = 0.7853981633974483;
    public int screenx;
    public int screeny;
    public SVector3d def_o = new SVector3d();
    public SVector3d def_t = new SVector3d();
    public SVector3d def_up = new SVector3d();
    public double distance;
    public double org_distance;
    public double ratio = 1.0;

    public void setDefault() {
        this.anglePers = 0.5235987755982988;
        this.angleTheta = -2.356194490192345;
        this.anglePhi = 0.7853981633974483;
        this.def_up.set(0.0, 0.0, 1.0);
        this.def_o.set(-500.0, -500.0, 500.0);
        this.def_t.set(0.0, 0.0, 0.0);
        this.setToDefaultView();
    }

    public void setToDefaultView() {
        this.o.set(this.def_o);
        this.t.set(this.def_t);
        this.up.set(this.def_up);
        this.distance = this.org_distance;
        double d = this.o.x - this.t.x;
        double d2 = this.o.y - this.t.y;
        double d3 = this.o.z - this.t.z;
        double d4 = Math.sqrt(d * d + d2 * d2);
        this.angleTheta = Math.atan2(d2, d);
        this.anglePhi = Math.atan2(d3, d4);
    }

    public void copy(View3D view3D) {
        if (view3D == null) {
            return;
        }
        this.anglePers = view3D.anglePers;
        this.angleTheta = view3D.angleTheta;
        this.anglePhi = view3D.anglePhi;
        this.o.set(view3D.o);
        this.t.set(view3D.t);
        this.up.set(view3D.up);
        this.def_o.set(view3D.def_o);
        this.def_t.set(view3D.def_t);
        this.def_up.set(view3D.def_up);
        this.distance = view3D.distance;
        this.org_distance = view3D.distance;
        this.ratio = view3D.ratio;
        this.screenx = view3D.screenx;
        this.screeny = view3D.screeny;
    }
}

