/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.pattern;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class Shading
extends DictObj {
    private int dh;
    private PdfName di;
    private PdfRect dj;
    private PdfName dk;

    public Shading(Body body, int n, String string) {
        super(body);
        body.add(this);
        this.setShadingType(n);
        this.setName(string);
    }

    public void setShadingType(int n) {
        this.dh = n;
    }

    public void setColorSpace(PdfName pdfName) {
        this.di = pdfName;
    }

    public void setBBox(PdfRect pdfRect) {
        this.dj = pdfRect;
    }

    public void setName(String string) {
        this.dk = new PdfName(string);
    }

    public PdfName getName() {
        return this.dk;
    }

    public void updateDict() {
        this.dict.clear();
        this.dict.put(SHADINGTYPE, new Integer(this.dh));
        if (this.di != null) {
            this.dict.put(COLORSPACE, this.di);
        }
        if (this.dj != null) {
            this.dict.put(BBOX, this.dj);
        }
    }

    protected String toArrayString(float[] fArray, boolean bl) {
        if (fArray == null || fArray.length <= 0) {
            return null;
        }
        if (fArray.length == 1 && !bl) {
            return String.valueOf(fArray[0]);
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(fArray[0]);
        int n = 1;
        while (n < fArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(fArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected String toArrayString(boolean[] blArray, boolean bl) {
        if (blArray == null || blArray.length <= 0) {
            return null;
        }
        if (blArray.length == 1 && !bl) {
            return String.valueOf(blArray[0]);
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(blArray[0]);
        int n = 1;
        while (n < blArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(blArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

