/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.util.PdfUtil;

public class LineStyle {
    public static final String LN = "\r\n";
    public static final int BUTT_CAP = 0;
    public static final int ROUND_CAP = 1;
    public static final int SQUARE_CAP = 2;
    public static final int MITER_JOIN = 0;
    public static final int ROUND_JOIN = 1;
    public static final int BEVEL_JOIN = 2;
    private static PdfUtil cM = new PdfUtil();
    private int cN = 0;
    private DashPattern cO = new DashPattern();
    private float cP = 0.1f;
    private int cQ = 0;

    public LineStyle() {
    }

    public LineStyle(DashPattern dashPattern) {
        this.setLineDashPattern(dashPattern);
    }

    public LineStyle(float f) {
        this.setLineWidth(f);
    }

    public LineStyle(float f, DashPattern dashPattern) {
        this.setLineWidth(f);
        this.setLineDashPattern(dashPattern);
    }

    public final String toString() {
        float f = this.cP;
        return String.valueOf(cM.formatPrint(f)) + " w" + LN + this.cO.toString();
    }

    public int getLineCapStyle() {
        return this.cQ;
    }

    public DashPattern getLineDashPattern() {
        return this.cO;
    }

    public int getLineJoinStyle() {
        return this.cN;
    }

    public float getLineWidth() {
        return this.cP;
    }

    public void setLineCapStyle(int n) {
        this.cQ = n;
    }

    public void setLineDashPattern(DashPattern dashPattern) {
        this.cO = dashPattern;
    }

    public void setLineJoinStyle(int n) {
        this.cN = n;
    }

    public void setLineWidth(float f) {
        this.cP = f;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LineStyle)) {
            return false;
        }
        object = (LineStyle)object;
        if (((LineStyle)object).cP != this.cP) {
            return false;
        }
        if (((LineStyle)object).cQ != this.cQ) {
            return false;
        }
        if (((LineStyle)object).cN != this.cN) {
            return false;
        }
        return this.cO.equals(((LineStyle)object).cO);
    }
}

