/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.FileNotFoundException;
import java.io.IOException;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.CIDSystemInfo;
import option.io.pdfcommon.font.CmapStream;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Encoding;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.font.TrueTypeFile;
import option.io.pdfcommon.font.TrueTypeFontFileReader;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class TrueTypeFont
extends PdfFont {
    public String fontFileName;
    private TrueTypeFile cd;
    private TrueTypeFontFileReader fr;
    private CIDFont ce;
    private FontDescriptor cf;
    private int[] cg = new int[4];
    private String ch;
    private PdfName ci;
    private boolean cj;

    public TrueTypeFont() {
        this.setEncoding(new Encoding("UnicodeBigUnmarked"));
        this.bz = new CmapStream();
        this.bA = new EmbedFontFile();
    }

    public TrueTypeFont(String object) {
        this();
        this.fontFileName = object;
        try {
            this.fr = new TrueTypeFontFileReader(this.fontFileName, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = fileNotFoundException;
            fileNotFoundException.printStackTrace();
        }
        this.cd = new TrueTypeFile();
        this.cd.fr = this.fr;
        this.ce = new CIDFont();
        new CIDSystemInfo();
        this.cf = new FontDescriptor();
    }

    public void resetUesedChars(String string) {
        this.cd.resetUsedChars(string);
    }

    private void b(String string) {
        this.ci = new PdfName("TTF+" + string);
        this.setBaseFont(this.ci);
    }

    public void loadFontDirectory() {
        this.cd.loadFontDirectory();
        this.b(this.cd.getFontName());
    }

    public void createFont() {
        if (!this.cj) {
            this.cd.LoadFontData();
            this.cj = true;
        }
        this.cd.getUsedGlyphIndexs();
        this.bz.setCmapStr(this.cd.getUsedCmaps());
        this.bA.setFontData(this.cd.getFontData());
        this.b(this.cd.getFontName());
        this.cg = this.cd.getFontBox();
        this.setSubtype(DefinedName.TYPE0);
        this.setName(new PdfName(this.ch));
        this.setDescendantFont(this.ce);
        this.setEncoding(this.getEncoding());
        this.ce.setSubtype(DefinedName.CIDFONTTYPE2);
        this.ce.setName(this.getName());
        this.ce.setBaseFont(this.ci);
        this.ce.setFontDescriptor(this.cf);
        this.ce.setCIDSystemInfo(this.getEncoding().getMCIDSystemInfo());
        this.ce.setDW(1000);
        this.ce.dict.put(CIDTOGIDMAP, new PdfName("Identity"));
        PdfArray pdfArray = new PdfArray();
        int[] nArray = this.cd.getUsedGIInt();
        int[] nArray2 = this.cd.getUsedGWidths();
        int n = 0;
        while (n < nArray.length) {
            if (nArray2[n] != 1000) {
                pdfArray.addElement(String.valueOf(nArray[n]) + " [" + nArray2[n] + "]");
            }
            ++n;
        }
        this.ce.setW(pdfArray);
        this.cf.setFontName(this.ci);
        this.cf.setAscent(this.cd.getAscent());
        this.cf.setCapHeight(this.cd.getCapHeight());
        this.cf.setDescent(this.cd.getDscent());
        this.cf.setFlags(this.cd.getFlags());
        this.cf.setFontBBox(new PdfRect(this.cg[0], this.cg[1], this.cg[2], this.cg[3]));
        this.cf.setItalicAngle((int)this.cd.getItalicAngle());
        this.cf.setStemV(this.cd.getStemV());
        this.cf.setMEmbedFontFile(this.bA);
    }

    public TrueTypeFile getMTrueTypeFile() {
        return this.cd;
    }

    public void setListFontName(String string) {
        this.ch = string;
    }

    public String getListFontName() {
        return this.ch;
    }

    public int charWidth(char c) {
        Integer n = (Integer)this.cd.getCmaps().get(new Integer(c));
        return (Integer)this.cd.getUsedGI_GW().get(n);
    }

    public boolean isTrueTypeCollection() {
        return this.fontFileName.toLowerCase().indexOf(".ttc") > 0;
    }

    public void close() throws IOException {
        if (this.fr != null) {
            this.fr.close();
        }
    }
}

