/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.IOException;
import java.util.Hashtable;
import option.io.pdfcommon.font.DefaultTable;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class FontDirectory
extends TTFTable {
    private int bi;
    public Hashtable tableCollection;

    public FontDirectory() {
        this.offset = 0L;
        this.tableName = "fontdirectory";
    }

    public void loadFontData(TrueTypeFontFileReader trueTypeFontFileReader) {
        try {
            trueTypeFontFileReader.seek(this.offset);
            trueTypeFontFileReader.skipBytes(4);
            this.bi = trueTypeFontFileReader.readUInt16();
            this.tableCollection = new Hashtable();
            trueTypeFontFileReader.skipBytes(6);
            int n = 0;
            while (n < this.bi) {
                DefaultTable defaultTable = new DefaultTable();
                new DefaultTable().tableName = trueTypeFontFileReader.readByteString(4);
                defaultTable.checkSum = trueTypeFontFileReader.readUInt32();
                defaultTable.offset = trueTypeFontFileReader.readUInt32();
                defaultTable.length = (int)trueTypeFontFileReader.readUInt32();
                this.tableCollection.put(defaultTable.tableName, defaultTable);
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("IOException on reading FontDirectory data");
            return;
        }
    }

    public final String toString() {
        String string = "[ Class: FontDirectory  numTables: " + this.bi;
        if (this.tableCollection != null) {
            for (Object object : this.tableCollection.keySet()) {
                object = (TTFTable)this.tableCollection.get(object);
                string = String.valueOf(string) + "\n";
                string = String.valueOf(string) + "  tableName: " + ((TTFTable)object).tableName;
                string = String.valueOf(string) + "  checkSum: " + ((TTFTable)object).checkSum;
                string = String.valueOf(string) + "  offset: " + ((TTFTable)object).offset;
                string = String.valueOf(string) + "  length: " + ((TTFTable)object).length;
            }
        }
        string = String.valueOf(string) + "  ]";
        return string;
    }

    public Hashtable getTableCollection() {
        return this.tableCollection;
    }
}

