/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import option.io.pdfcommon.document.PdfDocument;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfUtil;

public class PdfDocumentInfo
extends PdfIndirectObject
implements DefinedName {
    private String title = "";
    private String aq = "";
    private String ar = "";
    private String as = "";
    private String at = "";
    private String au = "";
    private PdfDictionary dict = new PdfDictionary();
    private PdfDocument document;
    private Date av;
    private Date aw;
    private PdfUtil ab = new PdfUtil();

    public PdfDocumentInfo() {
        this.setCreationDate(new GregorianCalendar().getTime());
        this.setCreator("Kitec Corp");
        this.setProducer("Kitec Corp pdf Creator");
    }

    protected void finalize() throws Throwable {
        this.dict.clear();
        this.dict = null;
        super.finalize();
    }

    public PdfDocumentInfo(PdfDocument pdfDocument) {
        this();
        this.document = pdfDocument;
    }

    public PdfDictionary getDict() {
        return this.dict;
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public void setDocument(PdfDocument pdfDocument) {
        this.document = pdfDocument;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.dict.put(TITLE, this.ab.toTextString(string));
    }

    public String getAuthor() {
        return this.aq;
    }

    public void setAuthor(String string) {
        this.aq = string;
        this.dict.put(AUTHOR, this.ab.toTextString(string));
    }

    public String getSubject() {
        return this.ar;
    }

    public void setSubject(String string) {
        this.ar = string;
        this.dict.put(SUBJECT, this.ab.toTextString(string));
    }

    public String getKeywords() {
        return this.as;
    }

    public void setKeywords(String string) {
        this.as = string;
        this.dict.put(KEYWORDS, this.ab.toTextString(string));
    }

    public String getCreator() {
        return this.at;
    }

    public void setCreator(String string) {
        this.at = string;
        this.dict.put(CREATOR, this.ab.toTextString(string));
    }

    public String getProducer() {
        return this.au;
    }

    public void setProducer(String string) {
        this.au = string;
        this.dict.put(PRODUCER, this.ab.toTextString(string));
    }

    public Date getCreationDate() {
        return this.av;
    }

    public void setCreationDate(Date date) {
        this.av = date;
        this.dict.put(CREATIONDATE, this.ab.toTextString(this.ab.toDateString(date)));
    }

    public Date getModDate() {
        return this.aw;
    }

    public void setModDate(Date date) {
        this.aw = date;
        this.dict.put(MODDATE, this.ab.toTextString(this.ab.toDateString(date)));
    }

    public void setTrapped(PdfName pdfName) {
        this.dict.put(TRAPPED, pdfName);
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.setModDate(new GregorianCalendar().getTime());
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public void write(PdfOutFile pdfOutFile) {
        pdfOutFile.getPrintStream().println(this.toString());
    }
}

