/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import gui.basic.GraphicsButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class GraphicsBorderButton
extends GraphicsButton {
    private int mBorderWidth = 2;
    private int mShadowWidth = 3;
    private int mHgap = 3;
    private int mVgap = 2;
    private Color mBorderColor = new Color(189, 190, 189);
    private Color mInnerColor = Color.white;

    public GraphicsBorderButton(String string, Image image) {
        super(string, image, null);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = dimension.width + (this.mHgap + this.mBorderWidth) * 2 + this.mShadowWidth + 1;
        dimension.height = dimension.height + (this.mVgap + this.mBorderWidth) * 2 + this.mShadowWidth + 1;
        return dimension;
    }

    public Color getBorderColor() {
        return new Color(this.mBorderColor.getRed(), this.mBorderColor.getGreen(), this.mBorderColor.getBlue());
    }

    public Color getInnerColor() {
        return new Color(this.mInnerColor.getRed(), this.mInnerColor.getGreen(), this.mInnerColor.getBlue());
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public int getHgap() {
        return this.mHgap;
    }

    public int getVgap() {
        return this.mVgap;
    }

    public int getShadowWidth() {
        return this.mShadowWidth;
    }

    public void setBorderColor(Color color) {
        if (color == null || this.mBorderColor.equals(color)) {
            return;
        }
        this.mBorderColor = color;
        this.repaint();
    }

    public void setInnerColor(Color color) {
        if (color == null || this.mInnerColor.equals(color)) {
            return;
        }
        this.mInnerColor = color;
        this.repaint();
    }

    public void setBorderWidth(int n) {
        if (n <= 0 || this.mBorderWidth == n) {
            return;
        }
        this.mBorderWidth = n;
        this.repaint();
    }

    public void setHgap(int n) {
        if (n < 0 || this.mHgap == n) {
            return;
        }
        this.mHgap = n;
        this.repaint();
    }

    public void setVgap(int n) {
        if (n < 0 || this.mVgap == n) {
            return;
        }
        this.mVgap = n;
        this.repaint();
    }

    public void setShadowWidth(int n) {
        if (n < 0 || this.mShadowWidth == n) {
            return;
        }
        this.mShadowWidth = n;
    }

    public void paint(Graphics graphics) {
        if (this.mForeImage == null) {
            return;
        }
        Dimension dimension = this.mForeImage.getPreferredSize();
        int n = this.getState() == 1 ? 0 : 1;
        int n2 = this.getState() == 1 ? 0 : 1;
        this.drawBorder(graphics, n, n2, dimension.width, dimension.height);
        this.mForeImage.paintIcon(graphics, n + this.mBorderWidth + this.mHgap, n2 + this.mBorderWidth + this.mVgap);
    }

    protected void paintButtonNormal() {
        if (!this.isEnabled()) {
            return;
        }
        this.setState(1);
        this.repaint();
    }

    protected void paintButtonPressed() {
        if (!this.isEnabled()) {
            return;
        }
        this.setState(0);
        this.repaint();
    }

    private void drawBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3 + this.mBorderWidth + this.mHgap * 2;
        int n6 = n4 + this.mBorderWidth + this.mVgap * 2;
        Color color = graphics.getColor();
        graphics.setColor(Color.gray);
        graphics.fillRect(n + this.mShadowWidth, n2 + this.mShadowWidth, n5, n6);
        graphics.setColor(this.mInnerColor);
        graphics.fillRect(n, n2, n5, n6);
        graphics.setColor(this.mBorderColor);
        graphics.drawRect(n, n2, n5, n6);
        graphics.setColor(color);
    }
}

