/*
 * Decompiled with CFR 0.152.
 */
package nethome.servlet;

import com.kt.io.FileIOUtil;
import com.kt.util.CompressData;
import com.kt.util.HttpIOUtil;
import com.kt.util.ObjectFolderUtil;
import com.kt.util.StringUtil;
import com.kt.util.UniqueNameUtil;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nethome.servlet.AbstractFileIOServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileCreateServlet
extends AbstractFileIOServlet {
    private static final Log mLog = LogFactory.getLog(FileCreateServlet.class);
    private Charset charsetUTF8 = Charset.forName("UTF-8");

    @Override
    protected String configFileType() {
        return null;
    }

    @Override
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html><head><title>CHECK</title></head><body>REQ_ URI:" + httpServletRequest.getRequestURI() + "<br></body></html>");
        printWriter.flush();
    }

    @Override
    protected void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean bl;
        String string;
        byte[] byArray = HttpIOUtil.recvData((HttpServletRequest)httpServletRequest);
        byte[] byArray2 = null;
        Map<String, byte[]> map = this.extractCommandData(byArray);
        if (map != null) {
            string = null;
            String string2 = null;
            if (StringUtil.isEmpty((String)this.configFileType())) {
                string = this.getValue(map, "suffix");
                string = StringUtil.emptyToZeroString((String)string).replaceAll("\\.", "");
                string2 = this.createFileOutputDirName(this.mConfigFolder, this.mContextRootRealDir, string);
            } else {
                string = this.configFileType();
                string = StringUtil.emptyToZeroString((String)string).replaceFirst("\\.", "");
                string2 = this.mFileOutputDirName;
            }
            FilenamePair filenamePair = this.createFileName(string, map);
            if (!this.isValidFileName(filenamePair.servername) || !this.isValidFileName(filenamePair.clientname)) {
                this.processInvalidFileName(httpServletRequest, httpServletResponse);
                return;
            }
            this.createFile(map, filenamePair.servername, this.mContextRootRealDir, string2);
            try {
                byArray2 = filenamePair.clientname.getBytes(this.charsetUTF8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                mLog.error((Object)unsupportedEncodingException);
            }
        }
        string = this.getValue(map, "_compress");
        boolean bl2 = bl = "1".equals(string);
        if (bl) {
            byArray2 = CompressData.compress(byArray2);
        }
        HttpIOUtil.sendData((HttpServletResponse)httpServletResponse, (byte[])byArray2, (boolean)true, (boolean)bl2);
    }

    protected Map<String, byte[]> extractCommandData(byte[] byArray) {
        HashMap<String, byte[]> hashMap = null;
        if (byArray != null) {
            try {
                hashMap = new HashMap<String, byte[]>();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                int n = dataInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    String string = this.readString(dataInputStream);
                    int n2 = dataInputStream.readInt();
                    byte[] byArray2 = new byte[n2];
                    int n3 = dataInputStream.read(byArray2);
                    if (n3 != n2) {
                        throw new IOException("length mismatch " + n2 + "/" + n3);
                    }
                    hashMap.put(string, byArray2);
                }
            }
            catch (IOException iOException) {
                mLog.error((Object)iOException);
                hashMap = null;
            }
        }
        mLog.debug((Object)("commandData[" + hashMap + "]"));
        return hashMap;
    }

    protected String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        int n2 = dataInputStream.read(byArray);
        if (n2 != n) {
            throw new IOException("length mismatch " + n + "/" + n2);
        }
        return new String(byArray, this.charsetUTF8.name());
    }

    protected FilenamePair createFileName(String string, Map<String, byte[]> map) {
        Collection collection = ObjectFolderUtil.findChildFolders((ObjectFolder)this.mConfigFolder, (String)string);
        if (collection.isEmpty()) {
            return null;
        }
        ObjectFolder objectFolder = (ObjectFolder)collection.iterator().next();
        Collection collection2 = ObjectFolderUtil.findChildFolders((ObjectFolder)objectFolder, (String)"name");
        if (collection2.isEmpty()) {
            return null;
        }
        ObjectFolder objectFolder2 = (ObjectFolder)collection2.iterator().next();
        String string2 = ObjectNode.getNodeString((ObjectNode)objectFolder2.findNode("prefix"));
        String string3 = ObjectNode.getNodeString((ObjectNode)objectFolder2.findNode("suffix"));
        UniqueNameUtil.UniqueNameInfo uniqueNameInfo = UniqueNameUtil.createUniqueNameInfo((String)string2, (String)string3);
        return new FilenamePair(UniqueNameUtil.createUniqueName((UniqueNameUtil.UniqueNameInfo)uniqueNameInfo), UniqueNameUtil.createRequestName((UniqueNameUtil.UniqueNameInfo)uniqueNameInfo));
    }

    protected String getValue(Map<String, byte[]> map, String string) {
        byte[] byArray = map.get(string);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    protected void createFile(Map<String, byte[]> map, String string, String string2, String string3) {
        byte[] byArray = map.get("DATA");
        if (!(byArray instanceof byte[])) {
            return;
        }
        byte[] byArray2 = byArray;
        File file = new File(string3, string);
        FileIOUtil.bytesToFile((File)file, (byte[])byArray2);
    }

    public static class FilenamePair {
        public String servername;
        public String clientname;

        public FilenamePair(String string, String string2) {
            this.servername = string;
            this.clientname = string2;
        }
    }
}

