/*
 * Decompiled with CFR 0.152.
 */
package option.threed;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JPanel;
import option.threed.IScreen3D;

public class ProtoPanel3D
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private int width;
    private int height;
    private BufferedImage cd;
    private int[] rgb;
    private IScreen3D ce = null;

    public ProtoPanel3D() {
        this(280, 210);
    }

    public ProtoPanel3D(int n, int n2) {
        this.setBackground(Color.WHITE);
        this.width = n;
        this.height = n2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.addComponentListener(new ComponentListener(){

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                ProtoPanel3D.this.a();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public void add3DUI(IScreen3D iScreen3D) {
        this.ce = iScreen3D;
        if (this.ce != null) {
            this.getRGB();
            this.ce.updateBuffer(this.rgb, this.width, this.height);
        }
    }

    public void remove3DUI(IScreen3D iScreen3D) {
        this.ce = null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    private void a() {
        if (!this.isShowing()) {
            return;
        }
        this.b();
    }

    public void paint(Graphics graphics) {
        if (this.b() && this.ce == null) {
            return;
        }
        graphics.drawImage(this.cd, 0, 0, null);
    }

    private boolean b() {
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        this.width = dimension.width;
        this.height = dimension.height;
        boolean bl = false;
        if (this.cd == null) {
            bl = true;
        } else if (this.cd.getWidth() != this.width || this.cd.getHeight() != this.height) {
            bl = true;
        }
        if (bl) {
            this.cd = new BufferedImage(this.width, this.height, 1);
            this.rgb = ((DataBufferInt)this.cd.getRaster().getDataBuffer()).getData();
            if (this.rgb != null && this.ce == null) {
                int n = 0;
                while (n < this.rgb.length) {
                    this.rgb[n] = -1;
                    ++n;
                }
            }
            if (this.ce != null) {
                this.ce.updateBuffer(this.rgb, this.width, this.height);
            }
        }
        return bl;
    }

    public int[] getRGB() {
        if (this.rgb == null) {
            this.b();
        }
        return this.rgb;
    }

    public void update(Graphics graphics) {
        super.update(graphics);
    }

    public void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.update(graphics);
        }
    }

    public void repaintTemporary() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.cd != null) {
            graphics.drawImage(this.cd, 0, 0, null);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.ce != null) {
            this.ce.mouseDragged(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.ce != null) {
            this.ce.mouseMoved(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.ce != null) {
            this.ce.mouseReleased(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.ce != null) {
            this.ce.mouseEntered(mouseEvent.getX(), mouseEvent.getY());
        }
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.ce != null) {
            this.ce.mouseExited(mouseEvent.getX(), mouseEvent.getY());
        }
        this.transferFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.ce != null) {
            this.ce.keyPressed(keyEvent.getKeyCode(), keyEvent.getModifiers());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.ce != null) {
            this.ce.keyReleased(keyEvent.getKeyCode());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.ce != null) {
            int n = mouseWheelEvent.getWheelRotation();
            this.ce.mouseWheelMoved(n);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.requestFocus();
        } else {
            this.transferFocus();
        }
    }
}

