/*
 * Decompiled with CFR 0.152.
 */
package model.util;

import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import model.primitive.LsEdge;
import model.primitive.LsFactory;
import model.primitive.LsObject;
import model.primitive.LsShape;
import model.primitive.LsSurface;
import model.primitive.Primitive3D;
import model.primitive.SBox;
import model.primitive.SCone;
import model.primitive.SCylinder;
import model.primitive.STorus;
import model.shape.primitive.SMatrix4d;
import model.shape.primitive.SVector3d;

public class SurfaceModelTranslator {
    private static final SurfaceModelTranslator bX = new SurfaceModelTranslator();

    public static final SurfaceModelTranslator getInstance() {
        return bX;
    }

    private SurfaceModelTranslator() {
    }

    public LsShape create(SBox sBox, SMatrix4d sMatrix4d) {
        Object object;
        int n;
        List<LsEdge> list;
        Color color = sBox.fillColor;
        Color color2 = sBox.edgeColor;
        if (color == null) {
            color = Color.WHITE;
        }
        if (color2 == null) {
            color2 = Color.BLACK;
        }
        LsShape lsShape = this.a(sBox, color, color2);
        double[][] dArray = sBox.points;
        double[] dArray2 = sBox.dir;
        if (sMatrix4d != null) {
            dArray = new double[sBox.points.length][3];
            dArray2 = new double[3];
            SVector3d sVector3d = new SVector3d();
            int n2 = 0;
            while (n2 < sBox.points.length) {
                sMatrix4d.translate(sVector3d, sBox.points[n2][0], sBox.points[n2][1], sBox.points[n2][2]);
                dArray[n2][0] = (float)sVector3d.x;
                dArray[n2][1] = (float)sVector3d.y;
                dArray[n2][2] = (float)sVector3d.z;
                ++n2;
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            sMatrix4d.translate(sVector3d, 0.0, 0.0, 0.0);
            d = sVector3d.x;
            d2 = sVector3d.y;
            d3 = sVector3d.z;
            sMatrix4d.translate(sVector3d, sBox.dir[0], sBox.dir[1], sBox.dir[2]);
            dArray2[0] = (float)(sVector3d.x - d);
            dArray2[1] = (float)(sVector3d.y - d2);
            dArray2[2] = (float)(sVector3d.z - d3);
        }
        int n3 = sBox.points.length;
        SVector3d[] sVector3dArray = this.a(dArray, false);
        SVector3d[] sVector3dArray2 = this.a(dArray, dArray2, false);
        LsEdge[] lsEdgeArray = this.a(sVector3dArray);
        LsEdge[] lsEdgeArray2 = this.a(sVector3dArray2);
        LsEdge[] lsEdgeArray3 = this.a(sVector3dArray, sVector3dArray2);
        LsSurface lsSurface = null;
        LsSurface lsSurface2 = null;
        LsSurface[] lsSurfaceArray = new LsSurface[n3];
        if (sBox.drawTop) {
            lsSurface = LsFactory.createSurface();
            list = lsSurface.getEdges();
            n = n3 - 1;
            while (n >= 0) {
                object = lsEdgeArray[n];
                ((LsEdge)object).drawEdge = sBox.drawAllEdge ? true : (sBox.drawEdge != null ? sBox.drawEdge[n] : false);
                list.add((LsEdge)object);
                --n;
            }
        }
        if (sBox.drawBot) {
            lsSurface2 = LsFactory.createSurface();
            list = lsSurface2.getEdges();
            n = 0;
            while (n < n3) {
                object = lsEdgeArray2[n];
                ((LsEdge)object).drawEdge = sBox.drawAllEdge ? true : (sBox.drawEdge != null ? sBox.drawEdge[n] : false);
                list.add((LsEdge)object);
                ++n;
            }
        }
        int n4 = 0;
        while (n4 < n3) {
            if (sBox.drawAllSide || sBox.drawSide == null || sBox.drawSide[n4]) {
                LsSurface lsSurface3 = LsFactory.createSurface();
                object = lsSurface3.getEdges();
                object.add(lsEdgeArray[n4]);
                object.add(lsEdgeArray3[n4 == n3 - 1 ? 0 : n4 + 1]);
                object.add(lsEdgeArray2[n4]);
                object.add(lsEdgeArray3[n4]);
                lsSurfaceArray[n4] = lsSurface3;
            }
            ++n4;
        }
        if (lsSurface != null) {
            LsEdge[] lsEdgeArray4 = lsEdgeArray;
            int n5 = lsEdgeArray.length;
            int n6 = 0;
            while (n6 < n5) {
                LsEdge lsEdge = lsEdgeArray4[n6];
                lsEdge.surface1 = lsSurface;
                ++n6;
            }
        }
        int n7 = 0;
        LsObject[] lsObjectArray = lsSurfaceArray;
        int n8 = lsSurfaceArray.length;
        int n9 = 0;
        while (n9 < n8) {
            LsSurface lsSurface4 = lsObjectArray[n9];
            if (lsSurface4 != null) {
                lsEdgeArray[n7].surface2 = lsSurface4;
                lsEdgeArray2[n7].surface2 = lsSurface4;
                lsEdgeArray3[n7 == n3 - 1 ? 0 : n7 + 1].surface1 = lsSurface4;
                lsEdgeArray3[n7].surface2 = lsSurface4;
            }
            ++n7;
            ++n9;
        }
        if (lsSurface2 != null) {
            lsObjectArray = lsEdgeArray2;
            n8 = lsEdgeArray2.length;
            n9 = 0;
            while (n9 < n8) {
                LsObject lsObject = lsObjectArray[n9];
                ((LsEdge)lsObject).surface1 = lsSurface2;
                ++n9;
            }
        }
        Object object2 = new SVector3d();
        Serializable serializable = new SVector3d();
        int n10 = 0;
        while (n10 < n3) {
            LsEdge lsEdge = lsEdgeArray3[n10];
            if (lsEdge.surface1 != null || lsEdge.surface2 != null) {
                if (lsEdge.surface1 == null || lsEdge.surface2 == null) {
                    lsEdge.drawEdge = true;
                } else {
                    n9 = n10 == 0 ? n3 - 1 : n10 - 1;
                    n8 = n10 == n3 - 1 ? 0 : n10 + 1;
                    SVector3d sVector3d = sVector3dArray[n9];
                    SVector3d sVector3d2 = sVector3dArray[n10];
                    SVector3d sVector3d3 = sVector3dArray[n8];
                    ((SVector3d)object2).set(sVector3d2.x - sVector3d.x, sVector3d2.y - sVector3d.y, sVector3d2.z - sVector3d.z);
                    ((SVector3d)object2).normalize();
                    ((SVector3d)serializable).set(sVector3d3.x - sVector3d2.x, sVector3d3.y - sVector3d2.y, sVector3d3.z - sVector3d2.z);
                    ((SVector3d)serializable).normalize();
                    double d = ((SVector3d)object2).dot((SVector3d)serializable);
                    lsEdge.drawEdge = d <= 0.85;
                }
            }
            ++n10;
        }
        object2 = lsShape.getSurfaces();
        if (lsSurface != null) {
            object2.add(lsSurface);
        }
        if (lsSurface2 != null) {
            object2.add(lsSurface2);
        }
        if (lsSurfaceArray.length != 0) {
            LsSurface[] lsSurfaceArray2 = lsSurfaceArray;
            n8 = lsSurfaceArray.length;
            n9 = 0;
            while (n9 < n8) {
                serializable = lsSurfaceArray2[n9];
                if (serializable != null) {
                    object2.add(serializable);
                }
                ++n9;
            }
        }
        lsShape.build();
        return lsShape;
    }

    public LsShape create(SCylinder sCylinder, SMatrix4d sMatrix4d) {
        Object object;
        int n;
        List<LsEdge> list;
        Object object2;
        Color color = sCylinder.fillColor;
        Color color2 = sCylinder.edgeColor;
        if (color == null) {
            color = Color.WHITE;
        }
        if (color2 == null) {
            color2 = Color.BLACK;
        }
        LsShape lsShape = this.a(sCylinder, color, color2);
        SVector3d[] sVector3dArray = null;
        SVector3d[] sVector3dArray2 = null;
        int n2 = sCylinder.getDivideCount();
        double d = sCylinder.radius;
        SVector3d sVector3d = new SVector3d(sCylinder.center[0], sCylinder.center[1], sCylinder.center[2]);
        SVector3d sVector3d2 = new SVector3d(sCylinder.dir[0], sCylinder.dir[1], sCylinder.dir[2]);
        SVector3d sVector3d3 = new SVector3d(sVector3d2.x, sVector3d2.y, sVector3d2.z);
        sVector3d3.normalize();
        SVector3d sVector3d4 = new SVector3d();
        SVector3d sVector3d5 = new SVector3d();
        SVector3d[] sVector3dArray3 = new SVector3d[]{new SVector3d(1.0, 0.0, 0.0), new SVector3d(0.0, 1.0, 0.0), new SVector3d(0.0, 0.0, 1.0)};
        SVector3d sVector3d6 = null;
        double d2 = Double.POSITIVE_INFINITY;
        int n3 = 0;
        while (n3 < sVector3dArray3.length) {
            double d3 = Math.abs(sVector3dArray3[n3].dot(sVector3d3));
            if (d3 < d2) {
                d2 = d3;
                sVector3d6 = sVector3dArray3[n3];
            }
            ++n3;
        }
        sVector3d4.cross(sVector3d3, sVector3d6);
        sVector3d5.cross(sVector3d3, sVector3d4);
        sVector3d4.normalize();
        sVector3d5.normalize();
        SVector3d sVector3d7 = new SVector3d();
        SVector3d sVector3d8 = new SVector3d();
        sVector3dArray = new SVector3d[n2];
        sVector3dArray2 = new SVector3d[n2];
        int n4 = 0;
        while (n4 < n2) {
            double d4 = 0.0 + (double)n4 * Math.PI * 2.0 / (double)n2;
            double d5 = Math.cos(d4);
            double d6 = Math.sin(d4);
            SVector3d sVector3d9 = new SVector3d();
            sVector3d9.set(sVector3d);
            sVector3d7.set(sVector3d4);
            sVector3d7.scale(d * d5);
            sVector3d9.add(sVector3d7);
            sVector3d8.set(sVector3d5);
            sVector3d8.scale(d * d6);
            sVector3d9.add(sVector3d8);
            sVector3dArray[n4] = sVector3d9;
            sVector3d9 = new SVector3d();
            sVector3d9.set(sVector3dArray[n4]);
            sVector3d9.add(sVector3d2);
            sVector3dArray2[n4] = sVector3d9;
            ++n4;
        }
        if (sMatrix4d != null) {
            object2 = sVector3dArray;
            int n5 = sVector3dArray.length;
            int n6 = 0;
            while (n6 < n5) {
                SVector3d sVector3d10 = object2[n6];
                sMatrix4d.translate(sVector3d7, sVector3d10.x, sVector3d10.y, sVector3d10.z);
                sVector3d10.set(sVector3d7);
                ++n6;
            }
            object2 = sVector3dArray2;
            n5 = sVector3dArray2.length;
            n6 = 0;
            while (n6 < n5) {
                SVector3d sVector3d11 = object2[n6];
                sMatrix4d.translate(sVector3d7, sVector3d11.x, sVector3d11.y, sVector3d11.z);
                sVector3d11.set(sVector3d7);
                ++n6;
            }
        }
        LsEdge[] lsEdgeArray = this.a(sVector3dArray2);
        LsEdge[] lsEdgeArray2 = this.a(sVector3dArray, sVector3dArray2);
        LsEdge[] lsEdgeArray3 = this.a(sVector3dArray);
        object2 = null;
        LsSurface lsSurface = null;
        LsSurface[] lsSurfaceArray = new LsSurface[n2];
        if (sCylinder.dispTop) {
            object2 = LsFactory.createSurface();
            list = ((LsSurface)object2).getEdges();
            n = n2 - 1;
            while (n >= 0) {
                object = lsEdgeArray3[n];
                ((LsEdge)object).drawEdge = sCylinder.dispEdge;
                list.add((LsEdge)object);
                --n;
            }
        }
        if (sCylinder.dispBot) {
            lsSurface = LsFactory.createSurface();
            list = lsSurface.getEdges();
            n = 0;
            while (n < n2) {
                object = lsEdgeArray[n];
                ((LsEdge)object).drawEdge = sCylinder.dispEdge;
                list.add((LsEdge)object);
                ++n;
            }
        }
        int n7 = 0;
        while (n7 < n2) {
            LsSurface lsSurface2 = LsFactory.createSurface();
            object = lsSurface2.getEdges();
            object.add((LsEdge)lsEdgeArray3[n7]);
            object.add(lsEdgeArray2[n7 == n2 - 1 ? 0 : n7 + 1]);
            object.add(lsEdgeArray[n7]);
            object.add(lsEdgeArray2[n7]);
            lsSurfaceArray[n7] = lsSurface2;
            ++n7;
        }
        if (object2 != null) {
            LsEdge[] lsEdgeArray4 = lsEdgeArray3;
            int n8 = lsEdgeArray3.length;
            int n9 = 0;
            while (n9 < n8) {
                LsEdge lsEdge = lsEdgeArray4[n9];
                lsEdge.surface1 = object2;
                ++n9;
            }
        }
        int n10 = 0;
        LsObject[] lsObjectArray = lsSurfaceArray;
        int n11 = lsSurfaceArray.length;
        int n12 = 0;
        while (n12 < n11) {
            LsSurface lsSurface3 = lsObjectArray[n12];
            if (lsSurface3 != null) {
                lsEdgeArray3[n10].surface2 = lsSurface3;
                lsEdgeArray[n10].surface2 = lsSurface3;
                lsEdgeArray2[n10 == n2 - 1 ? 0 : n10 + 1].surface1 = lsSurface3;
                lsEdgeArray2[n10].surface2 = lsSurface3;
            }
            ++n10;
            ++n12;
        }
        if (lsSurface != null) {
            lsObjectArray = lsEdgeArray;
            n11 = lsEdgeArray.length;
            n12 = 0;
            while (n12 < n11) {
                LsObject lsObject = lsObjectArray[n12];
                ((LsEdge)lsObject).surface1 = lsSurface;
                ++n12;
            }
        }
        n10 = 0;
        while (n10 < n2) {
            LsEdge lsEdge = lsEdgeArray2[n10];
            lsEdge.drawEdge = false;
            lsEdge.drawEdgeBoundary = sCylinder.dispEdge;
            ++n10;
        }
        List<LsSurface> list2 = lsShape.getSurfaces();
        if (object2 != null) {
            list2.add((LsSurface)object2);
        }
        if (lsSurface != null) {
            list2.add(lsSurface);
        }
        if (lsSurfaceArray.length != 0) {
            lsObjectArray = lsSurfaceArray;
            n11 = lsSurfaceArray.length;
            n12 = 0;
            while (n12 < n11) {
                LsObject lsObject = lsObjectArray[n12];
                if (lsObject != null) {
                    list2.add((LsSurface)lsObject);
                }
                ++n12;
            }
        }
        lsShape.build();
        return lsShape;
    }

    public LsShape create(SCone sCone, SMatrix4d sMatrix4d) {
        Object object;
        int n;
        List<LsEdge> list;
        Object object2;
        Color color = sCone.fillColor;
        Color color2 = sCone.edgeColor;
        if (color == null) {
            color = Color.WHITE;
        }
        if (color2 == null) {
            color2 = Color.BLACK;
        }
        LsShape lsShape = this.a(sCone, color, color2);
        SVector3d[] sVector3dArray = null;
        SVector3d[] sVector3dArray2 = null;
        int n2 = 12;
        double d = sCone.radius;
        SVector3d sVector3d = new SVector3d(sCone.center[0], sCone.center[1], sCone.center[2]);
        SVector3d sVector3d2 = new SVector3d(sCone.dir[0], sCone.dir[1], sCone.dir[2]);
        SVector3d sVector3d3 = new SVector3d(sVector3d2.x, sVector3d2.y, sVector3d2.z);
        double d2 = sVector3d3.length();
        sVector3d3.normalize();
        SVector3d sVector3d4 = new SVector3d();
        SVector3d sVector3d5 = new SVector3d();
        SVector3d[] sVector3dArray3 = new SVector3d[]{new SVector3d(1.0, 0.0, 0.0), new SVector3d(0.0, 1.0, 0.0), new SVector3d(0.0, 0.0, 1.0)};
        SVector3d sVector3d6 = new SVector3d();
        sVector3d6.set(sVector3d);
        sVector3d6.add(sVector3d2);
        boolean bl = sCone.cutShape;
        double d3 = sCone.cutHeight;
        boolean bl2 = sCone.dispCutSurface;
        SVector3d sVector3d7 = null;
        if (bl) {
            if (d3 <= 0.0) {
                bl = false;
            } else if (d2 <= d3) {
                bl = false;
            }
            if (bl) {
                sVector3d7 = new SVector3d();
                sVector3d7.set(sVector3d3);
                sVector3d7.scale(d3);
            }
        }
        if (!bl) {
            bl2 = false;
        }
        SVector3d sVector3d8 = null;
        double d4 = Double.POSITIVE_INFINITY;
        int n3 = 0;
        while (n3 < sVector3dArray3.length) {
            double d5 = Math.abs(sVector3dArray3[n3].dot(sVector3d3));
            if (d5 < d4) {
                d4 = d5;
                sVector3d8 = sVector3dArray3[n3];
            }
            ++n3;
        }
        sVector3d4.cross(sVector3d3, sVector3d8);
        sVector3d5.cross(sVector3d3, sVector3d4);
        sVector3d4.normalize();
        sVector3d5.normalize();
        SVector3d sVector3d9 = new SVector3d();
        SVector3d sVector3d10 = new SVector3d();
        sVector3dArray = new SVector3d[n2];
        if (bl) {
            sVector3dArray2 = new SVector3d[n2];
        }
        double d6 = 1.0;
        int n4 = 0;
        while (n4 < n2) {
            double d7 = 0.0 + (double)n4 * Math.PI * 2.0 / (double)n2;
            double d8 = Math.cos(d7);
            double d9 = Math.sin(d7);
            SVector3d sVector3d11 = new SVector3d();
            sVector3d11.set(sVector3d);
            sVector3d9.set(sVector3d4);
            sVector3d9.scale(d * d8);
            sVector3d11.add(sVector3d9);
            sVector3d10.set(sVector3d5);
            sVector3d10.scale(d * d9);
            sVector3d11.add(sVector3d10);
            sVector3dArray[n4] = sVector3d11;
            if (bl) {
                d6 = (d2 - d3) / d2;
                sVector3d11 = new SVector3d();
                sVector3d11.set(sVector3d);
                sVector3d9.set(sVector3d4);
                sVector3d9.scale(d * d8 * d6);
                sVector3d11.add(sVector3d9);
                sVector3d10.set(sVector3d5);
                sVector3d10.scale(d * d9 * d6);
                sVector3d11.add(sVector3d10);
                sVector3d11.add(sVector3d7);
                sVector3dArray2[n4] = sVector3d11;
            }
            ++n4;
        }
        if (sMatrix4d != null) {
            object2 = sVector3dArray;
            int n5 = sVector3dArray.length;
            int n6 = 0;
            while (n6 < n5) {
                SVector3d sVector3d12 = object2[n6];
                sMatrix4d.translate(sVector3d9, sVector3d12.x, sVector3d12.y, sVector3d12.z);
                sVector3d12.set(sVector3d9);
                ++n6;
            }
            if (bl) {
                object2 = sVector3dArray2;
                n5 = sVector3dArray2.length;
                n6 = 0;
                while (n6 < n5) {
                    SVector3d sVector3d13 = object2[n6];
                    sMatrix4d.translate(sVector3d9, sVector3d13.x, sVector3d13.y, sVector3d13.z);
                    sVector3d13.set(sVector3d9);
                    ++n6;
                }
            }
            sMatrix4d.translate(sVector3d9, sVector3d6.x, sVector3d6.y, sVector3d6.z);
            sVector3d6.set(sVector3d9);
        }
        LsEdge[] lsEdgeArray = null;
        LsEdge[] lsEdgeArray2 = null;
        LsEdge[] lsEdgeArray3 = null;
        lsEdgeArray3 = this.a(sVector3dArray);
        if (bl) {
            lsEdgeArray = this.a(sVector3dArray2);
        }
        lsEdgeArray2 = bl ? this.a(sVector3dArray, sVector3dArray2) : this.a(sVector3dArray, sVector3d6);
        object2 = null;
        LsSurface lsSurface = null;
        LsSurface[] lsSurfaceArray = new LsSurface[n2];
        if (sCone.dispBottom) {
            object2 = LsFactory.createSurface();
            list = ((LsSurface)object2).getEdges();
            n = n2 - 1;
            while (n >= 0) {
                object = lsEdgeArray3[n];
                ((LsEdge)object).drawEdge = sCone.dispEdge;
                list.add((LsEdge)object);
                --n;
            }
        }
        if (bl2) {
            lsSurface = LsFactory.createSurface();
            list = lsSurface.getEdges();
            n = 0;
            while (n < n2) {
                object = lsEdgeArray[n];
                ((LsEdge)object).drawEdge = sCone.dispEdge;
                list.add((LsEdge)object);
                ++n;
            }
        }
        int n7 = 0;
        while (n7 < n2) {
            LsSurface lsSurface2 = LsFactory.createSurface();
            object = lsSurface2.getEdges();
            object.add((LsEdge)lsEdgeArray3[n7]);
            object.add(lsEdgeArray2[n7 == n2 - 1 ? 0 : n7 + 1]);
            if (bl) {
                object.add(lsEdgeArray[n7]);
            }
            object.add(lsEdgeArray2[n7]);
            lsSurfaceArray[n7] = lsSurface2;
            ++n7;
        }
        if (object2 != null) {
            LsEdge[] lsEdgeArray4 = lsEdgeArray3;
            int n8 = lsEdgeArray3.length;
            int n9 = 0;
            while (n9 < n8) {
                LsEdge lsEdge = lsEdgeArray4[n9];
                lsEdge.surface1 = object2;
                ++n9;
            }
        }
        int n10 = 0;
        LsObject[] lsObjectArray = lsSurfaceArray;
        int n11 = lsSurfaceArray.length;
        int n12 = 0;
        while (n12 < n11) {
            LsSurface lsSurface3 = lsObjectArray[n12];
            if (lsSurface3 != null) {
                lsEdgeArray3[n10].surface2 = lsSurface3;
                if (bl2) {
                    lsEdgeArray[n10].surface2 = lsSurface3;
                }
                lsEdgeArray2[n10 == n2 - 1 ? 0 : n10 + 1].surface1 = lsSurface3;
                lsEdgeArray2[n10].surface2 = lsSurface3;
            }
            ++n10;
            ++n12;
        }
        if (lsSurface != null) {
            lsObjectArray = lsEdgeArray;
            n11 = lsEdgeArray.length;
            n12 = 0;
            while (n12 < n11) {
                LsObject lsObject = lsObjectArray[n12];
                ((LsEdge)lsObject).surface1 = lsSurface;
                ++n12;
            }
        }
        n10 = 0;
        while (n10 < n2) {
            LsEdge lsEdge = lsEdgeArray2[n10];
            lsEdge.drawEdge = false;
            lsEdge.drawEdgeBoundary = sCone.dispEdge;
            ++n10;
        }
        List<LsSurface> list2 = lsShape.getSurfaces();
        if (object2 != null) {
            list2.add((LsSurface)object2);
        }
        if (lsSurface != null) {
            list2.add(lsSurface);
        }
        if (lsSurfaceArray.length != 0) {
            lsObjectArray = lsSurfaceArray;
            n11 = lsSurfaceArray.length;
            n12 = 0;
            while (n12 < n11) {
                LsObject lsObject = lsObjectArray[n12];
                if (lsObject != null) {
                    list2.add((LsSurface)lsObject);
                }
                ++n12;
            }
        }
        lsShape.build();
        return lsShape;
    }

    public LsShape create(STorus sTorus, SMatrix4d sMatrix4d) {
        Color color = sTorus.fillColor;
        Color color2 = sTorus.edgeColor;
        if (color == null) {
            color = Color.WHITE;
        }
        if (color2 == null) {
            color2 = Color.BLACK;
        }
        LsShape lsShape = this.a(sTorus, color, color2);
        boolean bl = Math.abs(sTorus.getRadExtent() - Math.PI * 2) < 0.01;
        double d = sTorus.getRadExtent() / (Math.PI * 2);
        int n = sTorus.getDivideCount();
        int n2 = sTorus.getDivideMinorCircle();
        int n3 = (int)((double)n * d);
        if (n3 == 0) {
            n3 = 1;
        }
        if (bl) {
            n3 = n;
        }
        SVector3d[][] sVector3dArray = new SVector3d[n3 + 1][n2];
        LsEdge[][] lsEdgeArray = new LsEdge[n3 + 1][n2];
        LsEdge[][] lsEdgeArray2 = new LsEdge[n3][n2];
        LsSurface[][] lsSurfaceArray = new LsSurface[n3][n2];
        LsSurface lsSurface = null;
        LsSurface lsSurface2 = null;
        List<LsSurface> list = lsShape.getSurfaces();
        SVector3d sVector3d = new SVector3d();
        Serializable[] serializableArray = new SVector3d();
        Serializable[] serializableArray2 = new SVector3d(sTorus.center[0], sTorus.center[1], sTorus.center[2]);
        LsEdge[] lsEdgeArray3 = new SVector3d(sTorus.u[0], sTorus.u[1], sTorus.u[2]);
        Serializable serializable = new SVector3d(sTorus.v[0], sTorus.v[1], sTorus.v[2]);
        SVector3d sVector3d2 = new SVector3d(sTorus.normal[0], sTorus.normal[1], sTorus.normal[2]);
        lsEdgeArray3.normalize();
        serializable.normalize();
        sVector3d2.normalize();
        Serializable serializable2 = new SVector3d();
        Object object = new SVector3d();
        double d2 = sTorus.getRadExtent() / (double)n3;
        int n4 = 0;
        while (n4 < sVector3dArray.length) {
            int n5;
            if (n4 == sVector3dArray.length - 1 && bl) {
                n5 = 0;
                while (n5 < sVector3dArray[n4].length) {
                    sVector3dArray[n4][n5] = sVector3dArray[0][n5];
                    ++n5;
                }
            } else {
                double d3 = sTorus.radStart + (double)n4 * d2;
                double d4 = Math.cos(d3);
                double d5 = Math.sin(d3);
                ((SVector3d)object).set((SVector3d)serializableArray2);
                sVector3d.set((SVector3d)lsEdgeArray3);
                sVector3d.scale(sTorus.radiusMajor * d4);
                serializableArray.set((SVector3d)serializable);
                serializableArray.scale(sTorus.radiusMajor * d5);
                ((SVector3d)object).add(sVector3d);
                ((SVector3d)object).add((SVector3d)serializableArray);
                ((SVector3d)serializable2).set(sVector3d);
                ((SVector3d)serializable2).add((SVector3d)serializableArray);
                ((SVector3d)serializable2).normalize();
                n5 = 0;
                while (n5 < sVector3dArray[n4].length) {
                    double d6 = (double)n5 * Math.PI * 2.0 / (double)n2;
                    double d7 = Math.cos(d6);
                    double d8 = Math.sin(d6);
                    sVector3d.set((SVector3d)serializable2);
                    sVector3d.scale(d7 * sTorus.radiusMinor);
                    serializableArray.set(sVector3d2);
                    serializableArray.scale(d8 * sTorus.radiusMinor);
                    sVector3d.add((SVector3d)serializableArray);
                    sVector3d.add((SVector3d)object);
                    SVector3d sVector3d3 = new SVector3d();
                    sVector3d3.set(sVector3d);
                    sVector3dArray[n4][n5] = sVector3d3;
                    ++n5;
                }
            }
            ++n4;
        }
        if (sMatrix4d != null) {
            n4 = 0;
            while (n4 < sVector3dArray.length) {
                if (!bl || n4 != sVector3dArray.length - 1) {
                    SVector3d[] sVector3dArray2 = sVector3dArray[n4];
                    int n6 = 0;
                    while (n6 < sVector3dArray2.length) {
                        sMatrix4d.translate(sVector3d, sVector3dArray2[n6].x, sVector3dArray2[n6].y, sVector3dArray2[n6].z);
                        sVector3dArray2[n6].set(sVector3d);
                        ++n6;
                    }
                }
                ++n4;
            }
        }
        int n7 = 0;
        while (n7 < n3 + 1) {
            int n8;
            serializableArray = sVector3dArray[n7];
            if (bl && n7 == n3) {
                n8 = 0;
                while (n8 < n2) {
                    lsEdgeArray[n7][n8] = lsEdgeArray[0][n8];
                    ++n8;
                }
            } else {
                n8 = 0;
                while (n8 < n2) {
                    int n9 = n8 == n2 - 1 ? 0 : n8 + 1;
                    serializable = LsFactory.createEdge((SVector3d)serializableArray[n8], (SVector3d)serializableArray[n9]);
                    if (n7 == 0 || n7 == n3) {
                        ((LsEdge)serializable).drawEdge = sTorus.dispEdge;
                    } else {
                        ((LsEdge)serializable).drawEdge = false;
                        ((LsEdge)serializable).drawEdgeBoundary = true;
                    }
                    lsEdgeArray[n7][n8] = serializable;
                    ++n8;
                }
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n3) {
            serializableArray = sVector3dArray[n7];
            serializableArray2 = sVector3dArray[n7 + 1];
            int n10 = 0;
            while (n10 < n2) {
                serializable = LsFactory.createEdge((SVector3d)serializableArray[n10], (SVector3d)serializableArray2[n10]);
                ((LsEdge)serializable).drawEdge = false;
                ((LsEdge)serializable).drawEdgeBoundary = true;
                lsEdgeArray2[n7][n10] = serializable;
                ++n10;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n3) {
            serializableArray = lsEdgeArray[n7];
            serializableArray2 = lsEdgeArray[n7 + 1];
            lsEdgeArray3 = lsEdgeArray2[n7];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n11 == n2 - 1 ? 0 : n11 + 1;
                serializable2 = LsFactory.createSurface();
                object = ((LsSurface)serializable2).getEdges();
                object.add(serializableArray[n11]);
                object.add(lsEdgeArray3[n11]);
                object.add(serializableArray2[n11]);
                object.add(lsEdgeArray3[n12]);
                list.add((LsSurface)serializable2);
                ((LsEdge)serializableArray[n11]).surface2 = serializable2;
                lsEdgeArray3[n11].surface2 = serializable2;
                ((LsEdge)serializableArray2[n11]).surface1 = serializable2;
                lsEdgeArray3[n12].surface1 = serializable2;
                lsSurfaceArray[n7][n11] = serializable2;
                ++n11;
            }
            ++n7;
        }
        if (!bl && sTorus.drawStart) {
            lsSurface = LsFactory.createSurface();
            List<LsEdge> list2 = lsSurface.getEdges();
            int n13 = 0;
            while (n13 < lsEdgeArray[0].length) {
                list2.add(lsEdgeArray[0][n13]);
                lsEdgeArray[0][n13].surface1 = lsSurface;
                ++n13;
            }
            list.add(lsSurface);
        }
        if (!bl && sTorus.drawEnd) {
            lsSurface2 = LsFactory.createSurface();
            List<LsEdge> list3 = lsSurface2.getEdges();
            int n14 = lsEdgeArray[n3].length - 1;
            while (n14 >= 0) {
                list3.add(lsEdgeArray[n3][n14]);
                lsEdgeArray[n3][n14].surface2 = lsSurface2;
                --n14;
            }
            list.add(lsSurface2);
        }
        lsShape.build();
        return lsShape;
    }

    private LsShape a(Primitive3D primitive3D, Color color, Color color2) {
        LsShape lsShape = LsFactory.createShape(primitive3D.drawBothSide);
        lsShape.copyID(primitive3D);
        lsShape.fillColor = color;
        lsShape.edgeColor = color2;
        lsShape.hatchPattern2d = primitive3D.hatchPattern2d;
        lsShape.projection2dVisible = primitive3D.projection2dVisible;
        lsShape.section2dVisible = primitive3D.section2dVisible;
        return lsShape;
    }

    private LsEdge[] a(SVector3d[] sVector3dArray) {
        int n = sVector3dArray.length;
        LsEdge[] lsEdgeArray = new LsEdge[n];
        int n2 = 0;
        while (n2 < n) {
            lsEdgeArray[n2] = LsFactory.createEdge(sVector3dArray[n2], sVector3dArray[n2 == n - 1 ? 0 : n2 + 1]);
            ++n2;
        }
        return lsEdgeArray;
    }

    private LsEdge[] a(SVector3d[] sVector3dArray, SVector3d[] sVector3dArray2) {
        int n = sVector3dArray.length;
        LsEdge[] lsEdgeArray = new LsEdge[n];
        int n2 = 0;
        while (n2 < n) {
            lsEdgeArray[n2] = LsFactory.createEdge(sVector3dArray[n2], sVector3dArray2[n2]);
            ++n2;
        }
        return lsEdgeArray;
    }

    private LsEdge[] a(SVector3d[] sVector3dArray, SVector3d sVector3d) {
        int n = sVector3dArray.length;
        LsEdge[] lsEdgeArray = new LsEdge[n];
        int n2 = 0;
        while (n2 < n) {
            lsEdgeArray[n2] = LsFactory.createEdge(sVector3dArray[n2], sVector3d);
            ++n2;
        }
        return lsEdgeArray;
    }

    private SVector3d[] a(double[][] dArray, boolean bl) {
        SVector3d[] sVector3dArray = new SVector3d[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            sVector3dArray[bl ? dArray.length - 1 - n : n] = new SVector3d(dArray[n][0], dArray[n][1], dArray[n][2]);
            ++n;
        }
        return sVector3dArray;
    }

    private SVector3d[] a(double[][] dArray, double[] dArray2, boolean bl) {
        SVector3d[] sVector3dArray = new SVector3d[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            SVector3d sVector3d = new SVector3d();
            sVector3d.x = dArray[n][0] + dArray2[0];
            sVector3d.y = dArray[n][1] + dArray2[1];
            sVector3d.z = dArray[n][2] + dArray2[2];
            sVector3dArray[bl ? dArray.length - 1 - n : n] = sVector3d;
            ++n;
        }
        return sVector3dArray;
    }
}

