/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.annot.EntityAnnot;
import org.seasar.doma.internal.apt.annot.MetamodelAnnot;
import org.seasar.doma.internal.apt.generator.EntityMetamodelGenerator;
import org.seasar.doma.internal.apt.generator.EntityTypeGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.JavaFileGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityMetaFactory;
import org.seasar.doma.internal.apt.processor.AbstractProcessor;
import org.seasar.doma.internal.util.AssertionUtil;

@SupportedAnnotationTypes(value={"org.seasar.doma.Entity"})
@SupportedOptions(value={"doma.entity.field.prefix", "doma.domain.converters", "doma.version.validation", "doma.resources.dir", "doma.lombok.Value", "doma.lombok.AllArgsConstructor", "doma.test", "doma.debug", "doma.config.path", "doma.metamodel.enabled", "doma.metamodel.prefix", "doma.metamodel.suffix"})
public class EntityProcessor
extends AbstractProcessor {
    public EntityProcessor() {
        super(Entity.class);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            EntityMetaFactory factory = new EntityMetaFactory(this.ctx);
            for (TypeElement typeElement2 : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement))) {
                this.handleTypeElement(typeElement2, __ -> {
                    EntityMeta meta = factory.createTypeElementMeta(typeElement2);
                    if (!meta.isError()) {
                        this.generateEntityType(typeElement2, meta);
                        if (this.isMetamodelEnabled(meta)) {
                            this.generateEntityMetamodel(typeElement2, meta);
                        }
                    }
                });
            }
        }
        return true;
    }

    private boolean isMetamodelEnabled(EntityMeta meta) {
        EntityAnnot entityAnnot = meta.getEntityAnnot();
        MetamodelAnnot metamodelAnnot = entityAnnot.getMetamodelValue();
        return metamodelAnnot != null || this.ctx.getOptions().isMetamodelEnabled();
    }

    private void generateEntityType(TypeElement typeElement, EntityMeta meta) {
        JavaFileGenerator<EntityMeta> generator = new JavaFileGenerator<EntityMeta>(this.ctx, this::createEntityTypeClassName, this::createEntityTypeGenerator);
        generator.generate(typeElement, meta);
    }

    private ClassName createEntityTypeClassName(TypeElement typeElement, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        return ClassNames.newEntityTypeClassName((CharSequence)binaryName);
    }

    private Generator createEntityTypeGenerator(ClassName className, Printer printer, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new EntityTypeGenerator(this.ctx, className, printer, meta);
    }

    private void generateEntityMetamodel(TypeElement typeElement, EntityMeta meta) {
        JavaFileGenerator<EntityMeta> generator = new JavaFileGenerator<EntityMeta>(this.ctx, this::createEntityMetamodelClassName, this::createEntityMetamodelGenerator);
        generator.generate(typeElement, meta);
    }

    private ClassName createEntityMetamodelClassName(TypeElement typeElement, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        EntityAnnot entityAnnot = meta.getEntityAnnot();
        MetamodelAnnot metamodelAnnot = entityAnnot.getMetamodelValue();
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        String prefix = this.ctx.getOptions().getMetamodelPrefix();
        String suffix = this.ctx.getOptions().getMetamodelSuffix();
        if (metamodelAnnot != null) {
            String prefixValue = metamodelAnnot.getPrefixValue();
            String suffixValue = metamodelAnnot.getSuffixValue();
            if (!prefixValue.isEmpty() || !suffixValue.isEmpty()) {
                prefix = prefixValue;
                suffix = suffixValue;
            }
        }
        return ClassNames.newEntityMetamodelClassNameBuilder((CharSequence)binaryName, (String)prefix, (String)suffix);
    }

    private Generator createEntityMetamodelGenerator(ClassName className, Printer printer, EntityMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        ClassName entityTypeName = this.createEntityTypeClassName(meta.getTypeElement(), meta);
        return new EntityMetamodelGenerator(this.ctx, className, printer, meta, entityTypeName);
    }
}

