/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.JavaFileGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.processor.AbstractProcessor;

public abstract class AbstractGeneratingProcessor<M extends TypeElementMeta>
extends AbstractProcessor {
    protected AbstractGeneratingProcessor(Class<? extends Annotation> supportedAnnotationType) {
        super(supportedAnnotationType);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            TypeElementMetaFactory<M> factory = this.createTypeElementMetaFactory();
            for (TypeElement typeElement2 : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement))) {
                this.handleTypeElement(typeElement2, t -> {
                    Object meta = factory.createTypeElementMeta(typeElement2);
                    if (!meta.isError()) {
                        this.generate(typeElement2, meta);
                    }
                });
            }
        }
        return true;
    }

    protected abstract TypeElementMetaFactory<M> createTypeElementMetaFactory();

    protected void generate(TypeElement typeElement, M meta) {
        JavaFileGenerator<TypeElementMeta> javaFileGenerator = new JavaFileGenerator<TypeElementMeta>(this.ctx, this::createClassName, this::createGenerator);
        javaFileGenerator.generate(typeElement, (TypeElementMeta)meta);
    }

    protected abstract ClassName createClassName(TypeElement var1, M var2);

    protected abstract Generator createGenerator(ClassName var1, Printer var2, M var3);
}

