/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.meta.query.AbstractCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractCreateQueryMetaFactory<M extends AbstractCreateQueryMeta>
extends AbstractQueryMetaFactory<M> {
    private final Class<?> returnClass;

    AbstractCreateQueryMetaFactory(Context ctx, TypeElement daoElement, ExecutableElement methodElement, Class<?> returnClass) {
        super(ctx, daoElement, methodElement);
        AssertionUtil.assertNotNull(returnClass);
        this.returnClass = returnClass;
    }

    @Override
    protected void doReturnType(M queryMeta) {
        QueryReturnMeta resultMeta = this.createReturnMeta((QueryMeta)queryMeta);
        ((AbstractQueryMeta)queryMeta).setReturnMeta(resultMeta);
        if (!this.returnClass.getName().equals(resultMeta.getCtType().getQualifiedName())) {
            throw new AptException((MessageResource)Message.DOMA4097, this.methodElement, new Object[]{this.returnClass.getName()});
        }
    }

    @Override
    protected void doParameters(M queryMeta) {
        List<? extends VariableElement> params = this.methodElement.getParameters();
        int size = params.size();
        if (size != 0) {
            throw new AptException((MessageResource)Message.DOMA4078, this.methodElement, new Object[0]);
        }
    }
}

