/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.annot.EntityAnnot;
import org.seasar.doma.internal.apt.annot.TableAnnot;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityConstructorMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.OriginalStatesMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.NullEntityListener;

public class EntityMeta
implements TypeElementMeta {
    private final List<EntityPropertyMeta> allPropertyMetas = new ArrayList<EntityPropertyMeta>();
    private final List<EntityPropertyMeta> idPropertyMetas = new ArrayList<EntityPropertyMeta>();
    private final EntityAnnot entityAnnot;
    private final TypeElement typeElement;
    private final TypeMirror type;
    private boolean immutable;
    private NamingType namingType;
    private TypeElement entityListenerElement;
    private boolean genericEntityListener;
    private TableAnnot tableAnnot;
    private EntityPropertyMeta versionPropertyMeta;
    private EntityPropertyMeta tenantIdPropertyMeta;
    private EntityPropertyMeta generatedIdPropertyMeta;
    private String entityName;
    private OriginalStatesMeta originalStatesMeta;
    private EntityConstructorMeta constructorMeta;
    private boolean error;

    public EntityMeta(EntityAnnot entityAnnot, TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)entityAnnot);
        this.entityAnnot = entityAnnot;
        this.typeElement = typeElement;
        this.type = typeElement.asType();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public EntityAnnot getEntityAnnot() {
        return this.entityAnnot;
    }

    public NamingType getNamingType() {
        return this.namingType;
    }

    public void setNamingType(NamingType namingType) {
        this.namingType = namingType;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public void setTableAnnot(TableAnnot tableAnnot) {
        this.tableAnnot = tableAnnot;
    }

    public void addPropertyMeta(EntityPropertyMeta propertyMeta) {
        AssertionUtil.assertNotNull((Object)propertyMeta);
        this.allPropertyMetas.add(propertyMeta);
        if (propertyMeta.isId()) {
            this.idPropertyMetas.add(propertyMeta);
            if (propertyMeta.getIdGeneratorMeta() != null) {
                this.generatedIdPropertyMeta = propertyMeta;
            }
        }
        if (propertyMeta.isVersion()) {
            this.versionPropertyMeta = propertyMeta;
        }
        if (propertyMeta.isTenantId()) {
            this.tenantIdPropertyMeta = propertyMeta;
        }
    }

    public List<EntityPropertyMeta> getAllPropertyMetas() {
        if (this.constructorMeta == null) {
            return this.allPropertyMetas;
        }
        return this.constructorMeta.getEntityPropertyMetas();
    }

    public List<EntityPropertyMeta> getIdPropertyMetas() {
        return this.idPropertyMetas;
    }

    public boolean hasVersionPropertyMeta() {
        return this.versionPropertyMeta != null;
    }

    public EntityPropertyMeta getVersionPropertyMeta() {
        return this.versionPropertyMeta;
    }

    public boolean hasTenantIdPropertyMeta() {
        return this.tenantIdPropertyMeta != null;
    }

    public EntityPropertyMeta getTenantIdPropertyMeta() {
        return this.tenantIdPropertyMeta;
    }

    public boolean hasGeneratedIdPropertyMeta() {
        return this.generatedIdPropertyMeta != null;
    }

    public EntityPropertyMeta getGeneratedIdPropertyMeta() {
        return this.generatedIdPropertyMeta;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public boolean hasOriginalStatesMeta() {
        return this.originalStatesMeta != null;
    }

    public OriginalStatesMeta getOriginalStatesMeta() {
        return this.originalStatesMeta;
    }

    public void setOriginalStatesMeta(OriginalStatesMeta originalStatesMeta) {
        this.originalStatesMeta = originalStatesMeta;
    }

    public void setConstructorMeta(EntityConstructorMeta constructorMeta) {
        this.constructorMeta = constructorMeta;
    }

    public TypeElement getEntityListenerElement() {
        return this.entityListenerElement;
    }

    public void setEntityListenerElement(TypeElement entityListenerElement) {
        this.entityListenerElement = entityListenerElement;
    }

    public boolean isGenericEntityListener() {
        return this.genericEntityListener;
    }

    public void setGenericEntityListener(boolean genericEntityListener) {
        this.genericEntityListener = genericEntityListener;
    }

    public boolean isNullEntityListener() {
        return this.entityListenerElement.getQualifiedName().contentEquals(NullEntityListener.class.getName());
    }

    public String getCatalogName() {
        return this.tableAnnot != null ? this.tableAnnot.getCatalogValue() : "";
    }

    public String getSchemaName() {
        return this.tableAnnot != null ? this.tableAnnot.getSchemaValue() : "";
    }

    public String getTableName() {
        return this.tableAnnot != null ? this.tableAnnot.getNameValue() : "";
    }

    public boolean isQuoteRequired() {
        return this.tableAnnot != null && this.tableAnnot.getQuoteValue();
    }

    public boolean isAbstract() {
        return this.typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean hasEmbeddedProperties() {
        return this.allPropertyMetas.stream().anyMatch(EntityPropertyMeta::isEmbedded);
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }
}

