/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class ColumnAnnot
extends AbstractAnnot {
    public static final String INSERTABLE = "insertable";
    public static final String UPDATABLE = "updatable";
    public static final String QUOTE = "quote";
    public static final String NAME = "name";
    private final AnnotationValue name;
    private final AnnotationValue insertable;
    private final AnnotationValue updatable;
    private final AnnotationValue quote;

    ColumnAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.name = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)NAME);
        this.insertable = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)INSERTABLE);
        this.updatable = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)UPDATABLE);
        this.quote = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)QUOTE);
    }

    public AnnotationValue getName() {
        return this.name;
    }

    public AnnotationValue getInsertable() {
        return this.insertable;
    }

    public AnnotationValue getUpdatable() {
        return this.updatable;
    }

    public AnnotationValue getQuote() {
        return this.quote;
    }

    public String getNameValue() {
        String value = AnnotationValueUtil.toString(this.name);
        if (value == null) {
            throw new AptIllegalStateException(NAME);
        }
        return value;
    }

    public boolean getInsertableValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.insertable);
        if (value == null) {
            throw new AptIllegalStateException(INSERTABLE);
        }
        return value;
    }

    public boolean getUpdatableValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.updatable);
        if (value == null) {
            throw new AptIllegalStateException(UPDATABLE);
        }
        return value;
    }

    public boolean getQuoteValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.quote);
        if (value == null) {
            throw new AptIllegalStateException(QUOTE);
        }
        return value;
    }
}

