/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class AllArgsConstructorAnnot
extends AbstractAnnot {
    private static final String STATIC_NAME = "staticName";
    private static final String ACCESS = "access";
    private final AnnotationValue staticName;
    private final AnnotationValue access;

    AllArgsConstructorAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.staticName = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)STATIC_NAME);
        this.access = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)ACCESS);
    }

    public AnnotationValue getStaticName() {
        return this.staticName;
    }

    public AnnotationValue getAccess() {
        return this.access;
    }

    public String getStaticNameValue() {
        String value = AnnotationValueUtil.toString(this.staticName);
        if (value == null) {
            throw new AptIllegalStateException(STATIC_NAME);
        }
        return value;
    }

    public boolean isAccessPrivate() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.access);
        if (enumConstant == null) {
            throw new AptIllegalStateException(ACCESS);
        }
        return "PRIVATE".equals(enumConstant.getSimpleName().toString());
    }

    public boolean isAccessNone() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.access);
        if (enumConstant == null) {
            throw new AptIllegalStateException(ACCESS);
        }
        return "NONE".equals(enumConstant.getSimpleName().toString());
    }
}

