/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.util.AssertionUtil;

public class Resources {
    private final Filer filer;
    private final String resourcesDir;

    Resources(Context ctx, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)env);
        this.filer = env.getFiler();
        this.resourcesDir = env.getOptions().get("doma.resources.dir");
    }

    public JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        return this.filer.createSourceFile(name, originatingElements);
    }

    public FileObject getResource(String relativePath) throws IOException {
        AssertionUtil.assertNotNull((Object)relativePath);
        if (this.resourcesDir != null) {
            Path path = Paths.get(this.resourcesDir, relativePath);
            return new FileObjectImpl(path);
        }
        return this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", relativePath);
    }

    protected static class FileObjectImpl
    implements FileObject {
        private final Path path;

        FileObjectImpl(Path path) {
            this.path = path;
        }

        @Override
        public URI toUri() {
            return this.path.toUri();
        }

        @Override
        public String getName() {
            return this.path.toString();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public OutputStream openOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public boolean delete() {
            return false;
        }
    }
}

