/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.seasar.doma.jdbc.type.AbstractJdbcType;

public class LocalDateTimeType
extends AbstractJdbcType<LocalDateTime> {
    public LocalDateTimeType() {
        super(93);
    }

    @Override
    public LocalDateTime doGetValue(ResultSet resultSet, int index) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(index);
        return timestamp != null ? timestamp.toLocalDateTime() : null;
    }

    @Override
    protected void doSetValue(PreparedStatement preparedStatement, int index, LocalDateTime value) throws SQLException {
        preparedStatement.setTimestamp(index, Timestamp.valueOf(value));
    }

    @Override
    protected LocalDateTime doGetValue(CallableStatement callableStatement, int index) throws SQLException {
        Timestamp timestamp = callableStatement.getTimestamp(index);
        return timestamp != null ? timestamp.toLocalDateTime() : null;
    }

    @Override
    protected String doConvertToLogFormat(LocalDateTime value) {
        return "'" + Timestamp.valueOf(value) + "'";
    }
}

