/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.dialect.Mssql2008ForUpdateTransformer;
import org.seasar.doma.internal.jdbc.dialect.Mssql2008PagingTransformer;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.ScriptBlockContext;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.option.ForUpdateOption;
import org.seasar.doma.jdbc.criteria.query.AliasManager;
import org.seasar.doma.jdbc.criteria.query.CriteriaBuilder;
import org.seasar.doma.jdbc.dialect.StandardDialect;

public class Mssql2008Dialect
extends StandardDialect {
    protected static final int UNIQUE_CONSTRAINT_VIOLATION_ERROR_CODE = 2627;
    protected static final char OPEN_QUOTE = '[';
    protected static final char CLOSE_QUOTE = ']';

    public Mssql2008Dialect() {
        this(new Mssql2008JdbcMappingVisitor(), new Mssql2008SqlLogFormattingVisitor(), new Mssql2008ExpressionFunctions());
    }

    public Mssql2008Dialect(JdbcMappingVisitor jdbcMappingVisitor) {
        this(jdbcMappingVisitor, new Mssql2008SqlLogFormattingVisitor(), new Mssql2008ExpressionFunctions());
    }

    public Mssql2008Dialect(SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(new Mssql2008JdbcMappingVisitor(), sqlLogFormattingVisitor, new Mssql2008ExpressionFunctions());
    }

    public Mssql2008Dialect(ExpressionFunctions expressionFunctions) {
        this(new Mssql2008JdbcMappingVisitor(), new Mssql2008SqlLogFormattingVisitor(), expressionFunctions);
    }

    public Mssql2008Dialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(jdbcMappingVisitor, sqlLogFormattingVisitor, new Mssql2008ExpressionFunctions());
    }

    public Mssql2008Dialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor, ExpressionFunctions expressionFunctions) {
        super(jdbcMappingVisitor, sqlLogFormattingVisitor, expressionFunctions);
    }

    @Override
    public String getName() {
        return "mssql";
    }

    @Override
    protected SqlNode toForUpdateSqlNode(SqlNode sqlNode, SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        Mssql2008ForUpdateTransformer transformer = new Mssql2008ForUpdateTransformer(forUpdateType, waitSeconds, aliases);
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toPagingSqlNode(SqlNode sqlNode, long offset, long limit) {
        Mssql2008PagingTransformer transformer = new Mssql2008PagingTransformer(offset, limit);
        return transformer.transform(sqlNode);
    }

    @Override
    public boolean isUniqueConstraintViolated(SQLException sqlException) {
        if (sqlException == null) {
            throw new DomaNullPointerException("sqlException");
        }
        int errorCode = this.getErrorCode(sqlException);
        return errorCode == 2627;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate(SelectForUpdateType type, boolean withTargets) {
        return (type == SelectForUpdateType.NORMAL || type == SelectForUpdateType.NOWAIT) && !withTargets;
    }

    @Override
    public boolean supportsAutoGeneratedKeys() {
        return true;
    }

    @Override
    public boolean supportsAliasInDeleteClause() {
        return true;
    }

    @Override
    public boolean supportsAliasInUpdateClause() {
        return true;
    }

    @Override
    public String getScriptBlockDelimiter() {
        return "GO";
    }

    @Override
    public String applyQuote(String name) {
        return '[' + name + ']';
    }

    @Override
    public ScriptBlockContext createScriptBlockContext() {
        return new Mssql2008ScriptBlockContext();
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return new Mssql2008CriteriaBuilder();
    }

    public static class Mssql2008CriteriaBuilder
    extends StandardDialect.StandardCriteriaBuilder {
        @Override
        public void concat(PreparedSqlBuilder buf, Runnable leftOperand, Runnable rightOperand) {
            buf.appendSql("(");
            leftOperand.run();
            buf.appendSql(" + ");
            rightOperand.run();
            buf.appendSql(")");
        }

        @Override
        public void lockWithTableHint(final PreparedSqlBuilder buf, ForUpdateOption option, Consumer<PropertyMetamodel<?>> column) {
            option.accept(new ForUpdateOption.Visitor(){

                @Override
                public void visit(ForUpdateOption.Basic basic) {
                    buf.appendSql(" with (updlock, rowlock)");
                }

                @Override
                public void visit(ForUpdateOption.NoWait noWait) {
                    buf.appendSql(" with (updlock, rowlock, nowait)");
                }

                @Override
                public void visit(ForUpdateOption.Wait wait) {
                    buf.appendSql(" with (updlock, rowlock)");
                }
            });
        }

        @Override
        public void forUpdate(PreparedSqlBuilder buf, ForUpdateOption option, Consumer<PropertyMetamodel<?>> column, AliasManager aliasManager) {
        }
    }

    public static class Mssql2008ScriptBlockContext
    extends StandardDialect.StandardScriptBlockContext {
        protected Mssql2008ScriptBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "trigger"));
            this.sqlBlockStartKeywordsList.add(Collections.singletonList("declare"));
            this.sqlBlockStartKeywordsList.add(Collections.singletonList("begin"));
        }
    }

    public static class Mssql2008ExpressionFunctions
    extends StandardDialect.StandardExpressionFunctions {
        private static final char[] DEFAULT_WILDCARDS = new char[]{'%', '_', '['};

        public Mssql2008ExpressionFunctions() {
            super(DEFAULT_WILDCARDS);
        }

        public Mssql2008ExpressionFunctions(char[] wildcards) {
            super(wildcards);
        }

        protected Mssql2008ExpressionFunctions(char escapeChar, char[] wildcards) {
            super(escapeChar, wildcards);
        }
    }

    public static class Mssql2008SqlLogFormattingVisitor
    extends StandardDialect.StandardSqlLogFormattingVisitor {
    }

    public static class Mssql2008JdbcMappingVisitor
    extends StandardDialect.StandardJdbcMappingVisitor {
    }
}

