/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.dialect.Db2ForUpdateTransformer;
import org.seasar.doma.internal.jdbc.dialect.Db2PagingTransformer;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.ScriptBlockContext;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.option.ForUpdateOption;
import org.seasar.doma.jdbc.criteria.query.AliasManager;
import org.seasar.doma.jdbc.criteria.query.CriteriaBuilder;
import org.seasar.doma.jdbc.dialect.StandardDialect;

public class Db2Dialect
extends StandardDialect {
    protected static final String UNIQUE_CONSTRAINT_VIOLATION_STATE_CODE = "23505";

    public Db2Dialect() {
        this(new Db2JdbcMappingVisitor(), new Db2SqlLogFormattingVisitor(), new Db2ExpressionFunctions());
    }

    public Db2Dialect(JdbcMappingVisitor jdbcMappingVisitor) {
        this(jdbcMappingVisitor, new Db2SqlLogFormattingVisitor(), new Db2ExpressionFunctions());
    }

    public Db2Dialect(SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(new Db2JdbcMappingVisitor(), sqlLogFormattingVisitor, new Db2ExpressionFunctions());
    }

    public Db2Dialect(ExpressionFunctions expressionFunctions) {
        this(new Db2JdbcMappingVisitor(), new Db2SqlLogFormattingVisitor(), expressionFunctions);
    }

    public Db2Dialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(jdbcMappingVisitor, sqlLogFormattingVisitor, new Db2ExpressionFunctions());
    }

    public Db2Dialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor, ExpressionFunctions expressionFunctions) {
        super(jdbcMappingVisitor, sqlLogFormattingVisitor, expressionFunctions);
    }

    @Override
    public String getName() {
        return "db2";
    }

    @Override
    protected SqlNode toForUpdateSqlNode(SqlNode sqlNode, SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        Db2ForUpdateTransformer transformer = new Db2ForUpdateTransformer(forUpdateType, waitSeconds, aliases);
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toPagingSqlNode(SqlNode sqlNode, long offset, long limit) {
        Db2PagingTransformer transformer = new Db2PagingTransformer(offset, limit);
        return transformer.transform(sqlNode);
    }

    @Override
    public boolean isUniqueConstraintViolated(SQLException sqlException) {
        if (sqlException == null) {
            throw new DomaNullPointerException("sqlException");
        }
        String state = this.getSQLState(sqlException);
        return UNIQUE_CONSTRAINT_VIOLATION_STATE_CODE.equals(state);
    }

    @Override
    public PreparedSql getSequenceNextValSql(String qualifiedSequenceName, long allocationSize) {
        if (qualifiedSequenceName == null) {
            throw new DomaNullPointerException("qualifiedSequenceName");
        }
        String rawSql = "values nextval for " + qualifiedSequenceName;
        return new PreparedSql(SqlKind.SELECT, rawSql, rawSql, null, Collections.emptyList(), SqlLogType.FORMATTED);
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate(SelectForUpdateType type, boolean withTargets) {
        return type == SelectForUpdateType.NORMAL && !withTargets;
    }

    @Override
    public boolean supportsAutoGeneratedKeys() {
        return true;
    }

    @Override
    public String getScriptBlockDelimiter() {
        return "@";
    }

    @Override
    public ScriptBlockContext createScriptBlockContext() {
        return new Db2ScriptBlockContext();
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return new Db2CriteriaBuilder();
    }

    public static class Db2CriteriaBuilder
    extends StandardDialect.StandardCriteriaBuilder {
        @Override
        public void forUpdate(final PreparedSqlBuilder buf, ForUpdateOption option, Consumer<PropertyMetamodel<?>> column, AliasManager aliasManager) {
            option.accept(new ForUpdateOption.Visitor(){

                @Override
                public void visit(ForUpdateOption.Basic basic) {
                    this.appendSql();
                }

                @Override
                public void visit(ForUpdateOption.NoWait wait) {
                    this.appendSql();
                }

                @Override
                public void visit(ForUpdateOption.Wait noWait) {
                    this.appendSql();
                }

                private void appendSql() {
                    buf.appendSql(" for update with rs");
                }
            });
        }
    }

    public static class Db2ScriptBlockContext
    extends StandardDialect.StandardScriptBlockContext {
        protected Db2ScriptBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "trigger"));
        }
    }

    public static class Db2ExpressionFunctions
    extends StandardDialect.StandardExpressionFunctions {
        private static final char[] DEFAULT_WILDCARDS = new char[]{'%', '_', '\uff05', '\uff3f'};

        public Db2ExpressionFunctions() {
            super(DEFAULT_WILDCARDS);
        }

        public Db2ExpressionFunctions(char[] wildcards) {
            super(wildcards);
        }

        protected Db2ExpressionFunctions(char escapeChar, char[] wildcards) {
            super(escapeChar, wildcards);
        }
    }

    public static class Db2SqlLogFormattingVisitor
    extends StandardDialect.StandardSqlLogFormattingVisitor {
    }

    public static class Db2JdbcMappingVisitor
    extends StandardDialect.StandardJdbcMappingVisitor {
    }
}

