/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Objects;
import java.util.function.Consumer;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.UpdateCommand;
import org.seasar.doma.jdbc.criteria.context.UpdateContext;
import org.seasar.doma.jdbc.criteria.context.UpdateSettings;
import org.seasar.doma.jdbc.criteria.declaration.UpdateDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.WhereDeclaration;
import org.seasar.doma.jdbc.criteria.query.CriteriaQuery;
import org.seasar.doma.jdbc.criteria.query.UpdateBuilder;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EmptyWhereClauseException;
import org.seasar.doma.jdbc.criteria.statement.Statement;

public class NativeSqlUpdateTerminal
extends AbstractStatement<NativeSqlUpdateTerminal, Integer> {
    private final UpdateDeclaration declaration;

    public NativeSqlUpdateTerminal(Config config, UpdateDeclaration declaration) {
        super(Objects.requireNonNull(config));
        Objects.requireNonNull(declaration);
        this.declaration = declaration;
    }

    public Statement<Integer> where(Consumer<WhereDeclaration> block) {
        Objects.requireNonNull(block);
        this.declaration.where(block);
        return this;
    }

    @Override
    public Integer execute() {
        return (Integer)super.execute();
    }

    @Override
    protected Command<Integer> createCommand() {
        final UpdateContext context = this.declaration.getContext();
        final UpdateSettings settings = context.getSettings();
        UpdateBuilder builder = new UpdateBuilder(this.config, context, this.createCommenter(settings.getComment()), settings.getSqlLogType());
        PreparedSql sql = builder.build();
        CriteriaQuery query = new CriteriaQuery(this.config, sql, this.getClass().getName(), "execute");
        query.setQueryTimeout(settings.getQueryTimeout());
        return new UpdateCommand(query){

            @Override
            public Integer execute() {
                if (!settings.getAllowEmptyWhere() && context.where.isEmpty()) {
                    throw new EmptyWhereClauseException(this.sql);
                }
                return super.execute();
            }
        };
    }
}

