/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.ResultSetHandler;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.context.SelectSettings;
import org.seasar.doma.jdbc.criteria.declaration.SelectFromDeclaration;
import org.seasar.doma.jdbc.criteria.query.CriteriaQuery;
import org.seasar.doma.jdbc.criteria.query.SelectBuilder;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EmptyWhereClauseException;

public class NativeSqlSelectTerminal<RESULT>
extends AbstractStatement<NativeSqlSelectTerminal<RESULT>, RESULT> {
    private final SelectFromDeclaration declaration;
    private final ResultSetHandler<RESULT> resultSetHandler;

    public NativeSqlSelectTerminal(Config config, SelectFromDeclaration declaration, ResultSetHandler<RESULT> resultSetHandler) {
        super(Objects.requireNonNull(config));
        this.declaration = Objects.requireNonNull(declaration);
        this.resultSetHandler = Objects.requireNonNull(resultSetHandler);
    }

    @Override
    public RESULT execute() {
        return super.execute();
    }

    @Override
    protected Command<RESULT> createCommand() {
        final SelectContext context = this.declaration.getContext();
        final SelectSettings settings = context.getSettings();
        SelectBuilder builder = new SelectBuilder(this.config, context, this.createCommenter(settings.getComment()), settings.getSqlLogType());
        PreparedSql sql = builder.build();
        CriteriaQuery query = new CriteriaQuery(this.config, sql, this.getClass().getName(), "execute");
        query.setFetchSize(settings.getQueryTimeout());
        query.setMaxRows(settings.getMaxRows());
        query.setQueryTimeout(settings.getQueryTimeout());
        return new SelectCommand<RESULT>(query, this.resultSetHandler){

            @Override
            public RESULT execute() {
                if (!settings.getAllowEmptyWhere() && context.where.isEmpty()) {
                    throw new EmptyWhereClauseException(this.sql);
                }
                return super.execute();
            }
        };
    }
}

