/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Result;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.UpdateCommand;
import org.seasar.doma.jdbc.criteria.context.UpdateSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoUpdateQuery;
import org.seasar.doma.jdbc.query.Query;

public class EntityqlUpdateStatement<ENTITY>
extends AbstractStatement<EntityqlUpdateStatement<ENTITY>, Result<ENTITY>> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final ENTITY entity;
    private final UpdateSettings settings;

    public EntityqlUpdateStatement(Config config, EntityMetamodel<ENTITY> entityMetamodel, ENTITY entity, UpdateSettings settings) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entity = Objects.requireNonNull(entity);
        this.settings = Objects.requireNonNull(settings);
    }

    @Override
    public Result<ENTITY> execute() {
        return (Result)super.execute();
    }

    @Override
    protected Command<Result<ENTITY>> createCommand() {
        EntityType<ENTITY> entityType = this.entityMetamodel.asType();
        final AutoUpdateQuery<ENTITY> query = this.config.getQueryImplementors().createAutoUpdateQuery(EXECUTE_METHOD, entityType);
        query.setConfig(this.config);
        query.setEntity(this.entity);
        query.setMethod(EXECUTE_METHOD);
        query.setCallerClassName(this.getClass().getName());
        query.setCallerMethodName("execute");
        query.setQueryTimeout(this.settings.getQueryTimeout());
        query.setSqlLogType(this.settings.getSqlLogType());
        query.setNullExcluded(this.settings.getExcludeNull());
        query.setVersionIgnored(this.settings.getIgnoreVersion());
        query.setIncludedPropertyNames(new String[0]);
        query.setExcludedPropertyNames(new String[0]);
        query.setUnchangedPropertyIncluded(false);
        query.setOptimisticLockExceptionSuppressed(this.settings.getSuppressOptimisticLockException());
        query.setMessage(this.settings.getComment());
        query.prepare();
        final UpdateCommand command = this.config.getCommandImplementors().createUpdateCommand(EXECUTE_METHOD, query);
        return new Command<Result<ENTITY>>(){

            @Override
            public Query getQuery() {
                return query;
            }

            @Override
            public Result<ENTITY> execute() {
                int count = command.execute();
                query.complete();
                return new Result(count, query.getEntity());
            }
        };
    }
}

