/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.declaration.JoinDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.OrderByNameDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.SelectFromDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.WhereDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.option.AssociationOption;
import org.seasar.doma.jdbc.criteria.option.DistinctOption;
import org.seasar.doma.jdbc.criteria.option.ForUpdateOption;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlSelectTerminal;
import org.seasar.doma.jdbc.criteria.statement.Listable;

public class EntityqlSelectStarting<ENTITY>
extends AbstractStatement<EntityqlSelectStarting<ENTITY>, List<ENTITY>>
implements Listable<ENTITY> {
    private final SelectFromDeclaration declaration;
    private final EntityMetamodel<ENTITY> entityMetamodel;

    public EntityqlSelectStarting(Config config, SelectFromDeclaration declaration, EntityMetamodel<ENTITY> entityMetamodel) {
        super(Objects.requireNonNull(config));
        this.declaration = Objects.requireNonNull(declaration);
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
    }

    public EntityqlSelectStarting<ENTITY> distinct() {
        this.declaration.distinct(DistinctOption.basic());
        return this;
    }

    public EntityqlSelectStarting<ENTITY> distinct(DistinctOption distinctOption) {
        Objects.requireNonNull(distinctOption);
        this.declaration.distinct(distinctOption);
        return this;
    }

    public EntityqlSelectStarting<ENTITY> innerJoin(EntityMetamodel<?> entityMetamodel, Consumer<JoinDeclaration> block) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(block);
        this.declaration.innerJoin(entityMetamodel, block);
        return this;
    }

    public EntityqlSelectStarting<ENTITY> leftJoin(EntityMetamodel<?> entityMetamodel, Consumer<JoinDeclaration> block) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(block);
        this.declaration.leftJoin(entityMetamodel, block);
        return this;
    }

    public <ENTITY1, ENTITY2> EntityqlSelectStarting<ENTITY> associate(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiConsumer<ENTITY1, ENTITY2> associator) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        this.declaration.associate(first, second, associator, AssociationOption.mandatory());
        return this;
    }

    public <ENTITY1, ENTITY2> EntityqlSelectStarting<ENTITY> associate(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiConsumer<ENTITY1, ENTITY2> associator, AssociationOption option) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        Objects.requireNonNull(option);
        this.declaration.associate(first, second, associator, option);
        return this;
    }

    public <ENTITY1, ENTITY2> EntityqlSelectStarting<ENTITY> associateWith(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiFunction<ENTITY1, ENTITY2, ENTITY1> associator) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        this.declaration.associateWith(first, second, associator, AssociationOption.mandatory());
        return this;
    }

    public <ENTITY1, ENTITY2> EntityqlSelectStarting<ENTITY> associateWith(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiFunction<ENTITY1, ENTITY2, ENTITY1> associator, AssociationOption option) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        Objects.requireNonNull(option);
        this.declaration.associateWith(first, second, associator, option);
        return this;
    }

    public EntityqlSelectStarting<ENTITY> where(Consumer<WhereDeclaration> block) {
        Objects.requireNonNull(block);
        this.declaration.where(block);
        return this;
    }

    public EntityqlSelectStarting<ENTITY> orderBy(Consumer<OrderByNameDeclaration> block) {
        Objects.requireNonNull(block);
        this.declaration.orderBy(block);
        return this;
    }

    public EntityqlSelectStarting<ENTITY> limit(Integer limit) {
        this.declaration.limit(limit);
        return this;
    }

    public EntityqlSelectStarting<ENTITY> offset(Integer offset) {
        this.declaration.offset(offset);
        return this;
    }

    public EntityqlSelectStarting<ENTITY> forUpdate() {
        this.declaration.forUpdate(ForUpdateOption.basic(new PropertyMetamodel[0]));
        return this;
    }

    public EntityqlSelectStarting<ENTITY> forUpdate(ForUpdateOption option) {
        Objects.requireNonNull(option);
        this.declaration.forUpdate(option);
        return this;
    }

    public <RESULT> EntityqlSelectTerminal<RESULT> select(EntityMetamodel<RESULT> entityMetamodel) {
        Objects.requireNonNull(entityMetamodel);
        this.declaration.select(entityMetamodel);
        return new EntityqlSelectTerminal<RESULT>(this.config, this.declaration, entityMetamodel);
    }

    public <RESULT> EntityqlSelectTerminal<RESULT> selectTo(EntityMetamodel<RESULT> entityMetamodel, PropertyMetamodel<?> ... propertyMetamodels) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(propertyMetamodels);
        this.declaration.selectTo(entityMetamodel, Arrays.asList(propertyMetamodels));
        return new EntityqlSelectTerminal<RESULT>(this.config, this.declaration, entityMetamodel);
    }

    @Override
    protected Command<List<ENTITY>> createCommand() {
        EntityqlSelectTerminal<ENTITY> terminal = new EntityqlSelectTerminal<ENTITY>(this.config, this.declaration, this.entityMetamodel);
        return terminal.createCommand();
    }
}

