/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.BatchResult;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.command.BatchInsertCommand;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EmptySql;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoBatchInsertQuery;
import org.seasar.doma.jdbc.query.Query;

public class EntityqlBatchInsertStatement<ENTITY>
extends AbstractStatement<EntityqlBatchInsertStatement<ENTITY>, BatchResult<ENTITY>> {
    private static final EmptySql EMPTY_SQL = new EmptySql(SqlKind.BATCH_INSERT);
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final List<ENTITY> entities;
    private final InsertSettings settings;

    public EntityqlBatchInsertStatement(Config config, EntityMetamodel<ENTITY> entityMetamodel, List<ENTITY> entities, InsertSettings settings) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entities = Objects.requireNonNull(entities);
        this.settings = Objects.requireNonNull(settings);
    }

    @Override
    public BatchResult<ENTITY> execute() {
        return (BatchResult)super.execute();
    }

    @Override
    protected Command<BatchResult<ENTITY>> createCommand() {
        EntityType<ENTITY> entityType = this.entityMetamodel.asType();
        final AutoBatchInsertQuery<ENTITY> query = this.config.getQueryImplementors().createAutoBatchInsertQuery(EXECUTE_METHOD, entityType);
        query.setMethod(EXECUTE_METHOD);
        query.setConfig(this.config);
        query.setEntities(this.entities);
        query.setCallerClassName(this.getClass().getName());
        query.setCallerMethodName("execute");
        query.setQueryTimeout(this.settings.getQueryTimeout());
        query.setBatchSize(this.settings.getBatchSize());
        query.setSqlLogType(this.settings.getSqlLogType());
        query.setIncludedPropertyNames(new String[0]);
        query.setExcludedPropertyNames(new String[0]);
        query.setMessage(this.settings.getComment());
        query.prepare();
        final BatchInsertCommand command = this.config.getCommandImplementors().createBatchInsertCommand(EXECUTE_METHOD, query);
        return new Command<BatchResult<ENTITY>>(){

            @Override
            public Query getQuery() {
                return query;
            }

            @Override
            public BatchResult<ENTITY> execute() {
                int[] counts = command.execute();
                query.complete();
                return new BatchResult(counts, query.getEntities());
            }
        };
    }

    @Override
    public Sql<?> asSql() {
        if (this.entities.isEmpty()) {
            return EMPTY_SQL;
        }
        return super.asSql();
    }
}

