/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.criteria.context.Criterion;
import org.seasar.doma.jdbc.criteria.context.Operand;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.entity.EntityPropertyType;

public class CaseExpression<RESULT>
implements PropertyMetamodel<RESULT> {
    public final PropertyMetamodel<RESULT> otherwise;
    public final List<Pair<Criterion, Operand>> criterionList = new ArrayList<Pair<Criterion, Operand>>();

    public CaseExpression(PropertyMetamodel<RESULT> otherwise) {
        this.otherwise = Objects.requireNonNull(otherwise);
    }

    @Override
    public Class<?> asClass() {
        return this.otherwise.asClass();
    }

    @Override
    public EntityPropertyType<?, ?> asType() {
        return this.otherwise.asType();
    }

    @Override
    public String getName() {
        return this.otherwise.getName();
    }

    @Override
    public void accept(PropertyMetamodel.Visitor visitor) {
        if (visitor instanceof Visitor) {
            Visitor v = (Visitor)((Object)visitor);
            v.visit(this);
        }
    }

    public static interface Visitor {
        public void visit(CaseExpression<?> var1);
    }

    public class Declaration {
        public <PROPERTY> void eq(PropertyMetamodel<PROPERTY> left, PropertyMetamodel<PROPERTY> right, PropertyMetamodel<RESULT> then) {
            Objects.requireNonNull(left, "left");
            Objects.requireNonNull(right, "right");
            Objects.requireNonNull(then, "then");
            this.add(Criterion.Eq::new, left, right, then);
        }

        public <PROPERTY> void ne(PropertyMetamodel<PROPERTY> left, PropertyMetamodel<PROPERTY> right, PropertyMetamodel<RESULT> then) {
            Objects.requireNonNull(left, "left");
            Objects.requireNonNull(right, "right");
            Objects.requireNonNull(then, "then");
            this.add(Criterion.Ne::new, left, right, then);
        }

        public <PROPERTY> void ge(PropertyMetamodel<PROPERTY> left, PropertyMetamodel<PROPERTY> right, PropertyMetamodel<RESULT> then) {
            Objects.requireNonNull(left, "left");
            Objects.requireNonNull(right, "right");
            Objects.requireNonNull(then, "then");
            this.add(Criterion.Ge::new, left, right, then);
        }

        public <PROPERTY> void gt(PropertyMetamodel<PROPERTY> left, PropertyMetamodel<PROPERTY> right, PropertyMetamodel<RESULT> then) {
            Objects.requireNonNull(left, "left");
            Objects.requireNonNull(right, "right");
            Objects.requireNonNull(then, "then");
            this.add(Criterion.Gt::new, left, right, then);
        }

        public <PROPERTY> void le(PropertyMetamodel<PROPERTY> left, PropertyMetamodel<PROPERTY> right, PropertyMetamodel<RESULT> then) {
            Objects.requireNonNull(left, "left");
            Objects.requireNonNull(right, "right");
            Objects.requireNonNull(then, "then");
            this.add(Criterion.Le::new, left, right, then);
        }

        public <PROPERTY> void lt(PropertyMetamodel<PROPERTY> left, PropertyMetamodel<PROPERTY> right, PropertyMetamodel<RESULT> then) {
            Objects.requireNonNull(left, "left");
            Objects.requireNonNull(right, "right");
            Objects.requireNonNull(then, "then");
            this.add(Criterion.Lt::new, left, right, then);
        }

        public <PROPERTY> void isNull(PropertyMetamodel<PROPERTY> propertyMetamodel, PropertyMetamodel<RESULT> then) {
            Objects.requireNonNull(propertyMetamodel, "propertyMetamodel");
            Objects.requireNonNull(then, "then");
            this.add(Criterion.IsNull::new, propertyMetamodel, then);
        }

        public <PROPERTY> void isNotNull(PropertyMetamodel<PROPERTY> propertyMetamodel, PropertyMetamodel<RESULT> then) {
            Objects.requireNonNull(propertyMetamodel, "propertyMetamodel");
            Objects.requireNonNull(then, "then");
            this.add(Criterion.IsNotNull::new, propertyMetamodel, then);
        }

        private <PROPERTY> void add(BiFunction<Operand.Prop, Operand.Prop, Criterion> operator, PropertyMetamodel<PROPERTY> left, PropertyMetamodel<PROPERTY> right, PropertyMetamodel<RESULT> then) {
            Criterion criterion = operator.apply(new Operand.Prop(left), new Operand.Prop(right));
            CaseExpression.this.criterionList.add(new Pair<Criterion, Operand.Prop>(criterion, new Operand.Prop(then)));
        }

        private <PROPERTY> void add(Function<Operand.Prop, Criterion> operator, PropertyMetamodel<PROPERTY> propertyMetamodel, PropertyMetamodel<RESULT> then) {
            Criterion criterion = operator.apply(new Operand.Prop(propertyMetamodel));
            CaseExpression.this.criterionList.add(new Pair<Criterion, Operand.Prop>(criterion, new Operand.Prop(then)));
        }
    }
}

