/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.expression;

import java.util.Objects;
import org.seasar.doma.jdbc.criteria.context.Operand;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.entity.EntityPropertyType;

public interface ArithmeticExpression<PROPERTY>
extends PropertyMetamodel<PROPERTY> {

    public static interface Visitor {
        public void visit(Add<?> var1);

        public void visit(Sub<?> var1);

        public void visit(Mul<?> var1);

        public void visit(Div<?> var1);

        public void visit(Mod<?> var1);
    }

    public static class Mod<PROPERTY>
    extends AbstractArithmeticExpression<PROPERTY> {
        public Mod(PropertyMetamodel<?> propertyMetamodel, Operand left, Operand right) {
            super(propertyMetamodel, left, right);
        }

        @Override
        public String getName() {
            return "%";
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Div<PROPERTY>
    extends AbstractArithmeticExpression<PROPERTY> {
        public Div(PropertyMetamodel<?> propertyMetamodel, Operand left, Operand right) {
            super(propertyMetamodel, left, right);
        }

        @Override
        public String getName() {
            return "/";
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Mul<PROPERTY>
    extends AbstractArithmeticExpression<PROPERTY> {
        public Mul(PropertyMetamodel<?> propertyMetamodel, Operand left, Operand right) {
            super(propertyMetamodel, left, right);
        }

        @Override
        public String getName() {
            return "*";
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Sub<PROPERTY>
    extends AbstractArithmeticExpression<PROPERTY> {
        public Sub(PropertyMetamodel<?> propertyMetamodel, Operand left, Operand right) {
            super(propertyMetamodel, left, right);
        }

        @Override
        public String getName() {
            return "-";
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Add<PROPERTY>
    extends AbstractArithmeticExpression<PROPERTY> {
        public Add(PropertyMetamodel<?> propertyMetamodel, Operand left, Operand right) {
            super(propertyMetamodel, left, right);
        }

        @Override
        public String getName() {
            return "+";
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static abstract class AbstractArithmeticExpression<PROPERTY>
    implements ArithmeticExpression<PROPERTY> {
        private final PropertyMetamodel<?> propertyMetamodel;
        public final Operand left;
        public final Operand right;

        protected AbstractArithmeticExpression(PropertyMetamodel<?> propertyMetamodel, Operand left, Operand right) {
            this.propertyMetamodel = Objects.requireNonNull(propertyMetamodel);
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public Class<?> asClass() {
            return this.propertyMetamodel.asClass();
        }

        @Override
        public EntityPropertyType<?, ?> asType() {
            return this.propertyMetamodel.asType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractArithmeticExpression)) {
                return false;
            }
            AbstractArithmeticExpression that = (AbstractArithmeticExpression)o;
            return this.propertyMetamodel.equals(that.propertyMetamodel) && this.left.equals(that.left) && this.right.equals(that.right);
        }

        public int hashCode() {
            return Objects.hash(this.propertyMetamodel, this.left, this.right);
        }
    }
}

