/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;

public interface Projection {
    public <R> R accept(Visitor<R> var1);

    public static interface Visitor<R> {
        public R visit(EntityMetamodels var1);

        public R visit(PropertyMetamodels var1);
    }

    public static class PropertyMetamodels
    implements Projection {
        public final List<PropertyMetamodel<?>> propertyMetamodels;

        public PropertyMetamodels(PropertyMetamodel<?> ... propertyMetamodels) {
            this(Arrays.asList(propertyMetamodels));
        }

        public PropertyMetamodels(List<PropertyMetamodel<?>> propertyMetamodels) {
            Objects.requireNonNull(propertyMetamodels);
            this.propertyMetamodels = Collections.unmodifiableList(propertyMetamodels);
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static class EntityMetamodels
    implements Projection {
        public final Map<EntityMetamodel<?>, List<PropertyMetamodel<?>>> map = new LinkedHashMap();

        public EntityMetamodels(EntityMetamodel<?> entityMetamodel) {
            Objects.requireNonNull(entityMetamodel);
            this.map.put(entityMetamodel, entityMetamodel.allPropertyMetamodels());
        }

        public EntityMetamodels(EntityMetamodel<?> entityMetamodel, List<PropertyMetamodel<?>> propertyMetamodels) {
            Objects.requireNonNull(entityMetamodel);
            Objects.requireNonNull(propertyMetamodels);
            this.map.put(entityMetamodel, Collections.unmodifiableList(propertyMetamodels));
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }
}

