/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.command;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.function.Function;
import org.seasar.doma.internal.jdbc.command.ScriptReader;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.AbstractSql;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.ScriptException;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.SqlParameter;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.query.ScriptQuery;

public class ScriptCommand
implements Command<Void> {
    protected final ScriptQuery query;
    protected ScriptException savedScriptException;

    public ScriptCommand(ScriptQuery query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    @Override
    public ScriptQuery getQuery() {
        return this.query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute() {
        Config config = this.query.getConfig();
        Connection connection = JdbcUtil.getConnection(config.getDataSource());
        try (ScriptReader reader = new ScriptReader(this.query);){
            String script = reader.readSql();
            while (script != null) {
                ScriptSql sql = new ScriptSql(script, this.query.getScriptFilePath(), this.query.getSqlLogType(), this.query::comment);
                Statement statement = JdbcUtil.createStatement(connection);
                try {
                    this.log(sql);
                    this.setupOptions(statement);
                    statement.execute(script);
                }
                catch (Exception e) {
                    if (this.query.getHaltOnError()) {
                        throw new ScriptException(e, sql, reader.getLineNumber());
                    }
                    if (this.savedScriptException == null) {
                        this.savedScriptException = new ScriptException(e, sql, reader.getLineNumber());
                    }
                }
                finally {
                    JdbcUtil.close(statement, config.getJdbcLogger());
                }
                script = reader.readSql();
            }
        }
        finally {
            JdbcUtil.close(connection, config.getJdbcLogger());
        }
        this.throwSavedScriptExceptionIfExists();
        return null;
    }

    protected void log(ScriptSql sql) {
        JdbcLogger logger = this.query.getConfig().getJdbcLogger();
        logger.logSql(this.query.getClassName(), this.query.getMethodName(), sql);
    }

    protected void setupOptions(Statement statement) throws SQLException {
        if (this.query.getQueryTimeout() > 0) {
            statement.setQueryTimeout(this.query.getQueryTimeout());
        }
    }

    protected void throwSavedScriptExceptionIfExists() {
        if (this.savedScriptException != null) {
            throw this.savedScriptException;
        }
    }

    protected static class ScriptSql
    extends AbstractSql<SqlParameter> {
        public ScriptSql(String rawSql, String sqlFilePath, SqlLogType sqlLogType, Function<String, String> converter) {
            super(SqlKind.SCRIPT, rawSql, rawSql, sqlFilePath, Collections.emptyList(), sqlLogType, converter);
        }
    }
}

