/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.builder.BatchInsertExecutor;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class MapBatchInsertBuilder {
    private final BatchInsertExecutor executor;
    private final String tableName;

    private MapBatchInsertBuilder(Config config, String tableName) {
        this.executor = BatchInsertExecutor.newInstance(config);
        this.executor.callerClassName(this.getClass().getName());
        this.tableName = tableName;
    }

    public static MapBatchInsertBuilder newInstance(Config config, String tableName) {
        if (config == null) {
            throw new DomaNullPointerException("config");
        }
        if (tableName == null) {
            throw new DomaNullPointerException("tableName");
        }
        return new MapBatchInsertBuilder(config, tableName);
    }

    public int[] execute(Iterable<? extends Map<String, Object>> parameter) {
        if (parameter == null) {
            throw new DomaNullPointerException("parameter");
        }
        if (!parameter.iterator().hasNext() || parameter.iterator().next() == null) {
            throw new JdbcException((MessageResource)Message.DOMA2232, new Object[0]);
        }
        if (this.executor.getMethodName() == null) {
            this.executor.callerMethodName("execute");
        }
        LinkedHashSet<String> keySet = new LinkedHashSet<String>(parameter.iterator().next().keySet());
        int keySetSize = keySet.size();
        return this.executor.execute(parameter, (map, builder) -> {
            if (keySetSize != map.size()) {
                throw new JdbcException((MessageResource)Message.DOMA2231, new Object[0]);
            }
            builder.sql("insert into ").sql(this.tableName).sql(" (").sql(String.join((CharSequence)", ", keySet)).sql(")");
            builder.sql("values (");
            keySet.forEach(key -> {
                if (!map.containsKey(key)) {
                    throw new JdbcException((MessageResource)Message.DOMA2233, key);
                }
                Object value = map.get(key);
                if (value == null) {
                    builder.param(Object.class, null).sql(", ");
                } else {
                    Class<?> clazz = value.getClass();
                    builder.param(clazz, value).sql(", ");
                }
            });
            builder.removeLast().sql(")");
        });
    }

    public void queryTimeout(int queryTimeout) {
        this.executor.queryTimeout(queryTimeout);
    }

    public void sqlLogType(SqlLogType sqlLogType) {
        this.executor.sqlLogType(sqlLogType);
    }

    public void batchSize(int batchSize) {
        this.executor.batchSize(batchSize);
    }

    public void callerClassName(String className) {
        this.executor.callerClassName(className);
    }

    public void callerMethodName(String methodName) {
        if (methodName == null) {
            throw new DomaNullPointerException("methodName");
        }
        this.executor.callerMethodName(methodName);
    }

    public List<? extends Sql<?>> getSqls() {
        return this.executor.getSqls();
    }
}

